% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_piped_name.R
\name{get_piped_name}
\alias{get_piped_name}
\title{get piped name}
\usage{
get_piped_name(objName, default_name = "Title")
}
\arguments{
\item{objName}{an object}

\item{default_name}{default name if object name is not able to be accessed in case of a long pipe}
}
\value{
string
}
\description{
this function captures the name of an object piped into a function, and returns as a string. Powers the automatic naming found in presenter.
}
\details{
citation: \url{https://michaelbarrowman.co.uk/post/getting-a-variable-name-in-a-pipeline/}
}
\examples{

## works if the object is piped or given as an argument
iris \%>\%
get_piped_name

get_piped_name(iris)

## does not work for multistep pipes. instead the 'default_name' is printed
iris \%>\%
dplyr::select(1:3) \%>\%
get_piped_name
}
