% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample-size.r
\name{treatment_effect_size}
\alias{treatment_effect_size}
\title{Treatment Effect Back Calculation}
\usage{
treatment_effect_size(
  N,
  power,
  sigma2,
  alpha = 0.05,
  theta = 0.5,
  xi = 1,
  nstrata = 1
)
}
\arguments{
\item{N}{overall study sample size.}

\item{power}{desired study power. Should be numeric value between 0 and 1.}

\item{sigma2}{variance estimate. Should be positive numeric values. If study
is stratified, should be vector of within-stratum variances 
with length equal to the number of strata in the study.}

\item{alpha}{desired type I error rate.}

\item{theta}{proportion of patients assigned to choice arm in the initial
randomization. Should be numeric value between
0 and 1 (default=0.5).}

\item{xi}{a numeric vector of the proportion of patients in each stratum. 
Length of vector should equal the number of strata in the study and 
sum of vector should be 1. All vector elements should be numeric 
values between 0 and 1. Default is 1 (i.e. unstratified design).}

\item{nstrata}{number of strata. Default is 1 (i.e. unstratified design).}
}
\description{
Calculates the treatment effect that can be detected given a desired study 
power and overall study sample size for the two-stage randomized design
}
\examples{
treatment_effect_size(N=300, power=0.9, sigma2=c(1,0.8), xi=c(0.3,0.7), 
                      nstrata=2)
}
