% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qp_pi.R
\name{qp_pi}
\alias{qp_pi}
\title{Simple uncalibrated prediction intervals for quasi-Poisson data}
\usage{
qp_pi(
  newoffset,
  histoffset,
  lambda,
  phi,
  q = qnorm(1 - 0.05/2),
  alternative = "both",
  newdat = NULL,
  histdat = NULL,
  algorithm = NULL
)
}
\arguments{
\item{newoffset}{number of experimental units in the future clusters}

\item{histoffset}{number of experimental units in the historical clusters}

\item{lambda}{overall Poisson mean}

\item{phi}{dispersion parameter}

\item{q}{quantile used for interval calculation}

\item{alternative}{either "both", "upper" or "lower"
\code{alternative} specifies, if a prediction interval or
an upper or a lower prediction limit should be computed}

\item{newdat}{additional argument to specify the actual data set}

\item{histdat}{additional argument to specify the historical data set}

\item{algorithm}{used to define the algorithm for calibration if called via
\code{quasi_pois_pi()}. This argument is not of interest for the calculation
of simple uncalibrated intervals}
}
\value{
\code{qp_pi} returns an object of class \code{c("predint", "quasiPoissonPI")}.
}
\description{
\code{qp_pi()} is a helper function that is internally called by  \code{quasi_pois_pi()}. It
calculates simple uncalibrated prediction intervals for Poisson
data with constant overdispersion (quasi-Poisson assumption).
}
\details{
This function returns a simple uncalibrated prediction interval
\deqn{[l,u]_m = n^*_m \hat{\lambda} \pm q \sqrt{n^*_m \hat{\phi} \hat{\lambda} +
 \frac{n^{*2}_m \hat{\phi} \hat{\lambda}}{\sum_h n_h}}}

with \eqn{n^*_m} as the number of experimental units in the \eqn{m=1, 2, ... , M} future clusters,
\eqn{\hat{\lambda}} as the estimate for the Poisson mean obtained from the
historical data, \eqn{\hat{\phi}} as the estimate for the dispersion parameter
and \eqn{n_h} as the number of experimental units per historical cluster. \cr

The direct application of this uncalibrated prediction interval to real life data
is not recommended. Please use the \code{quasi_pois_pi_pi()} functions for real life applications.
}
\examples{
# Prediction interval
qp_pred <- qp_pi(newoffset=3, lambda=3, phi=3, histoffset=1:9, q=qnorm(1-0.05/2))
summary(qp_pred)

}
