% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_input_info.R
\name{pred_input_info}
\alias{pred_input_info}
\title{Input information about an existing prediction model}
\usage{
pred_input_info(
  model_type = c("logistic", "survival"),
  model_info,
  cum_hazard = NULL
)
}
\arguments{
\item{model_type}{specifies the type of model that the existing prediction
model is based on; possible options are: \itemize{ \item {\code{"logistic"}
indicates that the existing model was based on a logistic regression model
(default)} \item {\code{"survival"} indicates that the existing model was
based on a survival regression model} } If multiple models are being
entered, then all models need to be of the same type - otherwise call
function multiple times for each type of model.}

\item{model_info}{a data.frame that contains the coefficients of the existing
prediction model(s). Each column should be a predictor variable (with the
name of the column being the name of the predictor variable), with the
values being the coefficients, taken exactly as published from the existing
prediction model(s). Multiple existing prediction models should be
specified by entering multiple rows. If a predictor variable is not present
in a given model then enter that cell of the data.frame as NA. See
examples.}

\item{cum_hazard}{A data.frame with two columns: (1) time, and (2) estimated
cumulative baseline hazard at that time. The first column (time) should be
named 'time' and the second (cumulative baseline hazard) should be named
'hazard'. Only relevant if \code{model_type} is "survival"; leave as NULL
otherwise. If multiple existing models entered, and model_type = survival,
then \code{cum_hazard} should be supplied as list of length equal to number
of models.}
}
\value{
\code{\link{pred_input_info}} returns an object of class
"\code{predinfo}", with child classes per \code{model_type}. This is a
standardised format, such that it can be used with other functions in the
package. An object of class "\code{predinfo}" is a list containing the
following components:
\itemize{ \item{M = the number of existing models that information has been
entered about} \item{model_type = this is the type of model that
the existing prediction model is based upon ("logistic" or "survival")}
\item{coefs = this is the set of (previously estimated) coefficients for
each predictor variable} \item{coef_names = gives the names of each
predictor variable} \item{formula = this is the functional form of the
model's linear predictor} \item{cum_hazard = if supplied, this is the
cumulative baseline hazard of the existing model(s)}}
}
\description{
Input coefficient information about one or multiple existing prediction
model(s), for use in other functions in the package.
}
\details{
This function will structure the relevant information about one or
more existing prediction model(s) into a standardised format, such that it
can be used within other functions in the package.

First, the existing prediction model(s) will have a functional form (i.e.
the linear predictor of the model); this will be taken as being a linear
combination of the variables specified by the columns of \code{model_info}.

Second, each of the predictor variables of the existing prediction model(s)
will have a published coefficient (e.g. log-odds-ratio or
log-hazard-ratio), which should each be given as the values of
\code{model_info}. If entering information about multiple existing
prediction models, then \code{model_info} will contain multiple rows (one
per existing model). Here, if a given model does not contain a predictor
variable that is included in another model, then set as NA; see examples of
this below.

In the case of \code{model_type} = "logistic", then \code{model_info} must
contain a column named as "Intercept", which gives the intercept
coefficient of each of the existing logistic regression models (taken
exactly as previously published); this should be the first column of
\code{model_info}.

If \code{model_type} = "survival", then the baseline cumulative hazard of
the model(s) can be specified in \code{cum_hazard}. If the baseline
cumulative hazard of the existing survival model is not available, then
leave as NULL; this will limit any validation metrics that can be
calculated.

Note, the column names of \code{model_info} should match columns in any new
data that the existing model(s) will be applied to (i.e. any new data that
will be provided to other functions within the package should have
corresponding predictor variables entered through \code{model_info}). See
\code{\link{pred_predict}}, \code{\link{pred_validate}},
\code{\link{pred_update}} and \code{\link{pred_stacked_regression}} for
more information.
}
\examples{
#Example 1 - logistic regression existing model
# create a data.frame of the model coefficients, with columns being variables
coefs_table <- data.frame("Intercept" = -3.4,
                          "SexM" = 0.306,
                          "Smoking_Status" = 0.628,
                          "Diabetes" = 0.499,
                          "CKD" = 0.538)
#pass this into pred_input_info()
Existing_Logistic_Model <- pred_input_info(model_type = "logistic",
                                           model_info = coefs_table)
summary(Existing_Logistic_Model)

#Example 2 - survival model example; uses an example dataset within the
#             package.
pred_input_info(model_type = "survival",
                model_info = SYNPM$Existing_TTE_models[2,],
                cum_hazard = SYNPM$TTE_mod2_baseline)

#Example 3 - Input information about multiple models
summary(pred_input_info(model_type = "logistic",
                        model_info = SYNPM$Existing_logistic_models))

}
