% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcd.r
\name{pcd}
\alias{pcd}
\title{Precipitation Concentration Degree}
\usage{
pcd(object)
}
\arguments{
\item{object}{a daily or monthly precipitation serie.}
}
\value{
A data.frame containing the following variables:
\itemize{
\item \code{year} is the year.
\item \code{pcd} is the percentage of precipitation concentration corresponding to a year. 
Values closer to 0 mean precipitation dispersion among all months and 1 concentration into only a month.
}
}
\description{
Calculates the Precipitation Concentration Degree (PCD) on a 
daily or monthly precipitation serie.
}
\examples{
##
# Loading the monthly precipitation serie.
data(monthly)

## 
# Performing the Precipitation Concentration Index analysis
pcd(monthly)
}
\author{
Lucas Venezian Povoa \email{lucasvenez@gmail.com}
}
\references{
Zhang LJ, Qian YF (2003) Annual distribution features of precipitation in China and their interannual variations. 
J Acta Meteorological Sinica 17:146-163
}
\seealso{
\code{\link{pplot.pcd}}
\code{\link{read.data}}
\code{\link{as.daily}}
\code{\link{as.monthly}}
}
\keyword{PCD}
\keyword{concentration}
\keyword{degree}
\keyword{precipitation}

