% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/as.seasonal.r
\name{as.seasonal}
\alias{as.precintcon.seasonal}
\alias{as.seasonal}
\title{Convert a precipitation serie to an seasonal serie}
\usage{
as.seasonal(object)
}
\arguments{
\item{object}{a precintcon.daily, or precintcon.monthly object or
a data.frame containing 33 or 3 columns.}
}
\value{
A data.frame (precintcon.seasonal) containing the following variables:
\itemize{
\item \code{year} is the year.
\item \code{season} is the season.
\item \code{precipitation} is the precipitation amount in millimeters.
}
}
\description{
Converts a daily or monthly precipitation serie
to a seasonal serie.
}
\examples{
##
# Loading the daily precipitation serie.
data(daily)

##
# Converting precipitation
as.seasonal(daily)
}
\author{
Lucas Venezian Povoa \email{lucasvenez@gmail.com}
}
\seealso{
\code{\link{pplot.lorenz}}
\code{\link{read.data}}
}
\keyword{precipitation}
\keyword{seasonal}

