% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dutycycle.R
\name{plot_dutycycle}
\alias{plot_dutycycle}
\title{Plot duty cycle from performance report on a parallel computation}
\usage{
plot_dutycycle(perftab, ..., FUN = c(workers = sum), layout = c(1, NA))
}
\arguments{
\item{perftab}{A performance table with columns:
\itemize{
\item \code{pid} An integer, character or factor with process ids
\item \code{t1}, \code{t2} Task start and end times, in milliseconds
}}

\item{...}{Optional parameters passed along to \code{lattice::xyplot}}

\item{FUN}{A function for summarizing all workers' duty cycles}

\item{layout}{Trellis layout, passed to \code{xyplot}}
}
\value{
An \code{xyplot} with a duty-cycle panel for each worker,
plus an overall average
}
\description{
This is intended for application to the tables which get attached
to \code{Cpe} instances after invocation of the \verb{$trace_paths()} method.
But any table with columns named \code{pid}, \code{t1} and \code{t2} suffices.
}
\examples{
if (interactive()) {
  ## Example from Braun2020
  d1_maxn <- 5
  cum_maxn <- 10
  mod <- Crm$new(skeleton = c(0.03, 0.11, 0.25, 0.42, 0.58, 0.71),
                 scale = 0.85, # aka 'sigma'
                 target = 0.25)$
    no_skip_esc(TRUE)$    # compare Braun's 'restrict = T'
    no_skip_deesc(FALSE)$
      stop_func(function(x) {
        enrolled <- tabulate(x$level, nbins = length(x$prior))
        x$stop <- enrolled[1] >= d1_maxn || max(enrolled) >= cum_maxn
        x
      })
  mod$trace_paths(1, rep(2, 13), unroll = 4
                , mc.cores = parallelly::availableCores(omit=2))
  print(mod$performance)
  plot_dutycycle(mod$performance)
}
}
