% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_trials.R
\name{extend}
\alias{extend}
\title{Extend an existing simulation, using one of several stopping criteria}
\usage{
extend(sims, num_sims = NULL, target_mcse = 0.05)
}
\arguments{
\item{sims}{An existing object of class \code{c('precautionary','simulations')}}

\item{num_sims}{Optionally, a fixed number of additional replications to accumulate}

\item{target_mcse}{Optionally, an MCSE constraint to be imposed on expected counts
of DLTs, non-DLTs, and Total enrollment.}
}
\value{
An extended simulation of same class as \code{sims}.
}
\description{
A trial simulation carried through a predetermined number of replications
may not achieve desired precision as judged by Monte Carlo standard errors
(MCSE) of estimated toxicity counts. This method enables simulations of
class \code{c('precautionary','simulations')} to be extended until a given
level of precision has been achieved on expected counts of enrollment and
DLTs, or (optionally) for a fixed additional number of simulations.
}
\note{
The MCSE constraint is imposed during trial \emph{simulation}, at which
point only \emph{binary} toxicities are available. Thus, as a practical matter,
\code{extend} can target MCSEs only for DLTs, non-DLTs and Total enrollment.
The subsequent subdivision of these categories during trial \emph{summary}
(at which point the ordinalizer comes into play along with its parameters) thus
may generate expected counts with MCSEs exceeding \code{target_mcse}.
In practice, however, this tends to affect the estimated counts only for the
\emph{lowest} toxicity grades---those of least concern from a trial-safety
perspective.
}
\seealso{
See examples under \link{simulate_trials} and \link{format.safetytab}.
}
