% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extendr-wrappers.R
\name{crmh}
\alias{crmh}
\alias{crmht}
\alias{crmht2}
\title{Rust implementation of \verb{dfcrm::crmh*} integrands}
\usage{
crmh(a, ln_x, w, s)

crmht(a, ln_x, w, s)

crmht2(a, ln_x, w, s)
}
\arguments{
\item{a}{Numeric vector of evaluation points}

\item{ln_x}{A numeric vector of dose-wise prior log-probabilities of toxicity}

\item{w}{Patient-wise weights (used for TITE CRM), also encoding toxicity
by \code{w[i] == 0.0}.}

\item{s}{Scalar scale factor}
}
\description{
Rust implementation of \verb{dfcrm::crmh*} integrands
}
\section{Functions}{
\itemize{
\item \code{crmh}: Posterior for 1-parameter empiric (aka 'power') model

\item \code{crmht}: Integrand for 1st moment of empiric posterior

\item \code{crmht2}: Integrand for 2nd moment of empiric posterior
}}

