% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crm.R
\name{Crm-class}
\alias{Crm-class}
\alias{Crm}
\title{An R6 class encapsulating CRM models

This class wraps the functionality of package \CRANpkg{dfcrm}, adding
efficient Rust implementations of some numerical routines.}
\description{
An R6 class encapsulating CRM models

This class wraps the functionality of package \CRANpkg{dfcrm}, adding
efficient Rust implementations of some numerical routines.

An R6 class encapsulating CRM models

This class wraps the functionality of package \CRANpkg{dfcrm}, adding
efficient Rust implementations of some numerical routines.
}
\details{
Syntactically, the method chaining supported by R6 classes makes the
invocation of CRM models more transparent. The mutability conferred
by reference semantics enables memoization (caching) of results, which
can speed up DTP calculations significantly.

Presently, this class supports only the 'empiric' (aka 'power') model.
But it is hoped that inheritance will assist in rendering other models
implemented in package \CRANpkg{dfcrm} clearly, with code reuse.
}
\note{
This specializes the superclass set/get method, consistent
with the non-mutable number of doses of CRM with fixed skeleton.
}
\examples{

## ------------------------------------------------
## Method `Crm$new`
## ------------------------------------------------

# An example verbatim from dfcrm::crm()
prior <- c(0.05, 0.10, 0.20, 0.35, 0.50, 0.70)
target <- 0.2
level <- c(3, 4, 4, 3, 3, 4, 3, 2, 2, 2)
y     <- c(0, 0, 1, 0, 0, 1, 1, 0, 0, 0)
s <- sqrt(1.34)
old <- dfcrm::crm(prior, target, y, level)
new <- Crm$new(skeleton = prior, target = target)$
         dontcache()$
         observe(level, y)$
         est(impl="rusti", abbrev=FALSE)
}
\section{Super class}{
\code{\link[precautionary:Cpe]{precautionary::Cpe}} -> \code{Crm}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Crm$new()}}
\item \href{#method-max_dose}{\code{Crm$max_dose()}}
\item \href{#method-skeleton}{\code{Crm$skeleton()}}
\item \href{#method-dontcache}{\code{Crm$dontcache()}}
\item \href{#method-report}{\code{Crm$report()}}
\item \href{#method-stop_func}{\code{Crm$stop_func()}}
\item \href{#method-no_skip_esc}{\code{Crm$no_skip_esc()}}
\item \href{#method-no_skip_deesc}{\code{Crm$no_skip_deesc()}}
\item \href{#method-global_coherent_esc}{\code{Crm$global_coherent_esc()}}
\item \href{#method-conf_level}{\code{Crm$conf_level()}}
\item \href{#method-observe}{\code{Crm$observe()}}
\item \href{#method-tally}{\code{Crm$tally()}}
\item \href{#method-est}{\code{Crm$est()}}
\item \href{#method-applied}{\code{Crm$applied()}}
\item \href{#method-clone}{\code{Crm$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="precautionary" data-topic="Cpe" data-id="J">}\href{../../precautionary/html/Cpe.html#method-J}{\code{precautionary::Cpe$J()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="precautionary" data-topic="Cpe" data-id="bU">}\href{../../precautionary/html/Cpe.html#method-bU}{\code{precautionary::Cpe$bU()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="precautionary" data-topic="Cpe" data-id="path_array">}\href{../../precautionary/html/Cpe.html#method-path_array}{\code{precautionary::Cpe$path_array()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="precautionary" data-topic="Cpe" data-id="path_matrix">}\href{../../precautionary/html/Cpe.html#method-path_matrix}{\code{precautionary::Cpe$path_matrix()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="precautionary" data-topic="Cpe" data-id="path_probs">}\href{../../precautionary/html/Cpe.html#method-path_probs}{\code{precautionary::Cpe$path_probs()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="precautionary" data-topic="Cpe" data-id="path_rx">}\href{../../precautionary/html/Cpe.html#method-path_rx}{\code{precautionary::Cpe$path_rx()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="precautionary" data-topic="Cpe" data-id="trace_paths">}\href{../../precautionary/html/Cpe.html#method-trace_paths}{\code{precautionary::Cpe$trace_paths()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Crm$new(skeleton, scale = sqrt(1.34), target)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{skeleton}}{CRM skeleton}

\item{\code{scale}}{Sigma parameter of prior on beta parameter}

\item{\code{target}}{Target toxicity rate}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Create a new \code{Crm} object.
}

\subsection{Returns}{
A \code{Crm} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# An example verbatim from dfcrm::crm()
prior <- c(0.05, 0.10, 0.20, 0.35, 0.50, 0.70)
target <- 0.2
level <- c(3, 4, 4, 3, 3, 4, 3, 2, 2, 2)
y     <- c(0, 0, 1, 0, 0, 1, 1, 0, 0, 0)
s <- sqrt(1.34)
old <- dfcrm::crm(prior, target, y, level)
new <- Crm$new(skeleton = prior, target = target)$
         dontcache()$
         observe(level, y)$
         est(impl="rusti", abbrev=FALSE)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-max_dose"></a>}}
\if{latex}{\out{\hypertarget{method-max_dose}{}}}
\subsection{Method \code{max_dose()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Crm$max_dose(D)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{D}}{Included to match signature of superclass method.
It is an error to call this method with non-missing \code{D} parameter.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Return number of prespecified doses
}

\subsection{Returns}{
Length of CRM skeleton.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-skeleton"></a>}}
\if{latex}{\out{\hypertarget{method-skeleton}{}}}
\subsection{Method \code{skeleton()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Crm$skeleton(skeleton)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{skeleton}}{A numeric vector to set as the model skeleton.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Set or query CRM skeleton
}

\subsection{Returns}{
Self (invisibly), unless \code{skeleton} is missing,
in which case the skeleton, a numeric vector, is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dontcache"></a>}}
\if{latex}{\out{\hypertarget{method-dontcache}{}}}
\subsection{Method \code{dontcache()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Crm$dontcache()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Set private cache to NULL; useful for performance testing
}

\subsection{Returns}{
Self, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-report"></a>}}
\if{latex}{\out{\hypertarget{method-report}{}}}
\subsection{Method \code{report()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Crm$report(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional arguments specifying columns to add to report}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Report lifetime duty & performance statistics
}

\subsection{Returns}{
A named vector summarizing lifetime duty and performance
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-stop_func"></a>}}
\if{latex}{\out{\hypertarget{method-stop_func}{}}}
\subsection{Method \code{stop_func()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Crm$stop_func(sfunc)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sfunc}}{A function taking \code{mtd} objects to \code{mtd} objects,
attaching suitable stopping information}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Set the stopping function
}

\subsection{Returns}{
Self, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-no_skip_esc"></a>}}
\if{latex}{\out{\hypertarget{method-no_skip_esc}{}}}
\subsection{Method \code{no_skip_esc()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Crm$no_skip_esc(tf)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tf}}{An atomic logical value, TRUE or FALSE}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Set the \code{no_skip_esc} behavior
}

\subsection{Returns}{
Self, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-no_skip_deesc"></a>}}
\if{latex}{\out{\hypertarget{method-no_skip_deesc}{}}}
\subsection{Method \code{no_skip_deesc()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Crm$no_skip_deesc(tf)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tf}}{An atomic logical value, TRUE or FALSE}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Set the \code{no_skip_deesc} behavior
}

\subsection{Returns}{
Self, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-global_coherent_esc"></a>}}
\if{latex}{\out{\hypertarget{method-global_coherent_esc}{}}}
\subsection{Method \code{global_coherent_esc()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Crm$global_coherent_esc(tf)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tf}}{An atomic logical value, TRUE or FALSE}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Set the \code{global_coherent_esc} behavior
}

\subsection{Returns}{
Self, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-conf_level"></a>}}
\if{latex}{\out{\hypertarget{method-conf_level}{}}}
\subsection{Method \code{conf_level()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Crm$conf_level(conf)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{conf}}{A numeric confidence less than 1.0}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Set the required confidence level for escalation decisions
}

\subsection{Returns}{
Self, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-observe"></a>}}
\if{latex}{\out{\hypertarget{method-observe}{}}}
\subsection{Method \code{observe()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Crm$observe(level, tox)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{level}}{A patient-wise vector of dose assignments}

\item{\code{tox}}{A patient-wise vector of 0/1 toxicity assessments}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Set patient-wise toxicity observations
}

\subsection{Returns}{
Self, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tally"></a>}}
\if{latex}{\out{\hypertarget{method-tally}{}}}
\subsection{Method \code{tally()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Crm$tally(x, o)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{A dose-wise vector of toxicity counts}

\item{\code{o}}{A dose-wise vector of non-toxicity counts}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Set dose-wise toxicity observations
}

\subsection{Returns}{
Self, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-est"></a>}}
\if{latex}{\out{\hypertarget{method-est}{}}}
\subsection{Method \code{est()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Crm$est(impl = "rusti", abbrev = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{impl}}{A string choosing the low-level implementation to use.
Possible values include \code{"dfcrm"}, \code{"rusti"} and \code{"ruste"}.}

\item{\code{abbrev}}{Logical; if TRUE (the default), an abbreviated \code{mtd}
object is returned to save execution time. If FALSE, a complete object is
returned, suitable for regression testing against package \CRANpkg{dfcrm}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Estimate the model
}

\subsection{Returns}{
An object of class \code{mtd} as per package \CRANpkg{dfcrm}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-applied"></a>}}
\if{latex}{\out{\hypertarget{method-applied}{}}}
\subsection{Method \code{applied()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Crm$applied(x, o, last_dose = NA, max_dose = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{A dose-wise vector of toxicity counts}

\item{\code{o}}{A dose-wise vector of non-toxicity counts}

\item{\code{last_dose}}{The most recently given dose, as required to implement
the \code{global_coherent_esc=TRUE} behavior}

\item{\code{max_dose}}{Unused; included for compatibility with superclass method
of required \code{impl} parameter and optional \code{abbrev} flag.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Return dose recommendation for given tox/no-tox tallies.

This function caches results, which greatly saves computation time
in CPE -- yielding e.g. a 5x speedup for the VIOLA trial example.
}

\subsection{Returns}{
An object of class \code{mtd} as per package \CRANpkg{dfcrm},
or possibly an abbreviated version of such object as returned by
method \code{Crm$est()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Crm$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
