% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre.R
\name{bsnullinteract}
\alias{bsnullinteract}
\title{Compute bootstrapped null interaction prediction rule ensembles}
\usage{
bsnullinteract(object, nsamp = 10, parallel = FALSE,
  penalty.par.val = "lambda.1se", verbose = FALSE)
}
\arguments{
\item{object}{object of class \code{\link{pre}}.}

\item{nsamp}{numeric. Number of bootstrapped null interaction models to be
derived.}

\item{parallel}{logical. Should parallel foreach be used to generate initial
ensemble? Must register parallel beforehand, such as doMC or others.}

\item{penalty.par.val}{character or numeric. Which value of the penalty 
parameter criterion should be used? The value yielding minimum cv error
(\code{"lambda.min"}) or penalty parameter yielding error within 1 standard
error of minimum cv error ("\code{lambda.1se}")? Alternatively, a numeric 
value may be specified, corresponding to one of the values of lambda in the 
sequence used by glmnet, for which estimated cv error can be inspected by 
inspecting \code{object$glmnet.fit} and running 
\code{plot(object$glmnet.fit)}.}

\item{verbose}{logical. should progress be printed to the command line?}
}
\value{
A list of length \code{nsamp} with null interaction models, to be
used as input for \code{\link{interact}}.
}
\description{
\code{bsnullinteract} generates bootstrapped null interaction models,
which can be used to derive a reference distribution of the test statistic
calculated with \code{\link{interact}}.
}
\details{
Computationally intensive.
}
\examples{
\donttest{set.seed(42)
airq.ens <- pre(Ozone ~ ., data=airquality[complete.cases(airquality),])
nullmods <- bsnullinteract(airq.ens)
interact(airq.ens, nullmods = nullmods, col = c("#7FBFF5", "#8CC876"))}
}
\seealso{
\code{\link{pre}}, \code{\link{interact}}
}
