% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_ppmf_links}
\alias{get_ppmf_links}
\title{Get PPMF File Links}
\usage{
get_ppmf_links(version = "19", release = "06.08.2021", compressed = TRUE)
}
\arguments{
\item{version}{string in '19', '12' or '4' signifying the 19.61, 12.2, or 4.5 versions respectively}

\item{release}{string. Ignored. Options are '06.08.2021' and '04.28.2021'.}

\item{compressed}{boolean. Return a compressed version (TRUE). FALSE gives the
Census Bureau link to the uncompressed data.}
}
\value{
a string with url
}
\description{
Returns the urls for the data. This will be expanded to link to prior or
any new releases.
}
\examples{
# 04.28.2021 version 12.2
get_ppmf_links()
# 04.28.2021 version 4.5
get_ppmf_links(version = '4')
}
\concept{getdata}
