% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppendemic_data.R
\docType{data}
\name{ppendemic_tab13}
\alias{ppendemic_tab13}
\title{ppendemic_tab: Endemic Plant Database of Peru}
\format{
A tibble (data frame) with 7815 rows and 14 columns:
\describe{
\item{version}{Character vector. The version of ppendemic database, same id as POWO database.}
\item{version_date}{Character vector. The version date of POWO database.}
\item{taxon_name}{Character vector. The accepted name of the endemic
plant species.}
\item{taxon_status}{Character vector.}
\item{family}{Character vector. The family of the accepted name
of the endemic plant species.}
\item{Genus}{Character vector.}
\item{Species}{Character vector.}
\item{infraspecific_rank}{Character vector.}
\item{infraspecies}{Character vector.}
\item{taxon_authors}{Character vector. The author(s) of the accepted
name of the endemic plant species.}
\item{prinmary_author}{Character vector. The author(s) of the publication
containing the endemic plant species information.}
\item{place_of_publication}{Character vector. The place of publication of
the endemic plant species information.}
\item{volume_and_page}{Character vector. The volume and page number of the
publication containing the endemic plant species information.}
\item{first_published}{Character vector. The first published year of the
publication containing the endemic plant species information.}
}
}
\source{
The dataset has been carefully compiled and updated to offer the latest
insights into Peru's endemic plant species. Original sources of the data include
authoritative botanical publications and research articles available in the WCVP
database.
}
\usage{
ppendemic_tab13
}
\description{
The ppendemic_tab dataset is a tibble (data frame) that provides easy access
to a comprehensive database of Peru's endemic plant species. It contains a total
of 7,249 records with essential botanical information, including the accepted
name, accepted family, accepted name author, publication author, place of
publication, volume and page, and first published details.
}
\details{
The dataset provides a curated and up-to-date collection of Peru's
endemic plant species, gathered from reputable botanical sources and publications.
The data for this database was extracted and compiled from the World Checklist
of Vascular Plants (WCVP) database, which is a comprehensive and reliable
repository of botanical information.

Researchers, botanists, ecologists, and nature enthusiasts can use this dataset
to explore and study the unique and diverse flora exclusive to Peru. The dataset
is particularly valuable for conducting studies related to biodiversity,
conservation, and ecological research.
}
\examples{

# Load the package
library(ppendemic)

# Access the dataset
data("ppendemic_tab13")


}
\keyword{dataset}
