% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ztest.2samp.R
\name{ztest.2samp}
\alias{ztest.2samp}
\title{Power calculation for two-sample z test}
\usage{
ztest.2samp(
  n1 = NULL,
  n.ratio = 1,
  delta = NULL,
  sd1 = 1,
  sd.ratio = 1,
  alpha = 0.05,
  power = NULL,
  sides = 2,
  v = FALSE
)
}
\arguments{
\item{n1}{The sample size for group 1.}

\item{n.ratio}{The ratio n2/n1 between the sample sizes of two groups; defaults to 1 (equal group sizes).}

\item{delta}{DeltaA (true difference mu1 - mu2) - Delta0 (difference under the null). For a noninferiority
or superiority by a margin test,
the margin should be subtracted, that is, delta = DeltaA - Delta0 - margin.}

\item{sd1}{The standard deviation for group 1; defaults to 1 (equal standard deviations in the two groups).}

\item{sd.ratio}{The ratio sd2/sd1 between the standard deviations of the two groups.}

\item{alpha}{The significance level (type 1 error rate); defaults to 0.05.}

\item{power}{The specified level of power.}

\item{sides}{Either 1 or 2 (default) to specify a one- or two- sided hypothesis test.}

\item{v}{Either TRUE for verbose output or FALSE (default) to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
This function performs power and sample size calculations for a two-sample z test. which is
analogous to a two-sample t test but with the variances assumed to be known.
The function allows for unequal sample sizes and/or variances in the two groups.
This function is provided largely for pedagogical purposes; in general,
for real studies, the two-sample t test procedure should be used.
}
\details{
For a noninferiority or superiority by a margin test, the margin should be subtracted
as part of the specification of delta and a one-sided test should be used. See Crespi (2025)
for specific guidance.
}
\examples{
ztest.2samp(n1 = NULL, n.ratio = 1, delta = 0.5, sd1 = 1, power = 0.8, sides = 2)
}
