% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova1way.F.bal.R
\name{anova1way.F.bal}
\alias{anova1way.F.bal}
\title{Power calculation for balanced one-way ANOVA omnibus F test}
\usage{
anova1way.F.bal(
  n = NULL,
  mvec = NULL,
  sd = 1,
  Rsq = 0,
  ncov = 0,
  alpha = 0.05,
  power = NULL,
  v = FALSE
)
}
\arguments{
\item{n}{The sample size per group.}

\item{mvec}{A vector of group means c(mu1, mu2, ...).}

\item{sd}{The estimated standard deviation within each group; defaults to 1.}

\item{Rsq}{The estimated R^2 for regressing the outcome on the covariates; defaults to 0.}

\item{ncov}{The number of covariates adjusted for in the model; defaults to 0.}

\item{alpha}{The significance level or type 1 error rate; defaults to 0.05.}

\item{power}{The specified level of power.}

\item{v}{Either TRUE for verbose output or FALSE to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
This function performs power and sample size calculations for the overall (omnibus) F test
in a balanced (equal-sized groups) one-way analysis of variance (ANOVA). Can be used to solve for
power, n (sample size per group), or alpha.
For an unbalanced one-way
ANOVA F test (that is, unequal group sample sizes), use 'anova1way.F.unbal'.
For contrast tests in a one-way ANOVA, see 'anova1way.c.bal' and 'anova1way.c.unbal'.
}
\examples{
anova1way.F.bal(n = 20, mvec = c(5, 10, 12), sd = 10)
anova1way.F.bal(n = NULL, mvec = c(-0.25, 0.25), sd = 1, Rsq = 0.5^2, ncov = 1, power = 0.8)
}
