% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explusV3.R
\name{explus}
\alias{explus}
\title{Scalar Exponentiation}
\usage{
explus(a, numer, denom = 1, n.cycles = 10, tol = 1e-12)
}
\arguments{
\item{a}{any base (real or complex). It can be a vector.}

\item{numer}{numerator of exponent. Can be a decimal or complex number.}

\item{denom}{denominator of exponent (1 by default). Can be a decimal or complex number.}

\item{n.cycles}{The maximum number of steps to be used in the continued fraction approximation process done internally.
Default is 10. Increasing this default may increase precision, but it may also produce unexpected results (even a runtime error).}

\item{tol}{a tolerance, \eqn{10^{-12}}{10^-12} by default. Prevents possible numerical problems.
Can be set to 0 if desired.}
}
\value{
The solution to the exponentiation operation supplied. Returns a real-valued root whenever possible.
Otherwise, the principal complex root.
}
\description{
Raises any base (real or complex) to any power (even complex).
}
\details{
Method based on numerical treatment of complex exponents using Euler Formula and angles
measured in radians, which is the default method built-in in R.
}
\examples{
explus(-3, 4, 2)
explus(-3, 2, 4)
explus(-3, 2, 3)
explus(-3, 5, 3)
explus(-3, 5, 2)
explus(-3, -2, 4)
explus(0-0.5773503i, 2)
explus(-0.4, pi)
explus(-0.37, 0.2)
explus(-0.37, 1, 5)
explus(5, 7i)
explus(2+3i, 1+2i)
explus(2+3i, 1+2i, -4+1i)
explus(2+3i, 1+2i, 8)

}
\references{
For more on Euler Formula, visit
\url{http://mathworld.wolfram.com/EulerFormula.html}

For more on complex exponents, visit
\url{http://mathworld.wolfram.com/ComplexExponentiation.html}
}
\author{
Albert Dorador
}
