% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_XY.R
\name{sim_XY}
\alias{sim_XY}
\title{simulate data matrix under the alternative hypothesis}
\usage{
sim_XY(out, n, seed = 123, post.transformation = TRUE, A)
}
\arguments{
\item{out}{output from \code{PLSc}}

\item{n}{number of observations to simulate}

\item{seed}{seed value}

\item{post.transformation}{Boolean value. Default @TRUE i.e., post transformation is applied.}

\item{A}{number of score components used in \code{PLSc}.}
}
\value{
Returns a simulated matrix under the alternative hypothesis.
}
\description{
simulate data matrix under the alternative hypothesis
}
\examples{
datas <- simulatePilotData(nvar = 10, clus.size = c(5,5),m = 6,nvar_rel = 5,A = 2)
out <- PLSc(X = datas$X, Y = datas$Y, A = 2)
out_sim <- sim_XY(out = out, n = 10, A = 2)
}
\author{
Angela Andreella
}
