% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/potential.R
\name{potential}
\alias{potential}
\title{Compute the Potential Model}
\usage{
potential(x, y, d, var, fun, span, beta)
}
\arguments{
\item{x}{an sf object (POINT), the set of known observations to
estimate the potentials from.}

\item{y}{an sf object (POINT), the set of unknown units for which
the function computes the estimates.}

\item{d}{a distance matrix between known observations and unknown
units for which the function computes the estimates. Row names match the row
names of \code{x} and column names match the row names of
\code{y}. \code{d} can contain any distance metric (time
distance or euclidean distance for example).}

\item{var}{names of the variables in \code{x} from which potentials are
computed. Quantitative variables with no negative values.}

\item{fun}{spatial interaction function. Options are "p"
(pareto, power law) or "e" (exponential).
For pareto the interaction is defined as: (1 + alpha * mDistance) ^ (-beta).
For "exponential" the interaction is defined as:
exp(- alpha * mDistance ^ beta).
The alpha parameter is computed from parameters given by the user
(\code{beta} and \code{span}).}

\item{span}{distance where the density of probability of the spatial
interaction function equals 0.5.}

\item{beta}{impedance factor for the spatial interaction function.}
}
\value{
If only one variable is computed a vector is returned, if more than
one variable is computed a matrix is returned.
}
\description{
This function computes the potential mo^del as defined
by J.Q. Stewart (1941).
}
\examples{
library(sf)
y <- create_grid(x = n3_poly, res = 200000)
d <- create_matrix(n3_pt, y)
pot <- potential(
  x = n3_pt, y = y, d = d, var = "POP19",
  fun = "e", span = 200000, beta = 2
)
y$OUTPUT <- pot
equipot <- equipotential(y, var = "OUTPUT", mask = n3_poly)
plot(equipot["center"], pal = hcl.colors(nrow(equipot), "cividis"))
}
\references{
STEWART, JOHN Q. 1941. "An Inverse Distance Variation for Certain Social
Influences." \emph{Science} 93 (2404): 89–90.
\url{https://doi.org/10.1126/science.93.2404.89}.
}
