% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PHENO_1.plot.R
\name{pheno.plot}
\alias{pheno.plot}
\title{View phenotype variables}
\usage{
pheno.plot(
  inputFN,
  outFN = paste("plot_", inputFN, ".pdf", sep = ""),
  csv = TRUE,
  sep = " ",
  start = 3,
  read = TRUE,
  logFN = NULL,
  track = TRUE
)
}
\arguments{
\item{inputFN}{\code{character} Input file name or input data}

\item{outFN}{\code{character} Output pdf file name for the plots}

\item{csv}{\code{logical}  Specify if input file is a CSV file. Default is TRUE.}

\item{sep}{\code{character} Separator between columns. Default is space. If csv=TRUE, this will not be used.}

\item{start}{\code{number} The location of the first phenotype variable starts in the input file.}

\item{read}{\code{logical}  Specify if inputFN is a file name or a data. Default is TRUE when inputFN is a file name.}

\item{logFN}{\code{character}  File name of the log file. Default is NULL, while logFN=paste(inputFN,".log",sep="") in the function.}

\item{track}{\code{logical}   Specify if the intermediate results is printed when the function was executed. Default is TRUE.}
}
\value{
Files were written to the current directory. One is .pdf file for plots and the other is .log file for variable description.
}
\description{
This R script will generate plot for each variable and write description to a log file.
}
