#' Data for goldcrest from the Swedish Bird Survey.
#'
#' Transect count survey data for goldcrest from the Swedish Bird Survey from 1998 to 2012.
#'
#'
#' @format A data frame with 5728 rows and 9 columns.
#' \itemize{
#'   \item count Total transect count.
#'   \item site Site identity.
#'   \item year Year of the survey.
#'   \item observerAge Age of the observer.
#'   \item day Day of season.
#'   \item firstSurvey A binary variable which is 1 
#'         if the route was surveyed for the first time 
#'         by the observer in that year, and 0 otherwise.
#'   \item latitude Latitude of the transect.
#'   \item lineCov The percentage of the transect that was surveyed.
#' }
#' @source \url{http://www.fageltaxering.lu.se/english}
"goldcrest"

#' Data for greenfinch from the Swedish Bird Survey.
#'
#' Transect count survey data for greenfinch from the Swedish Bird Survey from 1998 to 2012.
#'
#'
#' @format A data frame with 5728 rows and 9 columns.
#' \itemize{
#'   \item count Total transect count.
#'   \item site Site identity.
#'   \item year Year of the survey.
#'   \item observerAge Age of the observer.
#'   \item day Day of season.
#'   \item firstSurvey A binary variable which is 1 
#'         if the route was surveyed for the first time 
#'         by the observer in that year, and 0 otherwise.
#'   \item latitude Latitude of the transect.
#'   \item lineCov The percentage of the transect that was surveyed.
#' }
#' @source \url{http://www.fageltaxering.lu.se/english}
"greenfinch"