\name{map.convergence}
\alias{map.convergence}
\title{SOM Quality Assessment}
\description{Evaluate the quality of a SOM using embedding and estimated topographic accuracy.}
\usage{
map.convergence(map,conf.int=.95,k=50,verb=FALSE,ks=TRUE)
}
\arguments{
  \item{map}{an object of type 'map'.}
  \item{conf.int}{is the confidence interval of the quality assessment (default 95\%)}
  \item{k}{number of samples to use in the computation of the estimated topographical accuracy (default=50)}
  \item{verb}{if true reports the two convergence components separately, otherwise it will report a linear combination of the two indices (default=FALSE)}
  \item{ks}{if true uses the Kolmogorov-Smirnov convergence test otherwise a convergence test based on variance and means is performed (default=TRUE)}
}  
\value{
	A single value or a pair of values: 1) embedding accuracy 2) estimated topographic accuracy.
		}
\references{
"SOM Quality Measures: A Statistical Approach," 
Lutz Hamel, WSOM16, 2016. 
}
\author{Lutz Hamel}
\examples{
data(iris)

## set data frame and labels
df <- subset(iris,select=-Species)
labels <- subset(iris,select=Species)

## build a map
m <- map.build(df, labels, xdim=15, ydim=10, train=1000)

## map quality
map.convergence(m)

}
