% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poolvar_t.R
\name{poolvar_t}
\alias{poolvar_t}
\title{Visualize Ratio of Variance of Each Pooled Measurement to Variance of Each
Unpooled Measurement as Function of Pool Size}
\usage{
poolvar_t(g = 1:10, sigsq = 1, sigsq_p = 0, sigsq_m = 0,
  multiplicative = FALSE, mu = 1, type = "two.sample", assay_cost = 100,
  other_costs = 0, labels = TRUE, ylim = NULL)
}
\arguments{
\item{g}{Numeric vector of pool sizes to include.}

\item{sigsq}{Numeric value specifying the variance of observations.}

\item{sigsq_p}{Numeric value specifying the variance of processing errors.}

\item{sigsq_m}{Numeric value specifying the variance of measurement errors.}

\item{multiplicative}{Logical value for whether to assume multiplicative
rather than additive errors.}

\item{mu}{Numeric value specifying the larger of the two suspected means.
Only used if \code{multiplicative = TRUE}.}

\item{type}{Character string specifying type of t-test. Choices are
\code{"two.sample"}, \code{"one.sample"}, and \code{"paired"}.}

\item{assay_cost}{Numeric value specifying cost of each assay.}

\item{other_costs}{Numeric value specifying other per-subject costs.}

\item{labels}{Logical value.}

\item{ylim}{Numeric vector.}
}
\value{
Plot generated by \code{\link[ggplot2]{ggplot}}.
}
\description{
Useful for determining whether pooling is a good idea, and finding the
optimal pool size if it is.
}
\examples{
# Plot ratio of variances vs. pool size with default settings
poolvar_t()

# Add processing error and other per-subject costs
poolvar_t(sigsq_p = 0.2, other_costs = 0.1)


}
