% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ABC.R
\name{organize.poststat}
\alias{organize.poststat}
\title{Organize point estimates from multiple posterior distributions}
\usage{
organize.poststat(posterior_stats)
}
\arguments{
\item{posterior_stats}{is a list where each entry corresponds to a different
trial i.e. each entry contains the information obtained for a different
target for ABC parameter estimation. Each entry should be a matrix
containing, in each row, the "mode", "median" and "mean" of the posterior
distribution for each of the parameters.}
}
\value{
a list with the following elements:

\item{mode}{mode of the posterior for each target and parameter.}

\item{median}{median of the posterior for each target and parameter.}

\item{mean}{mean of the posterior for each target and parameter.}
}
\description{
Combines the point estimates of multiple posterior distributions into more
easily read matrices.
}
\details{
This is a purely organizational function that combines the mode, median and
mean point estimates of multiple posterior distributions into its own matrix.
Thus, each point estimate will have its own unique matrix. For instance, this
will create a "median" matrix with the median of each posterior.
}
\keyword{internal}
