% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eff_sample_size.R
\name{eff.sample.size}
\alias{eff.sample.size}
\alias{eff.sample.size,missing-method}
\alias{eff.sample.size,ANY-method}
\alias{eff.sample.size-bsmcd_pomp}
\alias{eff.sample.size,bsmcd_pomp-method}
\alias{eff.sample.size-pfilterd_pomp}
\alias{eff.sample.size,pfilterd_pomp-method}
\alias{eff.sample.size-wpfilterd_pomp}
\alias{eff.sample.size,wpfilterd_pomp-method}
\title{Effective sample size}
\usage{
\S4method{eff.sample.size}{bsmcd_pomp}(object, ...)

\S4method{eff.sample.size}{pfilterd_pomp}(object, ...)

\S4method{eff.sample.size}{wpfilterd_pomp}(object, ...)
}
\arguments{
\item{object}{result of a filtering computation}

\item{...}{ignored}
}
\description{
Estimate the effective sample size of a Monte Carlo computation.
}
\details{
Effective sample size is computed as
\deqn{\left(\sum_i\!w_{it}^2\right)^{-1},}{1/(sum(w_it^2)),}
where \eqn{w_{it}}{w_it} is the normalized weight of particle \eqn{i} at time \eqn{t}.
}
\seealso{
More on particle-filter based methods in \pkg{pomp}: 
\code{\link{bsmc2}()},
\code{\link{cond.logLik}()},
\code{\link{filter.mean}()},
\code{\link{filter.traj}()},
\code{\link{kalman}},
\code{\link{mif2}()},
\code{\link{pfilter}()},
\code{\link{pmcmc}()},
\code{\link{pred.mean}()},
\code{\link{pred.var}()},
\code{\link{saved.states}()},
\code{\link{wpfilter}()}
}
\concept{particle_filter_methods}
