require(pomp)

dat <- '"time";"X";"Y"
0;1;1,07952841598157
1;0,950636618475229;1,11861594539405
2;0,83244916029991;0,828286900987495
3;0,93103099656842;1,13600466557311
4;0,911439385512777;0,806676551188204
5;0,837105441016674;0,873084434929483
6;1,00268501398128;1,04124835021771
7;1,06579807727341;1,05979968381669
8;1,04671681272393;1,14368595456944
9;1,01143788899437;1,17581280964431
10;1,12153364435953;1,16125775736251
11;1,23274218227861;1,22891596556583
12;1,32655395564463;1,38234823254117
13;1,35069512981151;1,13856582462482
14;1,13875163542966;1,10278598215362
15;1,26066897039704;1,29730413792106
16;1,24543791707035;1,33112792763266
17;1,23134905281316;1,20013316479374
18;1,15533668996193;1,1748481850297
19;1,19423810951996;1,37677723538777
20;1,20635310746995;1,30467220974374
21;1,04307227953634;0,933048055379677
22;1,04107912990884;1,08563062740614
23;1,00318246871677;1,02180297594675
24;0,970849938478495;1,25099936514459
25;0,79243164319502;0,79761814762639
26;0,771762127953167;0,68253288426557
27;0,760988977405389;0,785573183621746
28;0,836517935205031;0,880032437134315
29;0,7939171601806;0,817662333089958
30;0,723293224297652;0,682204778379272
31;0,775999242794153;0,609158268599648
32;0,801813842772822;0,953075868457542
33;0,76994574267228;0,64000611215012
34;0,746021978630474;0,824778708853423
35;0,81336335287903;0,75477831785326
36;0,923882876057083;1,05020086682025
37;1,02216853265321;1,07915643829565
38;0,953397077328701;0,910377207219948
39;1,01222135734455;1,07196221241156
40;0,978288274555936;0,927402543398725
41;1,07783628249536;1,13562270683309
42;1,18185012207163;1,15138433126514
43;0,952520534180798;0,979766621130238
44;0,84439364958955;0,932583376950161
45;0,85025855989352;0,874190322172554
46;0,868591242831582;0,917317195376153
47;0,96734181848679;0,810217908784557
48;0,90424208054782;0,91751282983596
49;0,77998160754507;0,777229472252738
50;0,807245881695201;0,984536558782125
51;0,796994124555762;0,829289645018853
52;0,811536735801658;0,738549113698673
53;0,817376297833073;0,751664773418347
54;0,911274275731693;0,901320737117393
55;1,09671858179842;1,02114400728858
56;1,17782304259497;1,15480952716325
57;1,48974254173377;1,52171146422867
58;1,59363218853134;1,60303998339523
59;1,33894250041079;1,3673888909755
60;1,24282152770653;1,07557075960246
61;1,21473587944885;1,26679772028961
62;1,31898738946143;1,22392737161959
63;1,45195233453426;1,40639369164472
64;1,58364437767931;1,61885414154031
65;1,60727226980948;1,70623639556045
66;1,55648312498095;1,87962959035064
67;1,66568956879442;1,73633383185204
68;1,71151559987914;1,59157235244771
69;1,53634236355877;1,58129601393277
70;1,62285253887348;1,66169160756609
71;1,27898023105463;1,35952077984963
72;1,1818761514106;1,22549784715231
73;1,09002630947639;1,2025122303878
74;1,2232879353834;1,25096891846816
75;1,43006968443063;1,41018069268411
76;1,41189860111872;1,43675715990225
77;1,55201995283258;1,44229999201853
78;1,45818570565819;1,38883706742128
79;1,22002519977696;1,25058856058262
80;1,23865238275549;1,23288019435894
81;1,48621496132753;1,58848483557968
82;1,36483886467245;1,23628960315986
83;1,51299070383272;1,60393599831722
84;1,25759262244331;1,1541357227336
85;1,19746015105645;1,35609775043505
86;1,05742547057021;0,855756862528805
87;1,22304508672589;1,38718382523001
88;1,25379301734834;1,24797305664899
89;1,13949050640685;1,35307215916429
90;0,817425730431819;0,970652163066452
91;0,802233823759296;0,847914335870894
92;0,857912063302802;0,897827069767532
93;1,05787680391846;1,16338321886402
94;1,05448994160666;1,04849780806396
95;1,11773425002073;1,02168552045925
96;1,03321705886828;1,23012631227719
97;0,985172093658399;1,06931864474828
98;0,942026595214108;1,14999282942163
99;1,16257505590149;0,972309774206453
100;1,28071364632546;1,23495259845453
'

pomp(
     data=subset(read.csv2(text=dat),select=-X),
     times="time",
     t0=0,
     params=c(K=1,r=0.1,sigma=0.1,tau=0.1,X.0=1),
     rprocess=discrete.time.sim(
       step.fun="_gompertz_simulator"
       ),
     rmeasure="_gompertz_normal_rmeasure",
     dmeasure="_gompertz_normal_dmeasure",
     skeleton.type="map",
     skeleton="_gompertz_skeleton",
     paramnames=c("r","K","sigma","tau"),
     statenames=c("X"),
     obsnames=c("Y"),
     parameter.transform=function(params,...){
       exp(params)
     },
     parameter.inv.transform=function(params,...){
       log(params)
     }
     ) -> gompertz

## the following was used to create the data included
## simulate(po,nsim=1,seed=299438676L) -> gompertz

c("gompertz")
