require(pomp)

dat <- '"time";"obs"
0,1;12476,9463966376
0,2;10728,2422378213
0,3;11398,0776385115
0,4;12287,9670238814
0,5;9012,37523428899
0,6;8452,39753669702
0,7;9704,7441287775
0,8;8963,78424859124
0,9;7829,66389402983
1;7655,43492706061
1,1;9309,04592787201
1,2;7946,94132184123
1,3;12108,6790891141
1,4;14198,8647151384
1,5;12927,6349958936
1,6;16760,392326066
1,7;11420,2006149761
1,8;12798,0730275012
1,9;11126,6555465736
2;12268,966760168
2,1;12889,140814792
2,2;15717,842837741
2,3;16476,4476949001
2,4;13935,8229597974
2,5;11274,5690427355
2,6;12038,307109693
2,7;16606,6627272479
2,8;18198,4621610355
2,9;17293,0054680149
3;12523,849186477
3,1;10313,2154355352
3,2;9321,36401435259
3,3;10799,8076207109
3,4;10178,8374334587
3,5;10045,1158889129
3,6;11025,1281020003
3,7;10169,2849982066
3,8;8681,07015468727
3,9;10732,796788325
4;11036,7965511601
4,1;11868,8147354882
4,2;13625,7117038416
4,3;11265,4772635401
4,4;10141,6251649885
4,5;10867,4578828498
4,6;12785,2102229267
4,7;11328,7462817584
4,8;12631,6392612663
4,9;11990,4877952651
5;11707,021358751
5,1;11467,9348717264
5,2;11138,9674897421
5,3;10828,0402696172
5,4;10693,5753292854
5,5;8070,20512554236
5,6;7974,66822200446
5,7;12124,8774955935
5,8;10571,6897970932
5,9;10408,3525902188
6;9947,10683615605
6,1;6761,26080348258
6,2;7672,5615626058
6,3;6700,89947532411
6,4;9957,70955089761
6,5;6984,15360685567
6,6;8711,27713852725
6,7;8845,09832738289
6,8;6151,45542760105
6,9;5909,9033310504
7;5677,0462793129
7,1;4685,26869088051
7,2;6081,7401479026
7,3;5140,81107070182
7,4;5987,21047593122
7,5;5958,39974011806
7,6;5797,10888222691
7,7;8969,30480435117
7,8;7154,13424413776
7,9;7001,79895206227
8;6835,58722221115
8,1;7178,49582555569
8,2;7068,30093611577
8,3;7477,13697964531
8,4;8772,554138563
8,5;8022,86659094765
8,6;8372,0317907956
8,7;10041,3593267306
8,8;10253,050990357
8,9;9043,82119751564
9;10045,5914827808
9,1;8645,9514960239
9,2;7587,78596251839
9,3;8050,67704946183
9,4;12766,8084185733
9,5;11320,2397899506
9,6;11983,2137256095
9,7;10346,5261277883
9,8;10976,0207971127
9,9;10596,5951721337
10;12354,9165211917
10,1;13176,0001734934
10,2;10787,1844790958
10,3;9016,89457113492
10,4;9591,14684777673
10,5;9326,59125815507
10,6;8400,48447975349
10,7;8103,47670668761
10,8;6850,46195015796
10,9;8523,22233334717
11;7320,06708241798
11,1;6761,31990109052
11,2;10335,7413628739
11,3;8452,63560033498
11,4;7651,84663783688
11,5;10973,5604541944
11,6;9445,95763629494
11,7;10218,29998992
11,8;7766,96969085216
11,9;7792,66151934471
12;11724,2680465198
12,1;9046,55821600569
12,2;7933,82281121758
12,3;8494,97595285483
12,4;12847,3887298016
12,5;10294,8960103345
12,6;15253,0634118407
12,7;14400,4899470299
12,8;12691,4502676006
12,9;12476,3346535563
13;11290,0609563828
13,1;11593,0442976639
13,2;11445,9423045149
13,3;10381,2431323292
13,4;11264,5376923105
13,5;11285,9320427566
13,6;10710,3502098923
13,7;10396,059083809
13,8;10729,9941311348
13,9;8584,80968880257
14;9123,06769305207
14,1;9551,82625036035
14,2;12759,0676102405
14,3;10886,7202223913
14,4;8689,0430008371
14,5;8601,59754664362
14,6;9227,67154381367
14,7;10759,4161716665
14,8;8701,93376658181
14,9;8694,06775689441
15;7120,05485126926
15,1;7871,86018020619
15,2;11325,3190917209
15,3;11031,3141538231
15,4;8537,06017947308
15,5;7721,65289483558
15,6;12768,3261913139
15,7;11373,8084037005
15,8;7561,75216737958
15,9;9022,9974341319
16;10469,6335508079
16,1;12518,4220722121
16,2;15126,603804632
16,3;11534,1997794343
16,4;13622,6376508151
16,5;9752,91900516775
16,6;9571,21351591001
16,7;7344,68254397997
16,8;7597,08688114403
16,9;5829,235899961
17;5346,16678188154
17,1;5653,51588369056
17,2;4013,32857668548
17,3;5341,62826889271
17,4;5337,97795220073
17,5;4758,90474968552
17,6;3707,93581860354
17,7;5146,90259738539
17,8;4741,19590656026
17,9;4381,03681098208
18;5283,89194896795
18,1;5977,00409400307
18,2;5080,90486298864
18,3;5700,55920879932
18,4;5067,57442433348
18,5;5969,1004674428
18,6;5943,39373403795
18,7;7872,16036106282
18,8;7176,37802849479
18,9;6773,32638300943
19;6576,68995103676
19,1;6302,66909129431
19,2;8409,6290202459
19,3;8110,29631442576
19,4;6230,32936264843
19,5;7030,42554727497
19,6;8209,18759666583
19,7;9345,93343556614
19,8;7744,4408105053
19,9;8674,56078556814
20;9386,18815897299
20,1;5970,37048855152
20,2;8980,4210971737
20,3;10154,3104546652
20,4;8170,35370424287
20,5;8835,16412467681
20,6;7498,96166288369
20,7;5652,13634438877
20,8;5593,66362700379
20,9;5626,54486340093
21;6547,73225655557
21,1;7096,12518257777
21,2;8187,61397499477
21,3;7816,96018309476
21,4;9365,74592375056
21,5;8919,79510386407
21,6;11311,3544390941
21,7;12334,8818534128
21,8;12091,0402723564
21,9;10224,4460329214
22;10672,0533887018
22,1;10495,9906471543
22,2;7573,49486741521
22,3;8806,85834649576
22,4;9198,35221065198
22,5;9993,33431906456
22,6;10288,8725272112
22,7;9051,0076124758
22,8;8550,00334114443
22,9;7368,74316241947
23;8145,88224943311
23,1;11024,7919142578
23,2;9726,97632179983
23,3;11464,9267284175
23,4;11743,8728109547
23,5;9012,19675930479
23,6;9267,67553897285
23,7;9563,73866062666
23,8;10005,7522969854
23,9;9133,23696685598
24;9216,48900855386
24,1;10468,8746182724
24,2;9110,06864599419
24,3;10841,7518151104
24,4;12174,1893998248
24,5;13070,8058195246
24,6;11698,4516180048
24,7;11905,0519445065
24,8;9876,34239469928
24,9;12551,5200696618
25;9365,74240446989
25,1;6017,63591596322
25,2;7640,65921225047
25,3;5316,22529995531
25,4;8336,35554660404
25,5;7972,59496069947
25,6;6018,76020610333
25,7;5930,74680893522
25,8;8125,15276684146
25,9;6321,26849791774
26;7958,72797913122
26,1;9461,90822052943
26,2;8020,43480175057
26,3;10615,6672924436
26,4;7391,70620508135
26,5;8518,52900238336
26,6;7017,42000930683
26,7;7675,82085117962
26,8;10808,7105784239
26,9;10748,6491137723
27;10479,4609041952
27,1;10796,5170427456
27,2;10060,9111730096
27,3;9862,72499672297
27,4;10824,6714772015
27,5;12425,1994314164
27,6;10566,9979712047
27,7;15242,2310985226
27,8;15665,3710490534
27,9;15772,9985656924
28;20487,8144661072
28,1;18792,1801144891
28,2;21890,1242688365
28,3;17789,9278083276
28,4;12527,0593191164
28,5;9485,10170282966
28,6;9086,90637262223
28,7;8120,91418137307
28,8;6396,87622237125
28,9;8704,93793118881
29;6636,92325009947
29,1;7059,7275114992
29,2;9884,25516276591
29,3;7430,30889135978
29,4;7873,89272206418
29,5;7867,48892187301
29,6;10205,3190518609
29,7;8617,89343568966
29,8;8367,97516430218
29,9;7883,30701968611
30;11693,7127377259
30,1;11272,082746678
30,2;10597,3139796781
30,3;10221,468666787
30,4;9649,42170112549
30,5;9441,45104781857
30,6;7034,17260633305
30,7;6291,18674650048
30,8;7020,41233302552
30,9;7175,27956531368
31;5137,58723952299
31,1;5610,72021416387
31,2;6037,37933378762
31,3;5350,60575631053
31,4;4716,83497273108
31,5;5431,82706570032
31,6;5536,16390831763
31,7;6381,37876490288
31,8;6229,79583824138
31,9;6997,03740427396
32;11809,3722683047
32,1;12878,2027253708
32,2;12806,5885481948
32,3;8861,34414376624
32,4;9563,42807795813
32,5;7835,71085280059
32,6;11596,64632993
32,7;9941,61435212074
32,8;10652,7994903906
32,9;10737,9549762833
33;12558,8906120463
33,1;8979,50961185162
33,2;11293,5490293136
33,3;15476,7686330012
33,4;12958,4212233989
33,5;12817,6569678597
33,6;13388,4366814068
33,7;12698,1131571398
33,8;12154,8999203219
33,9;10509,7164307354
34;12567,8299055534
34,1;9648,8807880893
34,2;10848,7000406457
34,3;9219,05521552105
34,4;9321,56045456677
34,5;7898,3631363727
34,6;9060,06902573551
34,7;9898,09727439412
34,8;8210,08894889617
34,9;9599,78378335742
35;11854,9123261205
35,1;9925,397231923
35,2;11140,7100737521
35,3;9816,59464276197
35,4;10901,1451494259
35,5;10634,8415449419
35,6;9634,17841921968
35,7;10487,7551481321
35,8;8990,24352331104
35,9;8332,83815549775
36;8417,92866429414
36,1;6192,30093657545
36,2;6928,54602777178
36,3;8207,90424929284
36,4;6741,28696413681
36,5;7389,39354728816
36,6;6257,86927420529
36,7;6774,41840573745
36,8;4418,07727278885
36,9;6109,82762770082
37;7336,94874052948
37,1;6023,50754478991
37,2;6417,99273668786
37,3;6321,07640991656
37,4;6664,27718915005
37,5;7426,85616952988
37,6;7000,63296618831
37,7;7621,69045880012
37,8;6643,17095829111
37,9;10539,2362260966
38;9458,54273253344
38,1;9232,71599901011
38,2;7839,39459458997
38,3;14839,0426572895
38,4;11577,3620594544
38,5;10201,91094914
38,6;10991,0967331595
38,7;8224,04482027097
38,8;8856,90020551015
38,9;7453,46596616546
39;7524,12377272976
39,1;8737,01215046318
39,2;7686,35765818987
39,3;8855,54602424936
39,4;8262,02007098897
39,5;8619,28755950972
39,6;10252,8935594443
39,7;7776,16343583888
39,8;6858,67432567885
39,9;8760,61654710644
40;9622,97033404669
40,1;9921,0869260319
40,2;11844,7598216088
40,3;12945,6261794604
40,4;14825,1271602584
40,5;10508,5632563249
40,6;9798,12025726799
40,7;10267,0412454815
40,8;11354,5024437676
40,9;13326,9619205658
41;10274,890726593
41,1;8673,01309387427
41,2;8757,73021352446
41,3;9764,24066478204
41,4;10500,2582767496
41,5;12467,1317044053
41,6;11335,9342838068
41,7;9474,89463722844
41,8;11144,3234118078
41,9;10836,7300270209
42;11077,420427938
42,1;11799,5256118085
42,2;11023,0733084436
42,3;15344,2310305759
42,4;14599,413593436
42,5;15386,0648664141
42,6;14684,2261050675
42,7;15325,7884563881
42,8;19754,0861031911
42,9;16679,5671880502
43;13130,5469383685
43,1;16164,5991605316
43,2;13919,1677124579
43,3;12382,6488658348
43,4;14701,2437251083
43,5;11443,3546429148
43,6;9585,0565144986
43,7;8934,35681503501
43,8;11115,2308431103
43,9;10202,8710798149
44;11115,8212748502
44,1;12094,1881576191
44,2;13254,3758833824
44,3;15130,8798999096
44,4;11483,4484928252
44,5;13195,0721694759
44,6;10473,0754189766
44,7;13356,8460825789
44,8;11578,6930334603
44,9;12616,3321110414
45;12051,4699332613
45,1;14553,8975722223
45,2;10014,252007852
45,3;14087,4551199516
45,4;10327,5961599629
45,5;11928,1382657893
45,6;9052,63266829724
45,7;10698,955023338
45,8;10004,5113427391
45,9;6771,5545184479
46;8514,37984821228
46,1;6617,4714442464
46,2;8885,25370142548
46,3;9118,76931768063
46,4;7692,60376297994
46,5;7520,52415804022
46,6;6622,6016762273
46,7;6052,32308209712
46,8;7293,97788402771
46,9;6138,38815400682
47;4591,71737188944
47,1;5470,55674137514
47,2;5992,00573923157
47,3;6939,80299894226
47,4;7007,14556179378
47,5;5444,57759540926
47,6;6564,94840722865
47,7;6389,96846959213
47,8;8505,59827740137
47,9;6555,93874124059
48;6409,82467147517
48,1;6919,9851611954
48,2;5857,54645397159
48,3;7516,42411930509
48,4;9660,85589378418
48,5;7882,59464507283
48,6;7937,08813551117
48,7;8745,5436631991
48,8;9506,92561168197
48,9;9866,53718222788
49;9771,46296573487
49,1;7972,95801313969
49,2;9105,99477453911
49,3;8964,86495276766
49,4;8581,32803260173
49,5;8344,4219814017
49,6;7358,26859109201
49,7;5381,03593167284
49,8;7110,9006717466
49,9;6820,43360908152
50;8297,79230785321
50,1;7663,00203410761
50,2;7578,4007052904
50,3;7967,38267168311
50,4;7229,17182742463
50,5;6596,98676173792
50,6;6942,61425786679
50,7;7435,38304196609
50,8;6372,5087691826
50,9;6623,10789929817
51;6558,78603260941
51,1;7423,27083653525
51,2;12183,4777339393
51,3;7779,16129116554
51,4;12555,5842577588
51,5;11023,2217699979
51,6;8651,90043471913
51,7;9961,29264196097
51,8;8030,24504111739
51,9;10975,1742197206
52;8459,70762398174
52,1;9676,56491646763
52,2;7820,04980182388
52,3;10787,1933271458
52,4;9623,19765863186
52,5;9855,38025336279
52,6;8842,02859727836
52,7;11752,8214971606
52,8;8083,2807807658
52,9;7321,42312366985
53;8205,79844667963
53,1;9615,49843148054
53,2;9658,62633697096
53,3;7713,75569474053
53,4;12955,0848871974
53,5;10254,836212151
53,6;10444,5441836165
53,7;9827,2522704155
53,8;12885,7649577728
53,9;11223,6503199689
54;10903,4056935272
54,1;13019,1174217624
54,2;10921,6041856756
54,3;11231,5698171515
54,4;11381,7148489584
54,5;11025,7971771427
54,6;10754,3293580904
54,7;12806,2717596169
54,8;10607,6057399477
54,9;10243,6551139101
55;11627,7992637409
55,1;11554,967235077
55,2;11248,710823903
55,3;10609,4245068699
55,4;10207,0421438915
55,5;11511,6953168914
55,6;9922,16104578969
55,7;10446,3760608161
55,8;10476,1739647886
55,9;14907,2621095441
56;13681,2204033392
56,1;17719,7811548912
56,2;11565,4730437729
56,3;11000,5874259337
56,4;10935,3551309711
56,5;9790,68075500014
56,6;7717,58784432254
56,7;5805,16785056102
56,8;6720,09027920395
56,9;5057,14754323012
57;5787,6716885105
57,1;5812,2971133207
57,2;4985,56860134047
57,3;5710,95091127253
57,4;6432,79966438961
57,5;7065,30719329072
57,6;9685,13278810539
57,7;7986,78985544796
57,8;8685,07056222583
57,9;7219,04903411052
58;6213,93854335405
58,1;9857,94458422158
58,2;8680,61528628408
58,3;8250,9194865143
58,4;8491,30347817182
58,5;11860,2058396431
58,6;11774,6787839129
58,7;9061,59105982336
58,8;7393,79862469031
58,9;6824,8913201083
59;8115,88179748415
59,1;7827,50347141874
59,2;8835,09272260034
59,3;7588,84203395042
59,4;6846,34054572442
59,5;6873,97558814903
59,6;7805,83374545487
59,7;7687,28131537552
59,8;8346,75332138581
59,9;7407,37565574723
60;8329,52806493768
60,1;7261,42310700191
60,2;7312,21203058107
60,3;9040,66086102091
60,4;10493,644571701
60,5;10741,8304373751
60,6;9400,13489289287
60,7;7971,83973414781
60,8;10505,096939718
60,9;10174,5280652284
61;8961,95745119093
61,1;5669,11508784949
61,2;6407,04800074438
61,3;8050,83204948429
61,4;7255,61275788112
61,5;8184,24254935309
61,6;10146,7699666647
61,7;7814,09192485262
61,8;8114,97879829567
61,9;5973,24381661191
62;6509,96334300783
62,1;9265,71805030568
62,2;8449,07346056122
62,3;11410,5882935058
62,4;11571,0545840239
62,5;10518,7965063701
62,6;12505,2818804168
62,7;13583,0754408911
62,8;11716,7625724768
62,9;9743,15145841789
63;11159,3714619204
63,1;10725,7136583695
63,2;12489,0170100189
63,3;14724,0726294381
63,4;13225,1323407495
63,5;15210,5074706416
63,6;12408,5060482511
63,7;10423,4160804753
63,8;9852,51341647643
63,9;10859,251224785
64;11310,0309981004
64,1;10322,1740790313
64,2;9651,2503732872
64,3;10393,4605321383
64,4;10519,6621716649
64,5;9442,1104529839
64,6;10619,8876288285
64,7;7459,04054791979
64,8;8924,43582722977
64,9;9585,49354883113
65;8546,46477435247
65,1;9369,95910410088
65,2;11327,0195620211
65,3;10265,2535623682
65,4;10225,0353762898
65,5;12942,1275496785
65,6;13879,1700370883
65,7;11710,2515545662
65,8;10030,8698030822
65,9;10593,4007423685
66;9897,64771687591
66,1;10446,3186465722
66,2;11527,4668774637
66,3;10467,0972589471
66,4;6880,39688322924
66,5;7071,21501883189
66,6;9031,11573222015
66,7;8042,6525271921
66,8;8558,69169285023
66,9;7861,29160593894
67;8695,81984358475
67,1;9702,77188916079
67,2;11186,0949031785
67,3;11167,0910356868
67,4;11961,6696779951
67,5;10247,8322757368
67,6;8821,11960135626
67,7;8887,61165305998
67,8;6691,73279945521
67,9;7610,74447137737
68;9733,23566615167
68,1;9085,64090950561
68,2;10284,9550627579
68,3;10811,2916582545
68,4;9391,07226609754
68,5;12096,1050391271
68,6;11628,1420392599
68,7;13266,1259531116
68,8;10234,9314997338
68,9;9238,39818182283
69;8774,38633019121
69,1;9473,17889910746
69,2;10642,4441653773
69,3;10439,4764932204
69,4;13537,4356327428
69,5;13387,0204026066
69,6;12397,8465827829
69,7;11415,6763255387
69,8;11213,9686451852
69,9;13289,3403171439
70;10673,2874664237
70,1;10964,3907671097
70,2;10083,6308587883
70,3;9072,64020755984
70,4;8833,6705905021
70,5;10895,5437375126
70,6;11210,7420279216
70,7;14896,1558643885
70,8;13758,8134136559
70,9;14512,6330898726
71;13100,4131914116
71,1;16699,4044720392
71,2;16213,6434037868
71,3;14618,6070860439
71,4;19868,5152648034
71,5;19101,5738782585
71,6;13758,2601088466
71,7;13306,2314200894
71,8;11373,0895217935
71,9;12564,0158787171
72;13652,971104091
72,1;13649,198816615
72,2;10410,2680430208
72,3;9371,41925917821
72,4;10802,3451243264
72,5;10496,3777705406
72,6;10427,4529659678
72,7;8288,48084959863
72,8;7914,92356114429
72,9;7458,71296154734
73;7408,46299118695
73,1;10075,7675545749
73,2;8588,0297978611
73,3;10157,7622710703
73,4;10735,4916453127
73,5;11000,7086254733
73,6;12209,7124379228
73,7;11079,1235522696
73,8;10740,4077116903
73,9;11026,6343326999
74;9229,8528436727
74,1;8446,85186918626
74,2;9176,94484037695
74,3;8559,01899327047
74,4;10441,4143168649
74,5;7850,59989141906
74,6;6554,09778798869
74,7;7309,6387149569
74,8;7813,65258355211
74,9;6519,72537562819
75;7281,76820218333
75,1;6417,82387295662
75,2;8715,31455764381
75,3;9726,02860887345
75,4;6383,70636241777
75,5;5368,64993966141
75,6;6462,35462362343
75,7;6694,0620678292
75,8;6983,85535222503
75,9;7383,97726464175
76;6478,83490079305
76,1;7023,15474529047
76,2;4635,84389988871
76,3;5405,63894365854
76,4;5811,11956807765
76,5;7255,08805377115
76,6;4982,18157403915
76,7;5036,42395226714
76,8;4949,21470545351
76,9;6843,89425538785
77;7791,08031759526
77,1;7547,2423043476
77,2;7894,4013629537
77,3;8084,8471195441
77,4;7139,14603127704
77,5;6754,90483960691
77,6;5793,20224175837
77,7;6341,3764256013
77,8;5226,56337508388
77,9;9019,07349349038
78;11005,7499946334
78,1;6819,5439379699
78,2;9676,28715646289
78,3;10842,6511317926
78,4;9041,65774191533
78,5;8724,37746271774
78,6;10917,9976845158
78,7;9630,19704501064
78,8;10342,8641868793
78,9;9850,40333496814
79;14373,4791294866
79,1;10984,257476849
79,2;12523,6194478227
79,3;10359,7984539939
79,4;9388,50981538731
79,5;8792,06749187442
79,6;9887,25372677859
79,7;10240,0264327785
79,8;9414,49499511916
79,9;9409,1585806543
80;8256,27993117445
80,1;10109,9689986108
80,2;8810,75356093514
80,3;8487,8597620045
80,4;7314,70398989786
80,5;5954,64620612273
80,6;5472,0689570879
80,7;8516,9913583844
80,8;7028,70452497178
80,9;7176,70945013414
81;8836,04205086905
81,1;6833,37706122905
81,2;5772,81111567026
81,3;7917,01670397021
81,4;8887,21522534304
81,5;7128,22688216862
81,6;6935,91146287728
81,7;7367,82805560655
81,8;6217,58333853471
81,9;7014,73644082161
82;8027,46607023035
82,1;8010,91844945424
82,2;8347,2730173685
82,3;7783,89576145179
82,4;9525,36964179416
82,5;7306,71604886285
82,6;8175,47193642342
82,7;7670,36960543746
82,8;6771,53108893947
82,9;9666,46498036726
83;8998,20644570531
83,1;8799,23321073932
83,2;9731,35534497201
83,3;10903,0827800629
83,4;11164,545010449
83,5;11484,280309072
83,6;9318,51072620255
83,7;7887,53271831702
83,8;9972,34531975077
83,9;7875,75574454626
84;9588,93473056082
84,1;10657,4289683724
84,2;6907,34260389456
84,3;9271,65225838068
84,4;9349,66682883138
84,5;8155,00455217325
84,6;8858,99485261673
84,7;8176,16575854411
84,8;9364,3989893682
84,9;10949,699835543
85;14138,7514645031
85,1;14787,3977642603
85,2;11598,6661283384
85,3;9325,81565706009
85,4;9233,51516322209
85,5;8460,04326433859
85,6;9311,98132341824
85,7;10776,8249435738
85,8;9587,17800884098
85,9;13891,4904717529
86;12889,1070201789
86,1;17899,9902117379
86,2;17444,2285156656
86,3;18056,3503319583
86,4;15612,7072314106
86,5;14955,2208666585
86,6;16960,0784410482
86,7;13863,8866647341
86,8;12723,3032389705
86,9;9975,55118299347
87;12388,3676647969
87,1;10776,1904103485
87,2;10950,4769587152
87,3;12236,2263983746
87,4;11298,5375734901
87,5;12927,927633043
87,6;11003,1795197235
87,7;8144,08718193333
87,8;12301,0507511971
87,9;12951,1207543641
88;11685,0785172223
88,1;8637,63532902613
88,2;13055,3331803727
88,3;11323,0791653795
88,4;9988,510777286
88,5;10599,1227751211
88,6;11886,1728367984
88,7;14181,1200974492
88,8;13586,1479808546
88,9;10954,066919755
89;10983,4105494501
89,1;7923,28294630162
89,2;10740,1482794747
89,3;9286,04975328939
89,4;9067,96496157309
89,5;12697,2495647524
89,6;14011,9776483089
89,7;13802,3013501114
89,8;15063,3473788581
89,9;15344,6767524379
90;16570,5624674954
90,1;13642,1930656728
90,2;14305,4840410133
90,3;11366,3920369854
90,4;13277,9693802317
90,5;13235,2942003651
90,6;14955,2981112903
90,7;16169,1139558071
90,8;13444,2839371485
90,9;9089,95755863969
91;10172,4279448728
91,1;6940,32198519605
91,2;8390,47860364237
91,3;7414,30561059461
91,4;6631,61379612151
91,5;7382,43970679747
91,6;7846,49840204285
91,7;6375,83248132266
91,8;5844,69087984361
91,9;5535,71694385237
92;6306,27700382616
92,1;5543,68132810144
92,2;5969,84707901585
92,3;5896,84887734867
92,4;5486,3140909155
92,5;6252,6684931635
92,6;5441,88953068394
92,7;5903,48825888603
92,8;6057,33942696069
92,9;6218,08517661229
93;6106,57717134311
93,1;5260,34007029175
93,2;7097,62559594772
93,3;7546,54717362485
93,4;5241,65663212615
93,5;7857,51199603327
93,6;7305,74973786767
93,7;8053,73249390559
93,8;5606,09439713797
93,9;5916,25347371313
94;7476,2810824586
94,1;7535,95038119899
94,2;7118,01225805734
94,3;5417,43414439005
94,4;6084,90027931049
94,5;6033,54071910334
94,6;6297,66793938372
94,7;6488,07976214268
94,8;5320,47703827806
94,9;7379,15231259575
95;8596,08724172797
95,1;6040,7827704137
95,2;9027,10261957848
95,3;13023,9250654291
95,4;11353,1465785939
95,5;13034,4668353095
95,6;9897,7255935645
95,7;10034,4478960321
95,8;12405,0884488056
95,9;13280,4917757347
96;11050,6976345327
96,1;9376,82423282411
96,2;11672,511263973
96,3;12325,8857487411
96,4;12864,7329154346
96,5;11756,4838244404
96,6;8774,68402681564
96,7;11210,4534735627
96,8;12050,5699255764
96,9;10033,007387701
97;9100,86901019109
97,1;8465,01561048677
97,2;6263,04092971508
97,3;8371,58581960713
97,4;6592,20082902912
97,5;7092,46572314113
97,6;6379,42521485691
97,7;6662,74267805176
97,8;6523,40233092788
97,9;11152,360549344
98;9957,87092735192
98,1;11763,7776849331
98,2;10618,4983158747
98,3;10881,4526960639
98,4;15918,2801309712
98,5;11277,605268996
98,6;11771,9477684394
98,7;11476,8778079714
98,8;9615,44036830025
98,9;8875,11567888828
99;7490,14304885959
99,1;9144,82105960135
99,2;8375,25061336304
99,3;9589,24404525066
99,4;11374,2525438976
99,5;14051,3721983154
99,6;10764,3972257284
99,7;8359,59149358557
99,8;8337,10533957384
99,9;8322,99799776905
100;8327,29982114169
'

pomp(
     data=read.csv2(text=dat),
     times="time",
     t0=0,
     params=c(n.0=10000,K=10000,r=0.9,sigma=0.4,tau=0.1),
     rprocess=euler.sim(
       step.fun=function(x,t,params,delta.t,...){
         r <- params["r"]
         K <- params["K"]
         sigma <- params["sigma"]
         n <- x["n"]
         rnorm(
               n=1,
               mean=n+r*n*(1-n/K)*delta.t,
               sd=sigma*n*sqrt(delta.t)
               )
       },
       delta.t=0.01
       ),
     dprocess=onestep.dens(
       dens.fun=function(x1,x2,t1,t2,params,log,...){
         delta.t <- t2-t1
         r <- params["r"]
         K <- params["K"]
         sigma <- params["sigma"]
         n <- x1["n"]
         dnorm(
               x=x2["n"],
               mean=n+r*n*(1-n/K)*delta.t,
               sd=sigma*n*sqrt(delta.t),
               log=log
               )
       }
       ),
     measurement.model=obs~lnorm(meanlog=log(n),sdlog=log(1+tau)),
     skeleton.type="vectorfield",
     skeleton=function(x,t,params,...){
       r <- params["r"]
       K <- params["K"]
       n <- x["n"]
       f <- r*n*(1-n/K)
       names(f) <- "n"
       f
     }
     ) -> po

assign("verhulst",po,envir=.GlobalEnv)
c("verhulst")
