% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_graph.R
\name{policy_graph}
\alias{policy_graph}
\title{POMDP Policy Graphs}
\usage{
policy_graph(
  x,
  belief = NULL,
  show_belief = FALSE,
  state_col = NULL,
  simplify_observations = FALSE,
  remove_unreachable_nodes = FALSE,
  ...
)
}
\arguments{
\item{x}{object of class \link{POMDP} containing a solved and converged POMDP problem.}

\item{belief}{the initial belief is used to mark the initial belief state in the
grave of a converged solution and to identify the root node in a policy graph for a finite-horizon solution.
If \code{NULL} then the belief is taken from the model definition.}

\item{show_belief}{logical; show estimated belief proportions as a pie chart or color in each node?}

\item{state_col}{colors used to represent the belief over the states in each node. Only used if \code{show_belief} is \code{TRUE}.}

\item{simplify_observations}{combine parallel observation arcs into a single arc.}

\item{remove_unreachable_nodes}{logical; remove nodes that are not reachable from the start state? Currently only implemented for policy trees for unconverged finite-time horizon POMDPs.}

\item{...}{parameters are passed on to \code{\link[=estimate_belief_for_nodes]{estimate_belief_for_nodes()}}.}
}
\value{
returns the policy graph as an igraph object.
}
\description{
The function creates a POMDP policy graph for converged POMDP solution and the
policy tree for a finite-horizon solution.
The graph is represented as an \pkg{igraph} object.
}
\details{
Each policy graph node is represented by an alpha vector specifying a hyper plane segment. The convex hull of
the set of hyperplanes represents the the value function.
The policy specifies for each node an optimal action which is printed together with the node ID inside the node.
The arcs are labeled with observations.
Infinite-horizon converged solutions from a single policy graph.
For finite-horizon solution a policy tree is produced.
The levels of the tree and the first number in the node label represent the epochs.

The parameters \code{show_belief}, \code{remove_unreachable_nodes}, and \code{simplify_observations} are
used by \code{\link[=plot_policy_graph]{plot_policy_graph()}} (see there for details) to reduce clutter and make the visualization more readable.
These options are disabled by default for \code{policy_graph()}.
}
\examples{
data("Tiger")

### Policy graphs for converged solutions
sol <- solve_POMDP(model = Tiger)
sol

policy_graph(sol)

## visualization
plot_policy_graph(sol)

### Policy trees for finite-horizon solutions
sol <- solve_POMDP(model = Tiger, horizon = 4, method = "incprune")

policy_graph(sol)
plot_policy_graph(sol)
# Note: the first number in the node id is the epoch.
}
\seealso{
Other policy: 
\code{\link{estimate_belief_for_nodes}()},
\code{\link{optimal_action}()},
\code{\link{plot_belief_space}()},
\code{\link{plot_policy_graph}()},
\code{\link{policy}()},
\code{\link{projection}()},
\code{\link{reward}()},
\code{\link{solve_POMDP}()},
\code{\link{solve_SARSOP}()},
\code{\link{value_function}()}
}
\concept{policy}
