% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyqtlR_functions.R
\name{plotLinearQTL}
\alias{plotLinearQTL}
\title{Plot the results of genome-wide QTL analysis along a single track}
\usage{
plotLinearQTL(
  LOD_data,
  inter_chm_gap = 5,
  overlay = FALSE,
  ylimits = NULL,
  sig.unit = "LOD",
  plot_type = c("lines", "points"),
  add_xaxis = TRUE,
  add_rug = TRUE,
  add_thresh = TRUE,
  override_thresh = NULL,
  thresh.lty = 3,
  thresh.lwd = 2,
  thresh.col = "darkred",
  return_plotData = FALSE,
  show_thresh_CI = TRUE,
  use_LG_names = FALSE,
  axis_label.cex = 1,
  custom_LG_names = NULL,
  LGdiv.col = "gray42",
  ...
)
}
\arguments{
\item{LOD_data}{Output of \code{\link{QTLscan}} function.}

\item{inter_chm_gap}{The gap size (in cM) between successive chromosomes - by default a gap of 5 cM is used.}

\item{overlay}{Add to an existing plot (should be produced by a comparable call to this function) or not? By default \code{FALSE},
in which case a new plot is drawn. Can be useful for displaying results of multiple analyses together. However, an alternative approach, when significance
thresholds have been calculated for multiple comparable scans, that plots be rescaled so that significance thresholds overlap perfectly. For this, the 
\code{\link{plotLinearQTL_list}} function is advised.}

\item{ylimits}{Use to specify ylimits of plot region, though by default \code{NULL} in which case a suitable plot region is automatically used.}

\item{sig.unit}{Label to use on the y-axis for significance units, by default assumed to be LOD score.}

\item{plot_type}{Plots can be either in line drawings ("lines") or scatter plot format ("points").}

\item{add_xaxis}{Should an x-axis be drawn? If multiple QTL analyses are performed on different traits, specifying this to be \code{FALSE}
and using \code{par(mar=c(0,4.1,4.1,2.1))} allows subsequent plots to be neatly stacked.}

\item{add_rug}{Logical, by default \code{TRUE} - should original marker points be added to plot?}

\item{add_thresh}{Logical, by default \code{TRUE} - should a significance threshold be added to plot?}

\item{override_thresh}{By default \code{NULL}. Can be used to specify a value for the significance threshold, overriding any stored in \code{LOD_data}.}

\item{thresh.lty}{Gives user control over the line type of the significance threshold to be drawn.}

\item{thresh.lwd}{Gives user control over the line width of the significance threshold to be drawn.}

\item{thresh.col}{Gives user control over the line colour of the significance threshold to be drawn.}

\item{return_plotData}{Logical, by default \code{FALSE}. If \code{TRUE}, then the x and y coordinates of the plot data are returned,
which can be useful for subsequent plot manipulations and overlays.}

\item{show_thresh_CI}{Logical, by default \code{TRUE}. Should confidence interval bounds around LOD threshold be shown?}

\item{use_LG_names}{Logical, by default \code{FALSE}. Should original character LG names be used as axis labels, or should numbering be used instead?}

\item{axis_label.cex}{Argument to adjust the size of the axis labels, can be useful if there are many linkage groups to plot}

\item{custom_LG_names}{Specify a vector that contains custom linkage group names. By default \code{NULL}}

\item{LGdiv.col}{Colour of dividing lines between linkage groups, by default grey.}

\item{\dots}{Arguments passed to \code{\link{plot}}, and \code{\link{lines}} or \code{\link{points}} as appropriate (see argument \code{plot_type}).}
}
\value{
The plot data, if return_plotData = TRUE. Otherwise \code{NULL}
}
\description{
QTL plotting function that plots output of \code{\link{QTLscan}} function along a single track, useful for overlaying plots. Only works for scan over multiple chromosomes.
}
\examples{
\dontrun{
data("qtl_LODs.4x")
plotLinearQTL(LOD_data = qtl_LODs.4x)
}
}
