% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_transliteration_table.R
\name{create_transliteration_table}
\alias{create_transliteration_table}
\title{Create a Transliteration Table}
\usage{
create_transliteration_table(words, languages)
}
\arguments{
\item{words}{A character vector containing the words to be transliterated.}

\item{languages}{A character vector specifying the target languages for transliteration.}
}
\value{
A data frame representing the transliteration table with original words and transliterations in each language.
}
\description{
This function generates a transliteration table by transliterating a list of words into multiple languages.
}
\examples{
\dontrun{
words <- c("Hello world", "Goodbye", "Thank you", "Please")
languages <- c("ar", "he", "el", "ru", "fa")
transliterations <- create_transliteration_table(words, languages)
print(transliterations)
}
}
