% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noise.R
\name{noise}
\alias{noise}
\alias{noise,DocumentTermMatrix-method}
\alias{noise,TermDocumentMatrix-method}
\alias{noise,character-method}
\alias{noise,textstat-method}
\title{detect noise}
\usage{
noise(.Object, ...)

\S4method{noise}{DocumentTermMatrix}(
  .Object,
  minTotal = 2,
  minTfIdfMean = 0.005,
  sparse = 0.995,
  stopwordsLanguage = "german",
  minNchar = 2L,
  specialChars = getOption("polmineR.specialChars"),
  numbers = "^[0-9\\\\.,]+$",
  verbose = TRUE
)

\S4method{noise}{TermDocumentMatrix}(.Object, ...)

\S4method{noise}{character}(
  .Object,
  stopwordsLanguage = "german",
  minNchar = 2,
  specialChars = getOption("polmineR.specialChars"),
  numbers = "^[0-9\\\\.,]+$",
  verbose = TRUE
)

\S4method{noise}{textstat}(.Object, p_attribute, ...)
}
\arguments{
\item{.Object}{An object of class \code{DocumentTermMatrix}.}

\item{...}{further parameters}

\item{minTotal}{minimum colsum (for DocumentTermMatrix) to qualify a term as non-noise}

\item{minTfIdfMean}{minimum mean value for tf-idf to qualify a term as non-noise}

\item{sparse}{Will be passed into \code{tm::removeSparseTerms()}.}

\item{stopwordsLanguage}{e.g. "german", to get stopwords defined in the \code{tm} package.}

\item{minNchar}{Minimum number of characters to qualify a term as non-noise.}

\item{specialChars}{special characters to drop}

\item{numbers}{regex, to drop numbers}

\item{verbose}{logical}

\item{p_attribute}{relevant if applied to a textstat object}
}
\value{
a list
}
\description{
detect noise
}
