% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tooltips.R
\docType{methods}
\name{tooltips}
\alias{tooltips}
\alias{tooltips,character-method}
\alias{tooltips,html-method}
\title{Add tooltips to html document.}
\usage{
tooltips(.Object, tooltips)

\S4method{tooltips}{character}(.Object, tooltips = list())

\S4method{tooltips}{html}(.Object, tooltips = list())
}
\arguments{
\item{.Object}{a \code{html} or \code{character} object with html}

\item{tooltips}{a named \code{"list"} of character vectors (length 1), the 
names need to match colors in the list provided to param \code{highlight}, 
the value of the character vector is the tooltip to be displayed}
}
\description{
Highlight tokens based on exact match, a regular expression or corpus
position in kwic output or html document.
}
\examples{
use("polmineR")
P <- partition("REUTERS", places = "argentina")
H <- html(P)
Y <- highlight(H, list(lightgreen = "higher"))
T <- tooltips(Y, list(lightgreen = "Further information"))
T

if (require("magrittr")){
  P \%>\%
    html() \%>\%
    highlight(list(yellow = c("barrels", "oil", "gas"))) \%>\%
    tooltips(list(yellow = "energy"))
}
}
