% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/token_stream.R
\docType{methods}
\name{get_token_stream}
\alias{get_token_stream}
\alias{get_token_stream,numeric-method}
\alias{get_token_stream,matrix-method}
\alias{get_token_stream,character-method}
\alias{get_token_stream,partition-method}
\alias{get_token_stream,regions-method}
\title{Get Token Stream Based on Corpus Positions.}
\usage{
get_token_stream(.Object, ...)

\S4method{get_token_stream}{numeric}(.Object, corpus, p_attribute,
  encoding = NULL, collapse = NULL, beautify = TRUE, cpos = FALSE,
  cutoff = NULL, decode = TRUE, ...)

\S4method{get_token_stream}{matrix}(.Object, ...)

\S4method{get_token_stream}{character}(.Object, left = NULL,
  right = NULL, ...)

\S4method{get_token_stream}{partition}(.Object, p_attribute,
  collapse = NULL, cpos = FALSE, ...)

\S4method{get_token_stream}{regions}(.Object, p_attribute = "word", ...)
}
\arguments{
\item{.Object}{An object of class \code{matrix} or \code{partition}}

\item{...}{Further arguments.}

\item{corpus}{The CWB corpus.}

\item{p_attribute}{The p-attribute to decode.}

\item{encoding}{Encoding to use.}

\item{collapse}{Length-one character string.}

\item{beautify}{Logical, whether to adjust whitespace before and after interpunctation.}

\item{cpos}{Logical, whether to return cpos as names of the tokens.}

\item{cutoff}{Maximum number of tokens to be reconstructed.}

\item{decode}{Logical, whether to decode token ids to character strings.}

\item{left}{Left corpus position.}

\item{right}{Right corpus position.}
}
\description{
Turn regions of a corpus defined by corpus positions into the original text.
}
\examples{
get_token_stream(0:9, corpus = "GERMAPARLMINI", p_attribute = "word")
get_token_stream(0:9, corpus = "GERMAPARLMINI", p_attribute = "word", collapse = " ")
fulltext <- get_token_stream("GERMAPARLMINI", p_attribute = "word")
}
