% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_data_functions.R
\name{partial}
\alias{partial}
\title{Trim Number of Stages}
\usage{
partial(object, K)
}
\arguments{
\item{object}{Object of class \link{policy_data}.}

\item{K}{Maximum number of stages.}
}
\value{
Object of class \link{policy_data}.
}
\description{
\code{partial} creates a partial policy data object by trimming
the maximum number of stages in the policy data object to a fixed
given number.
}
\examples{
library("polle")
### Multiple stage case
source(system.file("sim", "multi_stage.R", package="polle"))
d <- sim_multi_stage(5e2, seed = 1)
# constructing policy_data object:
pd <- policy_data(data = d$stage_data,
                   baseline_data = d$baseline_data,
                   type = "long",
                   id = "id",
                   stage = "stage",
                   event = "event",
                   action = "A",
                   utility = "U")
pd
# Creating a partial policy data object with 3 stages
pd3 <- partial(pd, K = 3)
pd3
}
