% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_data.R
\name{scan_data}
\alias{scan_data}
\title{Thoroughly scan the table data so as to understand it better}
\usage{
scan_data(
  tbl,
  sections = c("overview", "variables", "interactions", "correlations", "missing",
    "sample"),
  navbar = TRUE,
  reporting_lang = NULL
)
}
\arguments{
\item{tbl}{The input table. This can be a data frame, a tibble, or a
\code{tbl_dbi} object.}

\item{sections}{The sections to include in the finalized \verb{Table Scan} report.
A character vector with section names is required here. The sections in
their default order are: \code{"overview"}, \code{"variables"}, \code{"interactions"},
\code{"correlations"}, \code{"missing"}, and \code{"sample"}. This vector can be comprised
of less elements and the order can be changed to suit the desired layout of
the report.}

\item{navbar}{Should there be a navigation bar anchored to the top of the
report page? By default this is \code{TRUE}.}

\item{reporting_lang}{The language to use for label text in the report. By
default, \code{NULL} will create English (\code{"en"}) text. Other options include
French (\code{"fr"}), German (\code{"de"}), Italian (\code{"it"}), and Spanish (\code{"es"}).}
}
\description{
Generates an HTML report that scours the input table data. Before calling up
an \emph{agent} to validate the data, it's a good idea to understand the data with
some level of precision. Make this the initial step of a well-balanced \emph{data
quality reporting} workflow. The reporting output contains several sections
to make everything more digestible, and these are:
\describe{
\item{Overview}{Table dimensions, duplicate row count, column types, and
reproducibility information}
\item{Variables}{A summary for each table variable and further statistics and
summaries depending on the variable type}
\item{Interactions}{A matrix plot that shows interactions between variables}
\item{Correlations}{A set of correlation matrix plots for numerical
variables}
\item{Missing Values}{A summary figure that shows the degree of missingness
across variables}
\item{Sample}{A table that provides the head and tail rows of the dataset}
}
The output HTML report is viewable in the RStudio Viewer and can also be
integrated in R Markdown HTML reports. If you need the output HTML as a
string, it's possible to get that by using \code{as.character()} (e.g.,
\code{scan_data(tbl = iris) \%>\% as.character()}). The resulting HTML string is a
complete HTML document where Bootstrap and jQuery are embedded within.
}
\section{Function ID}{

1-1
}

\examples{
# Get an HTML report that describes all of
# the data in the `dplyr::storms` dataset
# scan_data(tbl = dplyr::storms)

}
\seealso{
Other Planning and Prep: 
\code{\link{action_levels}()},
\code{\link{col_schema}()},
\code{\link{create_agent}()}
}
\concept{Planning and Prep}
