% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col_schema_match.R
\name{col_schema_match}
\alias{col_schema_match}
\title{Do columns in the table (and their types) match a predefined schema?}
\usage{
col_schema_match(x, schema, actions = NULL, brief = NULL, active = TRUE)
}
\arguments{
\item{x}{A data frame, tibble, or an agent object of class \code{ptblank_agent}.}

\item{schema}{A table schema of type \code{col_schema} which can be generated
using the \code{\link[=col_schema]{col_schema()}} function.}

\item{actions}{A list containing threshold levels so that the validation step
can react accordingly when exceeding the set levels. This is to be created
with the \code{\link[=action_levels]{action_levels()}} helper function.}

\item{brief}{An optional, text-based description for the validation step.}

\item{active}{A logical value indicating whether the validation step should
be active. If the step function is working with an agent, \code{FALSE} will make
the validation step inactive (still reporting its presence and keeping
indexes for the steps unchanged). If the step function will be operating
directly on data, then any step with \code{active = FALSE} will simply pass the
data through with no validation whatsoever. The default for this is \code{TRUE}.}
}
\description{
The \code{col_schema_match()} validation step function works in conjunction with a
\code{col_schema} object (generated through the \code{\link[=col_schema]{col_schema()}} function) to
determine whether the expected schema matches the target table. This
validation step operates over a single test unit, which is whether the schema
exactly matches that of the table. If the target table is a \code{tbl_sql} object,
we can choose to validate the column schema that is based on R column types
(e.g., \code{"numeric"}, \code{"character"}, etc.), or, SQL column types (e.g.,
\code{"double"}, \code{"varchar"}, etc.). That option is defined in the \code{\link[=col_schema]{col_schema()}}
function (with the \code{.db_col_types} argument).
}
\details{
Often, we will want to specify \code{actions} for the validation. This argument,
present in every validation step function, takes a specially-crafted list
object that is best produced by the \code{\link[=action_levels]{action_levels()}} function. Read that
function's documentation for the lowdown on how to create reactions to
above-threshold failure levels in validation. The basic gist is that you'll
want at least a single threshold level (specified as either the fraction test
units failed, or, an absolute value), often using the \code{warn_at} argument.
Using \code{action_levels(warn_at = 1)} or \code{action_levels(stop_at = 1)} are good
choices depending on the situation (the first produces a warning, the other
\code{stop()}s).

Want to describe this validation step in some detail? Keep in mind that this
is only useful if \code{x} is an \emph{agent}. If that's the case, \code{brief} the agent
with some text that fits. Don't worry if you don't want to do it. The
\emph{autobrief} protocol is kicked in when \code{brief = NULL} and a simple brief will
then be automatically generated.
}
\section{Function ID}{

2-24
}

\examples{
# Create a simple table with
# two columns: one `integer` and
# the other `character`
tbl <- 
  dplyr::tibble(
    a = 1:5,
    b = letters[1:5]
  )

# Create a column schema object
# that describes the columns and
# their types (in the expected
# order)
schema_obj <- 
  col_schema(
    a = "integer",
    b = "character"
  )

# Validate that the schema object
# `col_schema_x` exactly defines
# the column names and column types
# of the `tbl_x` table
agent <-
  create_agent(tbl = tbl) \%>\%
  col_schema_match(schema_obj) \%>\%
  interrogate()

# Determine if these three validation
# steps passed by using `all_passed()`
all_passed(agent)

}
\seealso{
Other Validation Step Functions: 
\code{\link{col_exists}()},
\code{\link{col_is_character}()},
\code{\link{col_is_date}()},
\code{\link{col_is_factor}()},
\code{\link{col_is_integer}()},
\code{\link{col_is_logical}()},
\code{\link{col_is_numeric}()},
\code{\link{col_is_posix}()},
\code{\link{col_vals_between}()},
\code{\link{col_vals_equal}()},
\code{\link{col_vals_gte}()},
\code{\link{col_vals_gt}()},
\code{\link{col_vals_in_set}()},
\code{\link{col_vals_lte}()},
\code{\link{col_vals_lt}()},
\code{\link{col_vals_not_between}()},
\code{\link{col_vals_not_equal}()},
\code{\link{col_vals_not_in_set}()},
\code{\link{col_vals_not_null}()},
\code{\link{col_vals_null}()},
\code{\link{col_vals_regex}()},
\code{\link{conjointly}()},
\code{\link{rows_distinct}()}
}
\concept{Validation Step Functions}
