% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logging.R
\name{log4r_step}
\alias{log4r_step}
\title{Enable logging of failure conditions at the validation step level}
\usage{
log4r_step(x, message = NULL, append_to = "pb_log_file")
}
\arguments{
\item{x}{A reference to the x-list object prepared by the \code{agent}. This
version of the x-list is the same as that generated via
\verb{get_agent_x_list(<agent>, i = <step>)} except this version is internally
generated and hence only available in an internal evaluation context.}

\item{message}{The message to use for the log entry. When not provided, a
default glue string is used for the messaging. This is dynamic since the
internal \code{glue::glue()} call occurs in the same environment as \code{x}, the
x-list that's constrained to the validation step. The default message, used
when \code{message = NULL} is the glue string \code{"Step {x$i} exceeded the {level} failure threshold (f_failed = {x$f_failed}) ['{x$type}']"}. As can be seen,
a custom message can be crafted that uses other elements of the x-list with
the \verb{\{x$<component>\}} construction.}

\item{append_to}{The file to which log entries at the warn level are
appended. This can alternatively be one or more \strong{log4r} appenders.}
}
\value{
Nothing is returned however log files may be written in very specific
conditions.
}
\description{
The \code{log4r_step()} function can be used as an action in the \code{\link[=action_levels]{action_levels()}}
function (as a list component for the \code{fns} list). Place a call to this
function in every failure condition that should produce a log (i.e., \code{warn},
\code{stop}, \code{notify}). Only the failure condition with the highest severity for a
given validation step will produce a log entry (skipping failure conditions
with lower severity) so long as the call to \code{log4r_step()} is present.
}
\section{YAML}{


A \strong{pointblank} agent can be written to YAML with \code{\link[=yaml_write]{yaml_write()}} and the
resulting YAML can be used to regenerate an agent (with \code{\link[=yaml_read_agent]{yaml_read_agent()}})
or interrogate the target table (via \code{\link[=yaml_agent_interrogate]{yaml_agent_interrogate()}}). Here is an
example of how \code{log4r_step()} can be expressed in R code (within
\code{\link[=action_levels]{action_levels()}}, itself inside \code{\link[=create_agent]{create_agent()}}) and in the corresponding
YAML representation.

R statement:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{create_agent(
  tbl = ~ small_table,
  tbl_name = "small_table",
  label = "An example.",
  actions = action_levels(
    warn_at = 1,
    fns = list(
      warn = ~ log4r_step(
        x, append_to = "example_log"
      )
    )
  )
)
}\if{html}{\out{</div>}}

YAML representation:

\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{type: agent
tbl: ~small_table
tbl_name: small_table
label: An example.
lang: en
locale: en
actions:
  warn_count: 1.0
  fns:
    warn: ~log4r_step(x, append_to = "example_log")
steps: []
}\if{html}{\out{</div>}}

Should you need to preview the transformation of an \emph{agent} to YAML (without
any committing anything to disk), use the \code{\link[=yaml_agent_string]{yaml_agent_string()}} function. If
you already have a \code{.yml} file that holds an \emph{agent}, you can get a glimpse
of the R expressions that are used to regenerate that agent with
\code{\link[=yaml_agent_show_exprs]{yaml_agent_show_exprs()}}.
}

\section{Examples}{


For the example provided here, we'll use the included \code{small_table} dataset.
We are also going to create an \code{action_levels()} list object since this is
useful for demonstrating a logging scenario. It will have a threshold for
the \code{warn} state, and, an associated function that should be invoked
whenever the \code{warn} state is entered. Here, the function call with
\code{log4r_step()} will be invoked whenever there is one failing test unit.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{al <-
  action_levels(
    warn_at = 1,
    fns = list(
      warn = ~ log4r_step(
        x, append_to = "example_log"
      )
    )
  )
}\if{html}{\out{</div>}}

Within the \code{\link[=action_levels]{action_levels()}}-produced object, it's important to match things
up: notice that \code{warn_at} is given a threshold and the list of functions
given to \code{fns} has a \code{warn} component.

Printing \code{al} will show us the settings for the \code{action_levels} object:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{al
#> -- The `action_levels` settings
#> WARN failure threshold of 1test units.
#> \\fns\\ ~ log4r_step(x, append_to = "example_log")
#> ----
}\if{html}{\out{</div>}}

Let's create an agent with \code{small_table} as the target table. We'll apply the
\code{action_levels} object created above as \code{al}, add two validation steps, and
then \code{\link[=interrogate]{interrogate()}} the data.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{agent <- 
  create_agent(
    tbl = ~ small_table,
    tbl_name = "small_table",
    label = "An example.",
    actions = al
  ) \%>\%
  col_vals_gt(columns = d, 300) \%>\%
  col_vals_in_set(columns = f, c("low", "high")) \%>\%
  interrogate()

agent
}\if{html}{\out{</div>}}

\if{html}{
\out{
<img src="https://raw.githubusercontent.com/rstudio/pointblank/main/images/man_log4r_step_1.png" alt="This image was generated from the first code example in the `log4r_step()` help file." style="width:100\%;">
}
}

From the agent report, we can see that both steps have yielded warnings upon
interrogation (i.e., filled yellow circles in the \code{W} column).

What's not immediately apparent is that when entering the \code{warn} state
in each validation step during interrogation, the \code{log4r_step()} function
call was twice invoked! This generated an \code{"example_log"} file in the working
directory (since it was not present before the interrogation) and log entries
were appended to the file. Here are the contents of the file:

\if{html}{\out{<div class="sourceCode">}}\preformatted{WARN  [2022-06-28 10:06:01] Step 1 exceeded the WARN failure threshold
  (f_failed = 0.15385) ['col_vals_gt']
WARN  [2022-06-28 10:06:01] Step 2 exceeded the WARN failure threshold
  (f_failed = 0.15385) ['col_vals_in_set']
}\if{html}{\out{</div>}}
}

\section{Function ID}{

5-1
}

\concept{Logging}
