% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_naming.R
\name{affix_datetime}
\alias{affix_datetime}
\title{Put the current datetime into a file name}
\usage{
affix_datetime(
  filename,
  position = c("end", "start"),
  format = "\%Y-\%m-\%d_\%H-\%M-\%S",
  delimiter = "_",
  utc_time = TRUE,
  add_tz = FALSE
)
}
\arguments{
\item{filename}{The filename to modify.}

\item{position}{Where to place the formatted datetime. This could either be
at the \code{"end"} of the filename (the default) or at the \code{"start"}.}

\item{format}{A \code{\link[base:strptime]{base::strptime()}} format string for formatting the
datetime. By default, this is \code{"\%Y-\%m-\%dT\%H:\%M:\%S"} which expresses the
date according to the ISO 8601 standard. For example, if the current
datetime is \verb{2020-12-04 13:11:23}, the formatted string would become
\code{"2020-12-04T13:11:23"}. Refer to the documentation on \code{\link[base:strptime]{base::strptime()}}
for conversion specifications if planning to use a different format string.}

\item{delimiter}{The delimiter characters to use for separating the datetime
string from the original file name.}

\item{utc_time}{An option for whether to use the current UTC time to
establish the datetime (the default, with \code{TRUE}), or, use the system's
local time (\code{FALSE}).}

\item{add_tz}{Should the time zone (as an offset from UTC) be provided? If
\code{TRUE} then the UTC offset will be either provided as \verb{<time>Z} (if
\code{utc_time = TRUE}) or \verb{<time>(+/-)hhmm}. By default, this is \code{FALSE}.}
}
\value{
A character vector.
}
\description{
This function helps to affix the current datetime to a filename. This is
useful when writing \emph{agent} and/or \emph{informant} objects to disk as part of a
continuous process. The datetime string can be based on the current UTC time
or the local system time. The datetime can be affixed either to the end of
the filename (before the file extension) or at the beginning with a
customizable delimiter. Optionally, the time zone information can be
included. If the datetime is based on the local system time, the user system
time zone is shown with the format \verb{<time>(+/-)hhmm}. If using UTC time, then
the \verb{<time>Z} format is adopted.

The \code{\link[=x_write_disk]{x_write_disk()}}, \code{\link[=yaml_write]{yaml_write()}} functions allow for the writing of
\strong{pointblank} objects to disk. The modification of the filename string takes
effect immediately but not at the time of writing a file to disk. In most
cases, especially when using \code{affix_datetime()} with the aforementioned
file-writing functions, the file timestamps should approximate the time
components affixed to the filenames.
}
\section{Examples}{

\subsection{The basics of creating a filename with the current date and time}{

Taking the generic \code{"pb_file"} name for a file, we add the current datetime
to it as a suffix.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{affix_datetime(filename = "pb_file")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## [1] "pb_file_2022-04-01_00-32-53"
}\if{html}{\out{</div>}}

File extensions won't get in the way:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{affix_datetime(filename = "pb_file.rds")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## [1] "pb_file_2022-04-01_00-32-53.rds"
}\if{html}{\out{</div>}}

The datetime can be used as a prefix.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{affix_datetime(
  filename = "pb_file",
  position = "start"
)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## [1] "2022-04-01_00-32-53_pb_file"
}\if{html}{\out{</div>}}

The datetime pattern can be changed and so can the delimiter.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{affix_datetime(
  filename = "pb_file.yml",
  format = "\%Y\%m\%d_\%H\%M\%S",
  delimiter = "-"
)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## [1] "pb_file-20220401_003253.yml"
}\if{html}{\out{</div>}}

Time zone information can be included. By default, all datetimes are given in
the UTC time zone.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{affix_datetime(
  filename = "pb_file.yml",
  add_tz = TRUE
)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## [1] "pb_file_2022-04-01_00-32-53Z.yml"
}\if{html}{\out{</div>}}

We can use the system's local time zone with \code{utc_time = FALSE}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{affix_datetime(
  filename = "pb_file.yml",
  utc_time = FALSE,
  add_tz = TRUE
)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## [1] "pb_file_2022-03-31_20-32-53-0400.yml"
}\if{html}{\out{</div>}}
}

\subsection{Using a datetime-based filename in a \strong{pointblank} workflow}{

We can use a file-naming convention involving datetimes when writing output
files immediately after interrogating. This is just one example (any workflow
involving a \code{filename} argument is applicable). It's really advantageous to
use datetime-based filenames when interrogating directly from YAML in a
scheduled process, especially if multiple validation runs per day are being
executed on the same target table.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{yaml_agent_interrogate(
  filename = system.file(
    "yaml", "agent-small_table.yml",
    package = "pointblank"
  )
) \%>\% 
  x_write_disk(
    filename = affix_datetime(
      filename = "small_table_agent.rds",
      delimiter = "-"
    ),
    keep_tbl = TRUE,
    keep_extracts = TRUE
  )
}\if{html}{\out{</div>}}

In the above, we used the written-to-disk agent (The
\code{"agent-small_table.yml"} YAML file) for an interrogation via
\code{\link[=yaml_agent_interrogate]{yaml_agent_interrogate()}}. Then, the results were written to disk as an RDS
file. In the \code{filename} argument of \code{\link[=x_write_disk]{x_write_disk()}}, the \code{\link[=affix_datetime]{affix_datetime()}}
function was used to ensure that frequent runs would produce files whose
names indicate the day and time of execution.
}
}

\section{Function ID}{

13-4
}

\seealso{
The \code{\link[=affix_date]{affix_date()}} function provides the same features except it
produces a date string by default.

Other Utility and Helper Functions: 
\code{\link{affix_date}()},
\code{\link{col_schema}()},
\code{\link{from_github}()},
\code{\link{has_columns}()},
\code{\link{stop_if_not}()}
}
\concept{Utility and Helper Functions}
