# draft validations for data tables can be generated

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `country_name` is of type: character\n  col_is_character(\n    columns = vars(country_name)\n  ) %>%\n  # Expect that values in `country_name` should be in the set of `Aruba`, `Afghanistan`, `Angola` (and 212 more)\n  col_vals_in_set(\n    columns = vars(country_name),\n    set = c(\"Aruba\", \"Afghanistan\", \"Angola\", \"Albania\", \"Andorra\", \"United Arab Emirates\", \"Argentina\", \"Armenia\", \"American Samoa\", \"Antigua and Barbuda\", \"Australia\", \"Austria\", \"Azerbaijan\", \"Burundi\", \"Belgium\", \"Benin\", \"Burkina Faso\", \"Bangladesh\", \"Bulgaria\", \"Bahrain\", \"Bahamas\", \"Bosnia and Herzegovina\", \"Belarus\", \"Belize\", \"Bermuda\", \"Bolivia\", \"Brazil\", \"Barbados\", \"Brunei Darussalam\", \"Bhutan\", \"Botswana\", \"Central African Republic\", \"Canada\", \"Switzerland\", \"Chile\", \"China\", \"Cote d'Ivoire\", \"Cameroon\", \"Congo (Democratic Republic)\", \"Congo\", \"Colombia\", \"Comoros\", \"Cabo Verde\", \"Costa Rica\", \"Cuba\", \"Curacao\", \"Cayman Islands\", \"Cyprus\", \"Czech Republic\", \"Germany\", \"Djibouti\", \"Dominica\", \"Denmark\", \"Dominican Republic\", \"Algeria\", \"Ecuador\", \"Egypt\", \"Eritrea\", \"Spain\", \"Estonia\", \"Ethiopia\", \"Finland\", \"Fiji\", \"France\", \"Faroe Islands\", \"Micronesia (Federated States)\", \"Gabon\", \"United Kingdom\", \"Georgia\", \"Ghana\", \"Gibraltar\", \"Guinea\", \"Gambia, The\", \"Guinea-Bissau\", \"Equatorial Guinea\", \"Greece\", \"Grenada\", \"Greenland\", \"Guatemala\", \"Guam\", \"Guyana\", \"Hong Kong\", \"Honduras\", \"Croatia\", \"Haiti\", \"Hungary\", \"Indonesia\", \"Isle of Man\", \"India\", \"Ireland\", \"Iran (Islamic Republic)\", \"Iraq\", \"Iceland\", \"Israel\", \"Italy\", \"Jamaica\", \"Jordan\", \"Japan\", \"Kazakhstan\", \"Kenya\", \"Kyrgyzstan\", \"Cambodia\", \"Kiribati\", \"St. Kitts and Nevis\", \"Korea (Republic of)\", \"Kuwait\", \"Lao (People’s Democratic Republic)\", \"Lebanon\", \"Liberia\", \"Libya\", \"Saint Lucia\", \"Liechtenstein\", \"Sri Lanka\", \"Lesotho\", \"Lithuania\", \"Luxembourg\", \"Latvia\", \"Macao\", \"Saint Martin (French part)\", \"Morocco\", \"Monaco\", \"Moldova (Republic of)\", \"Madagascar\", \"Maldives\", \"Mexico\", \"Marshall Islands\", \"Macedonia (FYR)\", \"Mali\", \"Malta\", \"Myanmar\", \"Montenegro\", \"Mongolia\", \"Northern Mariana Islands\", \"Mozambique\", \"Mauritania\", \"Mauritius\", \"Malawi\", \"Malaysia\", \"Namibia\", \"New Caledonia\", \"Niger\", \"Nigeria\", \"Nicaragua\", \"Netherlands\", \"Norway\", \"Nepal\", \"Nauru\", \"New Zealand\", \"Oman\", \"Pakistan\", \"Panama\", \"Peru\", \"Philippines\", \"Palau\", \"Papua New Guinea\", \"Poland\", \"Puerto Rico\", \"Korea (Dem. People’s Rep.)\", \"Portugal\", \"Paraguay\", \"Palestine (State of)\", \"French Polynesia\", \"Qatar\", \"Romania\", \"Russian Federation\", \"Rwanda\", \"Saudi Arabia\", \"Sudan\", \"Senegal\", \"Singapore\", \"Solomon Islands\", \"Sierra Leone\", \"El Salvador\", \"San Marino\", \"Somalia\", \"Serbia\", \"South Sudan\", \"Sao Tome and Principe\", \"Suriname\", \"Slovak Republic\", \"Slovenia\", \"Sweden\", \"Eswatini\", \"Sint Maarten (Dutch part)\", \"Seychelles\", \"Syrian Arab Republic\", \"Turks and Caicos Islands\", \"Chad\", \"Togo\", \"Thailand\", \"Tajikistan\", \"Turkmenistan\", \"Timor-Leste\", \"Tonga\", \"Trinidad and Tobago\", \"Tunisia\", \"Turkey\", \"Tuvalu\", \"Tanzania\", \"Uganda\", \"Ukraine\", \"Uruguay\", \"United States\", \"Uzbekistan\", \"St. Vincent and the Grenadines\", \"Venezuela (Bolivarian Republic of)\", \"Virgin Islands (British)\", \"Virgin Islands (U.S.)\", \"Vietnam\", \"Vanuatu\", \"Samoa\", \"Yemen\", \"South Africa\", \"Zambia\", \"Zimbabwe\")\n  ) %>%\n  # Expect that column `country_code_2` is of type: character\n  col_is_character(\n    columns = vars(country_code_2)\n  ) %>%\n  # Expect that values in `country_code_2` should be in the set of `AD`, `AE`, `AF` (and 246 more)\n  col_vals_in_set(\n    columns = vars(country_code_2),\n    set = c(\"AD\", \"AE\", \"AF\", \"AG\", \"AI\", \"AL\", \"AM\", \"AO\", \"AQ\", \"AR\", \"AS\", \"AT\", \"AU\", \"AW\", \"AX\", \"AZ\", \"BA\", \"BB\", \"BD\", \"BE\", \"BF\", \"BG\", \"BH\", \"BI\", \"BJ\", \"BL\", \"BM\", \"BN\", \"BO\", \"BQ\", \"BR\", \"BS\", \"BT\", \"BV\", \"BW\", \"BY\", \"BZ\", \"CA\", \"CC\", \"CD\", \"CF\", \"CG\", \"CH\", \"CI\", \"CK\", \"CL\", \"CM\", \"CN\", \"CO\", \"CR\", \"CU\", \"CV\", \"CW\", \"CX\", \"CY\", \"CZ\", \"DE\", \"DJ\", \"DK\", \"DM\", \"DO\", \"DZ\", \"EC\", \"EE\", \"EG\", \"EH\", \"ER\", \"ES\", \"ET\", \"FI\", \"FJ\", \"FK\", \"FM\", \"FO\", \"FR\", \"GA\", \"GB\", \"GD\", \"GE\", \"GF\", \"GG\", \"GH\", \"GI\", \"GL\", \"GM\", \"GN\", \"GP\", \"GQ\", \"GR\", \"GS\", \"GT\", \"GU\", \"GW\", \"GY\", \"HK\", \"HM\", \"HN\", \"HR\", \"HT\", \"HU\", \"ID\", \"IE\", \"IL\", \"IM\", \"IN\", \"IO\", \"IQ\", \"IR\", \"IS\", \"IT\", \"JE\", \"JM\", \"JO\", \"JP\", \"KE\", \"KG\", \"KH\", \"KI\", \"KM\", \"KN\", \"KP\", \"KR\", \"KW\", \"KY\", \"KZ\", \"LA\", \"LB\", \"LC\", \"LI\", \"LK\", \"LR\", \"LS\", \"LT\", \"LU\", \"LV\", \"LY\", \"MA\", \"MC\", \"MD\", \"ME\", \"MF\", \"MG\", \"MH\", \"MK\", \"ML\", \"MM\", \"MN\", \"MO\", \"MP\", \"MQ\", \"MR\", \"MS\", \"MT\", \"MU\", \"MV\", \"MW\", \"MX\", \"MY\", \"MZ\", \"NA\", \"NC\", \"NE\", \"NF\", \"NG\", \"NI\", \"NL\", \"NO\", \"NP\", \"NR\", \"NU\", \"NZ\", \"OM\", \"PA\", \"PE\", \"PF\", \"PG\", \"PH\", \"PK\", \"PL\", \"PM\", \"PN\", \"PR\", \"PS\", \"PT\", \"PW\", \"PY\", \"QA\", \"RE\", \"RO\", \"RS\", \"RU\", \"RW\", \"SA\", \"SB\", \"SC\", \"SD\", \"SE\", \"SG\", \"SH\", \"SI\", \"SJ\", \"SK\", \"SL\", \"SM\", \"SN\", \"SO\", \"SR\", \"SS\", \"ST\", \"SV\", \"SX\", \"SY\", \"SZ\", \"TC\", \"TD\", \"TF\", \"TG\", \"TH\", \"TJ\", \"TK\", \"TL\", \"TM\", \"TN\", \"TO\", \"TR\", \"TT\", \"TV\", \"TW\", \"TZ\", \"UA\", \"UG\", \"UM\", \"US\", \"UY\", \"UZ\", \"VA\", \"VC\", \"VE\", \"VG\", \"VI\", \"VN\", \"VU\", \"WF\", \"WS\", \"YE\", \"YT\", \"ZA\", \"ZM\", \"ZW\")\n  ) %>%\n  # Expect that column `country_code_3` is of type: character\n  col_is_character(\n    columns = vars(country_code_3)\n  ) %>%\n  # Expect that values in `country_code_3` should be in the set of `AND`, `ARE`, `AFG` (and 246 more)\n  col_vals_in_set(\n    columns = vars(country_code_3),\n    set = c(\"AND\", \"ARE\", \"AFG\", \"ATG\", \"AIA\", \"ALB\", \"ARM\", \"AGO\", \"ATA\", \"ARG\", \"ASM\", \"AUT\", \"AUS\", \"ABW\", \"ALA\", \"AZE\", \"BIH\", \"BRB\", \"BGD\", \"BEL\", \"BFA\", \"BGR\", \"BHR\", \"BDI\", \"BEN\", \"BLM\", \"BMU\", \"BRN\", \"BOL\", \"BES\", \"BRA\", \"BHS\", \"BTN\", \"BVT\", \"BWA\", \"BLR\", \"BLZ\", \"CAN\", \"CCK\", \"COD\", \"CAF\", \"COG\", \"CHE\", \"CIV\", \"COK\", \"CHL\", \"CMR\", \"CHN\", \"COL\", \"CRI\", \"CUB\", \"CPV\", \"CUW\", \"CXR\", \"CYP\", \"CZE\", \"DEU\", \"DJI\", \"DNK\", \"DMA\", \"DOM\", \"DZA\", \"ECU\", \"EST\", \"EGY\", \"ESH\", \"ERI\", \"ESP\", \"ETH\", \"FIN\", \"FJI\", \"FLK\", \"FSM\", \"FRO\", \"FRA\", \"GAB\", \"GBR\", \"GRD\", \"GEO\", \"GUF\", \"GGY\", \"GHA\", \"GIB\", \"GRL\", \"GMB\", \"GIN\", \"GLP\", \"GNQ\", \"GRC\", \"SGS\", \"GTM\", \"GUM\", \"GNB\", \"GUY\", \"HKG\", \"HMD\", \"HND\", \"HRV\", \"HTI\", \"HUN\", \"IDN\", \"IRL\", \"ISR\", \"IMN\", \"IND\", \"IOT\", \"IRQ\", \"IRN\", \"ISL\", \"ITA\", \"JEY\", \"JAM\", \"JOR\", \"JPN\", \"KEN\", \"KGZ\", \"KHM\", \"KIR\", \"COM\", \"KNA\", \"PRK\", \"KOR\", \"KWT\", \"CYM\", \"KAZ\", \"LAO\", \"LBN\", \"LCA\", \"LIE\", \"LKA\", \"LBR\", \"LSO\", \"LTU\", \"LUX\", \"LVA\", \"LBY\", \"MAR\", \"MCO\", \"MDA\", \"MNE\", \"MAF\", \"MDG\", \"MHL\", \"MKD\", \"MLI\", \"MMR\", \"MNG\", \"MAC\", \"MNP\", \"MTQ\", \"MRT\", \"MSR\", \"MLT\", \"MUS\", \"MDV\", \"MWI\", \"MEX\", \"MYS\", \"MOZ\", \"NAM\", \"NCL\", \"NER\", \"NFK\", \"NGA\", \"NIC\", \"NLD\", \"NOR\", \"NPL\", \"NRU\", \"NIU\", \"NZL\", \"OMN\", \"PAN\", \"PER\", \"PYF\", \"PNG\", \"PHL\", \"PAK\", \"POL\", \"SPM\", \"PCN\", \"PRI\", \"PSE\", \"PRT\", \"PLW\", \"PRY\", \"QAT\", \"REU\", \"ROU\", \"SRB\", \"RUS\", \"RWA\", \"SAU\", \"SLB\", \"SYC\", \"SDN\", \"SWE\", \"SGP\", \"SHN\", \"SVN\", \"SJM\", \"SVK\", \"SLE\", \"SMR\", \"SEN\", \"SOM\", \"SUR\", \"SSD\", \"STP\", \"SLV\", \"SXM\", \"SYR\", \"SWZ\", \"TCA\", \"TCD\", \"ATF\", \"TGO\", \"THA\", \"TJK\", \"TKL\", \"TLS\", \"TKM\", \"TUN\", \"TON\", \"TUR\", \"TTO\", \"TUV\", \"TWN\", \"TZA\", \"UKR\", \"UGA\", \"UMI\", \"USA\", \"URY\", \"UZB\", \"VAT\", \"VCT\", \"VEN\", \"VGB\", \"VIR\", \"VNM\", \"VUT\", \"WLF\", \"WSM\", \"YEM\", \"MYT\", \"ZAF\", \"ZMB\", \"ZWE\")\n  ) %>%\n  # Expect that column `year` is of type: integer\n  col_is_integer(\n    columns = vars(year)\n  ) %>%\n  # Expect that values in `year` should be between `1960` and `2017`\n  col_vals_between(\n    columns = vars(year),\n    left = 1960,\n    right = 2017\n  ) %>%\n  # Expect that column `population` is of type: integer\n  col_is_integer(\n    columns = vars(population)\n  ) %>%\n  # Expect that values in `population` should be between `4279` and `1386395000`\n  col_vals_between(\n    columns = vars(population),\n    left = 4279,\n    right = 1386395000,\n    na_pass = TRUE\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      country_name = \"character\",\n      country_code_2 = \"character\",\n      country_code_3 = \"character\",\n      year = \"integer\",\n      population = \"integer\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `latitude` is of type: numeric\n  col_is_numeric(\n    columns = vars(latitude)\n  ) %>%\n  # Expect that values in `latitude` should be between `-90` and `90`\n  col_vals_between(\n    columns = vars(latitude),\n    left = -90,\n    right = 90\n  ) %>%\n  # Expect that column `month` is of type: factor\n  col_is_factor(\n    columns = vars(month)\n  ) %>%\n  # Expect that column `tst` is of type: character\n  col_is_character(\n    columns = vars(tst)\n  ) %>%\n  # Expect that column `sza` is of type: numeric\n  col_is_numeric(\n    columns = vars(sza)\n  ) %>%\n  # Expect that values in `sza` should be between `1.9` and `89.7`\n  col_vals_between(\n    columns = vars(sza),\n    left = 1.9,\n    right = 89.7,\n    na_pass = TRUE\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      latitude = \"numeric\",\n      month = \"factor\",\n      tst = \"character\",\n      sza = \"numeric\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `mfr` is of type: character\n  col_is_character(\n    columns = vars(mfr)\n  ) %>%\n  # Expect that column `model` is of type: character\n  col_is_character(\n    columns = vars(model)\n  ) %>%\n  # Expect that column `year` is of type: numeric\n  col_is_numeric(\n    columns = vars(year)\n  ) %>%\n  # Expect that values in `year` should be between `2014` and `2017`\n  col_vals_between(\n    columns = vars(year),\n    left = 2014,\n    right = 2017\n  ) %>%\n  # Expect that column `trim` is of type: character\n  col_is_character(\n    columns = vars(trim)\n  ) %>%\n  # Expect that column `bdy_style` is of type: character\n  col_is_character(\n    columns = vars(bdy_style)\n  ) %>%\n  # Expect that column `hp` is of type: numeric\n  col_is_numeric(\n    columns = vars(hp)\n  ) %>%\n  # Expect that values in `hp` should be between `259` and `949`\n  col_vals_between(\n    columns = vars(hp),\n    left = 259,\n    right = 949\n  ) %>%\n  # Expect that column `hp_rpm` is of type: numeric\n  col_is_numeric(\n    columns = vars(hp_rpm)\n  ) %>%\n  # Expect that values in `hp_rpm` should be between `5000` and `9000`\n  col_vals_between(\n    columns = vars(hp_rpm),\n    left = 5000,\n    right = 9000\n  ) %>%\n  # Expect that column `trq` is of type: numeric\n  col_is_numeric(\n    columns = vars(trq)\n  ) %>%\n  # Expect that values in `trq` should be between `243` and `664`\n  col_vals_between(\n    columns = vars(trq),\n    left = 243,\n    right = 664\n  ) %>%\n  # Expect that column `trq_rpm` is of type: numeric\n  col_is_numeric(\n    columns = vars(trq_rpm)\n  ) %>%\n  # Expect that values in `trq_rpm` should be between `1400` and `6750`\n  col_vals_between(\n    columns = vars(trq_rpm),\n    left = 1400,\n    right = 6750,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `mpg_c` is of type: numeric\n  col_is_numeric(\n    columns = vars(mpg_c)\n  ) %>%\n  # Expect that values in `mpg_c` should be between `11` and `28`\n  col_vals_between(\n    columns = vars(mpg_c),\n    left = 11,\n    right = 28,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `mpg_h` is of type: numeric\n  col_is_numeric(\n    columns = vars(mpg_h)\n  ) %>%\n  # Expect that values in `mpg_h` should be between `16` and `30`\n  col_vals_between(\n    columns = vars(mpg_h),\n    left = 16,\n    right = 30,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `drivetrain` is of type: character\n  col_is_character(\n    columns = vars(drivetrain)\n  ) %>%\n  # Expect that column `trsmn` is of type: character\n  col_is_character(\n    columns = vars(trsmn)\n  ) %>%\n  # Expect that column `ctry_origin` is of type: character\n  col_is_character(\n    columns = vars(ctry_origin)\n  ) %>%\n  # Expect that values in `ctry_origin` should be in the set of `United States`, `Italy`, `Japan` (and 2 more)\n  col_vals_in_set(\n    columns = vars(ctry_origin),\n    set = c(\"United States\", \"Italy\", \"Japan\", \"United Kingdom\", \"Germany\")\n  ) %>%\n  # Expect that column `msrp` is of type: numeric\n  col_is_numeric(\n    columns = vars(msrp)\n  ) %>%\n  # Expect that values in `msrp` should be between `53900` and `1416362`\n  col_vals_between(\n    columns = vars(msrp),\n    left = 53900,\n    right = 1416362\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      mfr = \"character\",\n      model = \"character\",\n      year = \"numeric\",\n      trim = \"character\",\n      bdy_style = \"character\",\n      hp = \"numeric\",\n      hp_rpm = \"numeric\",\n      trq = \"numeric\",\n      trq_rpm = \"numeric\",\n      mpg_c = \"numeric\",\n      mpg_h = \"numeric\",\n      drivetrain = \"character\",\n      trsmn = \"character\",\n      ctry_origin = \"character\",\n      msrp = \"numeric\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `open` is of type: numeric\n  col_is_numeric(\n    columns = vars(open)\n  ) %>%\n  # Expect that values in `open` should be between `16.66` and `2130.3601`\n  col_vals_between(\n    columns = vars(open),\n    left = 16.66,\n    right = 2130.3601\n  ) %>%\n  # Expect that column `high` is of type: numeric\n  col_is_numeric(\n    columns = vars(high)\n  ) %>%\n  # Expect that values in `high` should be between `16.66` and `2134.72`\n  col_vals_between(\n    columns = vars(high),\n    left = 16.66,\n    right = 2134.72\n  ) %>%\n  # Expect that column `low` is of type: numeric\n  col_is_numeric(\n    columns = vars(low)\n  ) %>%\n  # Expect that values in `low` should be between `16.66` and `2126.0601`\n  col_vals_between(\n    columns = vars(low),\n    left = 16.66,\n    right = 2126.0601\n  ) %>%\n  # Expect that column `close` is of type: numeric\n  col_is_numeric(\n    columns = vars(close)\n  ) %>%\n  # Expect that values in `close` should be between `16.66` and `2130.8201`\n  col_vals_between(\n    columns = vars(close),\n    left = 16.66,\n    right = 2130.8201\n  ) %>%\n  # Expect that column `volume` is of type: numeric\n  col_is_numeric(\n    columns = vars(volume)\n  ) %>%\n  # Expect that values in `volume` should be between `680000` and `11456230400`\n  col_vals_between(\n    columns = vars(volume),\n    left = 680000,\n    right = 11456230000\n  ) %>%\n  # Expect that column `adj_close` is of type: numeric\n  col_is_numeric(\n    columns = vars(adj_close)\n  ) %>%\n  # Expect that values in `adj_close` should be between `16.66` and `2130.8201`\n  col_vals_between(\n    columns = vars(adj_close),\n    left = 16.66,\n    right = 2130.8201\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      date = \"Date\",\n      open = \"numeric\",\n      high = \"numeric\",\n      low = \"numeric\",\n      close = \"numeric\",\n      volume = \"numeric\",\n      adj_close = \"numeric\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `id` is of type: character\n  col_is_character(\n    columns = vars(id)\n  ) %>%\n  # Expect that column `date` is of type: character\n  col_is_character(\n    columns = vars(date)\n  ) %>%\n  # Expect that column `time` is of type: character\n  col_is_character(\n    columns = vars(time)\n  ) %>%\n  # Expect that column `name` is of type: character\n  col_is_character(\n    columns = vars(name)\n  ) %>%\n  # Expect that column `size` is of type: character\n  col_is_character(\n    columns = vars(size)\n  ) %>%\n  # Expect that column `type` is of type: character\n  col_is_character(\n    columns = vars(type)\n  ) %>%\n  # Expect that column `price` is of type: numeric\n  col_is_numeric(\n    columns = vars(price)\n  ) %>%\n  # Expect that values in `price` should be between `9.75` and `35.95`\n  col_vals_between(\n    columns = vars(price),\n    left = 9.75,\n    right = 35.95\n  ) %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      id = \"character\",\n      date = \"character\",\n      time = \"character\",\n      name = \"character\",\n      size = \"character\",\n      type = \"character\",\n      price = \"numeric\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `num` is of type: numeric\n  col_is_numeric(\n    columns = vars(num)\n  ) %>%\n  # Expect that values in `num` should be between `0.1111` and `8880000`\n  col_vals_between(\n    columns = vars(num),\n    left = 0.1111,\n    right = 8880000,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `char` is of type: character\n  col_is_character(\n    columns = vars(char)\n  ) %>%\n  # Expect that column `fctr` is of type: factor\n  col_is_factor(\n    columns = vars(fctr)\n  ) %>%\n  # Expect that column `date` is of type: character\n  col_is_character(\n    columns = vars(date)\n  ) %>%\n  # Expect that column `time` is of type: character\n  col_is_character(\n    columns = vars(time)\n  ) %>%\n  # Expect that column `datetime` is of type: character\n  col_is_character(\n    columns = vars(datetime)\n  ) %>%\n  # Expect that column `currency` is of type: numeric\n  col_is_numeric(\n    columns = vars(currency)\n  ) %>%\n  # Expect that values in `currency` should be between `0.44` and `65100`\n  col_vals_between(\n    columns = vars(currency),\n    left = 0.44,\n    right = 65100,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `row` is of type: character\n  col_is_character(\n    columns = vars(row)\n  ) %>%\n  # Expect that column `group` is of type: character\n  col_is_character(\n    columns = vars(group)\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      num = \"numeric\",\n      char = \"character\",\n      fctr = \"factor\",\n      date = \"character\",\n      time = \"character\",\n      datetime = \"character\",\n      currency = \"numeric\",\n      row = \"character\",\n      group = \"character\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `carat` is of type: numeric\n  col_is_numeric(\n    columns = vars(carat)\n  ) %>%\n  # Expect that values in `carat` should be between `0.2` and `5.01`\n  col_vals_between(\n    columns = vars(carat),\n    left = 0.2,\n    right = 5.01\n  ) %>%\n  # Expect that column `cut` is of type: factor\n  col_is_factor(\n    columns = vars(cut)\n  ) %>%\n  # Expect that column `color` is of type: factor\n  col_is_factor(\n    columns = vars(color)\n  ) %>%\n  # Expect that column `clarity` is of type: factor\n  col_is_factor(\n    columns = vars(clarity)\n  ) %>%\n  # Expect that column `depth` is of type: numeric\n  col_is_numeric(\n    columns = vars(depth)\n  ) %>%\n  # Expect that values in `depth` should be between `43` and `79`\n  col_vals_between(\n    columns = vars(depth),\n    left = 43,\n    right = 79\n  ) %>%\n  # Expect that column `table` is of type: numeric\n  col_is_numeric(\n    columns = vars(table)\n  ) %>%\n  # Expect that values in `table` should be between `43` and `95`\n  col_vals_between(\n    columns = vars(table),\n    left = 43,\n    right = 95\n  ) %>%\n  # Expect that column `price` is of type: integer\n  col_is_integer(\n    columns = vars(price)\n  ) %>%\n  # Expect that values in `price` should be between `326` and `18823`\n  col_vals_between(\n    columns = vars(price),\n    left = 326,\n    right = 18823\n  ) %>%\n  # Expect that column `x` is of type: numeric\n  col_is_numeric(\n    columns = vars(x)\n  ) %>%\n  # Expect that values in `x` should be between `0` and `10.74`\n  col_vals_between(\n    columns = vars(x),\n    left = 0,\n    right = 10.74\n  ) %>%\n  # Expect that column `y` is of type: numeric\n  col_is_numeric(\n    columns = vars(y)\n  ) %>%\n  # Expect that values in `y` should be between `0` and `58.9`\n  col_vals_between(\n    columns = vars(y),\n    left = 0,\n    right = 58.9\n  ) %>%\n  # Expect that column `z` is of type: numeric\n  col_is_numeric(\n    columns = vars(z)\n  ) %>%\n  # Expect that values in `z` should be between `0` and `31.8`\n  col_vals_between(\n    columns = vars(z),\n    left = 0,\n    right = 31.8\n  ) %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      carat = \"numeric\",\n      cut = c(\"ordered\", \"factor\"),\n      color = c(\"ordered\", \"factor\"),\n      clarity = c(\"ordered\", \"factor\"),\n      depth = \"numeric\",\n      table = \"numeric\",\n      price = \"integer\",\n      x = \"numeric\",\n      y = \"numeric\",\n      z = \"numeric\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `variable` is of type: character\n  col_is_character(\n    columns = vars(variable)\n  ) %>%\n  # Expect that column `value` is of type: numeric\n  col_is_numeric(\n    columns = vars(value)\n  ) %>%\n  # Expect that values in `value` should be between `2.2` and `320402.295`\n  col_vals_between(\n    columns = vars(value),\n    left = 2.2,\n    right = 320402.295\n  ) %>%\n  # Expect that column `value01` is of type: numeric\n  col_is_numeric(\n    columns = vars(value01)\n  ) %>%\n  # Expect that values in `value01` should be between `0` and `1`\n  col_vals_between(\n    columns = vars(value01),\n    left = 0,\n    right = 1\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      date = \"Date\",\n      variable = \"character\",\n      value = \"numeric\",\n      value01 = \"numeric\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `eruptions` is of type: numeric\n  col_is_numeric(\n    columns = vars(eruptions)\n  ) %>%\n  # Expect that values in `eruptions` should be between `1.6` and `5.1`\n  col_vals_between(\n    columns = vars(eruptions),\n    left = 1.6,\n    right = 5.1\n  ) %>%\n  # Expect that column `waiting` is of type: numeric\n  col_is_numeric(\n    columns = vars(waiting)\n  ) %>%\n  # Expect that values in `waiting` should be between `43` and `96`\n  col_vals_between(\n    columns = vars(waiting),\n    left = 43,\n    right = 96\n  ) %>%\n  # Expect that column `density` is of type: numeric\n  col_is_numeric(\n    columns = vars(density)\n  ) %>%\n  # Expect that values in `density` should be between `1.25924972782687e-24` and `0.0369877986891108`\n  col_vals_between(\n    columns = vars(density),\n    left = 1.2592497e-24,\n    right = 0.0369878\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      eruptions = \"numeric\",\n      waiting = \"numeric\",\n      density = \"numeric\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `L` is of type: numeric\n  col_is_numeric(\n    columns = vars(L)\n  ) %>%\n  # Expect that values in `L` should be between `0` and `9341.57022199546`\n  col_vals_between(\n    columns = vars(L),\n    left = 0,\n    right = 9341.570222\n  ) %>%\n  # Expect that column `u` is of type: numeric\n  col_is_numeric(\n    columns = vars(u)\n  ) %>%\n  # Expect that values in `u` should be between `-7971.69318804991` and `18325.9445754841`\n  col_vals_between(\n    columns = vars(u),\n    left = -7971.693188,\n    right = 18325.9445755\n  ) %>%\n  # Expect that column `v` is of type: numeric\n  col_is_numeric(\n    columns = vars(v)\n  ) %>%\n  # Expect that values in `v` should be between `-15649.9250273997` and `10194.4413048169`\n  col_vals_between(\n    columns = vars(v),\n    left = -15649.9250274,\n    right = 10194.4413048\n  ) %>%\n  # Expect that column `col` is of type: character\n  col_is_character(\n    columns = vars(col)\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      L = \"numeric\",\n      u = \"numeric\",\n      v = \"numeric\",\n      col = \"character\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `PID` is of type: integer\n  col_is_integer(\n    columns = vars(PID)\n  ) %>%\n  # Expect that values in `PID` should be between `561` and `3052`\n  col_vals_between(\n    columns = vars(PID),\n    left = 561,\n    right = 3052\n  ) %>%\n  # Expect that column `county` is of type: character\n  col_is_character(\n    columns = vars(county)\n  ) %>%\n  # Expect that column `state` is of type: character\n  col_is_character(\n    columns = vars(state)\n  ) %>%\n  # Expect that column `area` is of type: numeric\n  col_is_numeric(\n    columns = vars(area)\n  ) %>%\n  # Expect that values in `area` should be between `0.005` and `0.11`\n  col_vals_between(\n    columns = vars(area),\n    left = 0.005,\n    right = 0.11\n  ) %>%\n  # Expect that column `poptotal` is of type: integer\n  col_is_integer(\n    columns = vars(poptotal)\n  ) %>%\n  # Expect that values in `poptotal` should be between `1701` and `5105067`\n  col_vals_between(\n    columns = vars(poptotal),\n    left = 1701,\n    right = 5105067\n  ) %>%\n  # Expect that column `popdensity` is of type: numeric\n  col_is_numeric(\n    columns = vars(popdensity)\n  ) %>%\n  # Expect that values in `popdensity` should be between `85.05` and `88018.3966`\n  col_vals_between(\n    columns = vars(popdensity),\n    left = 85.05,\n    right = 88018.3966\n  ) %>%\n  # Expect that column `popwhite` is of type: integer\n  col_is_integer(\n    columns = vars(popwhite)\n  ) %>%\n  # Expect that values in `popwhite` should be between `416` and `3204947`\n  col_vals_between(\n    columns = vars(popwhite),\n    left = 416,\n    right = 3204947\n  ) %>%\n  # Expect that column `popblack` is of type: integer\n  col_is_integer(\n    columns = vars(popblack)\n  ) %>%\n  # Expect that values in `popblack` should be between `0` and `1317147`\n  col_vals_between(\n    columns = vars(popblack),\n    left = 0,\n    right = 1317147\n  ) %>%\n  # Expect that column `popamerindian` is of type: integer\n  col_is_integer(\n    columns = vars(popamerindian)\n  ) %>%\n  # Expect that values in `popamerindian` should be between `4` and `10289`\n  col_vals_between(\n    columns = vars(popamerindian),\n    left = 4,\n    right = 10289\n  ) %>%\n  # Expect that column `popasian` is of type: integer\n  col_is_integer(\n    columns = vars(popasian)\n  ) %>%\n  # Expect that values in `popasian` should be between `0` and `188565`\n  col_vals_between(\n    columns = vars(popasian),\n    left = 0,\n    right = 188565\n  ) %>%\n  # Expect that column `popother` is of type: integer\n  col_is_integer(\n    columns = vars(popother)\n  ) %>%\n  # Expect that values in `popother` should be between `0` and `384119`\n  col_vals_between(\n    columns = vars(popother),\n    left = 0,\n    right = 384119\n  ) %>%\n  # Expect that column `percwhite` is of type: numeric\n  col_is_numeric(\n    columns = vars(percwhite)\n  ) %>%\n  # Expect that values in `percwhite` should be between `10.6940874` and `99.8228207`\n  col_vals_between(\n    columns = vars(percwhite),\n    left = 10.6940874,\n    right = 99.8228207\n  ) %>%\n  # Expect that column `percblack` is of type: numeric\n  col_is_numeric(\n    columns = vars(percblack)\n  ) %>%\n  # Expect that values in `percblack` should be between `0` and `40.2099838`\n  col_vals_between(\n    columns = vars(percblack),\n    left = 0,\n    right = 40.2099838\n  ) %>%\n  # Expect that column `percamerindan` is of type: numeric\n  col_is_numeric(\n    columns = vars(percamerindan)\n  ) %>%\n  # Expect that values in `percamerindan` should be between `0.05623243` and `89.1773779`\n  col_vals_between(\n    columns = vars(percamerindan),\n    left = 0.0562324,\n    right = 89.1773779\n  ) %>%\n  # Expect that column `percasian` is of type: numeric\n  col_is_numeric(\n    columns = vars(percasian)\n  ) %>%\n  # Expect that values in `percasian` should be between `0` and `5.07045209`\n  col_vals_between(\n    columns = vars(percasian),\n    left = 0,\n    right = 5.0704521\n  ) %>%\n  # Expect that column `percother` is of type: numeric\n  col_is_numeric(\n    columns = vars(percother)\n  ) %>%\n  # Expect that values in `percother` should be between `0` and `7.52426951`\n  col_vals_between(\n    columns = vars(percother),\n    left = 0,\n    right = 7.5242695\n  ) %>%\n  # Expect that column `popadults` is of type: integer\n  col_is_integer(\n    columns = vars(popadults)\n  ) %>%\n  # Expect that values in `popadults` should be between `1287` and `3291995`\n  col_vals_between(\n    columns = vars(popadults),\n    left = 1287,\n    right = 3291995\n  ) %>%\n  # Expect that column `perchsd` is of type: numeric\n  col_is_numeric(\n    columns = vars(perchsd)\n  ) %>%\n  # Expect that values in `perchsd` should be between `46.912261` and `88.8986737`\n  col_vals_between(\n    columns = vars(perchsd),\n    left = 46.912261,\n    right = 88.8986737\n  ) %>%\n  # Expect that column `percollege` is of type: numeric\n  col_is_numeric(\n    columns = vars(percollege)\n  ) %>%\n  # Expect that values in `percollege` should be between `7.33610822` and `48.0785102`\n  col_vals_between(\n    columns = vars(percollege),\n    left = 7.3361082,\n    right = 48.0785102\n  ) %>%\n  # Expect that column `percprof` is of type: numeric\n  col_is_numeric(\n    columns = vars(percprof)\n  ) %>%\n  # Expect that values in `percprof` should be between `0.52029136` and `20.7913213`\n  col_vals_between(\n    columns = vars(percprof),\n    left = 0.5202914,\n    right = 20.7913213\n  ) %>%\n  # Expect that column `poppovertyknown` is of type: integer\n  col_is_integer(\n    columns = vars(poppovertyknown)\n  ) %>%\n  # Expect that values in `poppovertyknown` should be between `1696` and `5023523`\n  col_vals_between(\n    columns = vars(poppovertyknown),\n    left = 1696,\n    right = 5023523\n  ) %>%\n  # Expect that column `percpovertyknown` is of type: numeric\n  col_is_numeric(\n    columns = vars(percpovertyknown)\n  ) %>%\n  # Expect that values in `percpovertyknown` should be between `80.9024412` and `99.8603839`\n  col_vals_between(\n    columns = vars(percpovertyknown),\n    left = 80.9024412,\n    right = 99.8603839\n  ) %>%\n  # Expect that column `percbelowpoverty` is of type: numeric\n  col_is_numeric(\n    columns = vars(percbelowpoverty)\n  ) %>%\n  # Expect that values in `percbelowpoverty` should be between `2.1801676` and `48.6910995`\n  col_vals_between(\n    columns = vars(percbelowpoverty),\n    left = 2.1801676,\n    right = 48.6910995\n  ) %>%\n  # Expect that column `percchildbelowpovert` is of type: numeric\n  col_is_numeric(\n    columns = vars(percchildbelowpovert)\n  ) %>%\n  # Expect that values in `percchildbelowpovert` should be between `1.91895478` and `64.3084767`\n  col_vals_between(\n    columns = vars(percchildbelowpovert),\n    left = 1.9189548,\n    right = 64.3084767\n  ) %>%\n  # Expect that column `percadultpoverty` is of type: numeric\n  col_is_numeric(\n    columns = vars(percadultpoverty)\n  ) %>%\n  # Expect that values in `percadultpoverty` should be between `1.9385043` and `43.3124644`\n  col_vals_between(\n    columns = vars(percadultpoverty),\n    left = 1.9385043,\n    right = 43.3124644\n  ) %>%\n  # Expect that column `percelderlypoverty` is of type: numeric\n  col_is_numeric(\n    columns = vars(percelderlypoverty)\n  ) %>%\n  # Expect that values in `percelderlypoverty` should be between `3.54706685` and `31.1619718`\n  col_vals_between(\n    columns = vars(percelderlypoverty),\n    left = 3.5470669,\n    right = 31.1619718\n  ) %>%\n  # Expect that column `inmetro` is of type: integer\n  col_is_integer(\n    columns = vars(inmetro)\n  ) %>%\n  # Expect that values in `inmetro` should be between `0` and `1`\n  col_vals_between(\n    columns = vars(inmetro),\n    left = 0,\n    right = 1\n  ) %>%\n  # Expect that column `category` is of type: character\n  col_is_character(\n    columns = vars(category)\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      PID = \"integer\",\n      county = \"character\",\n      state = \"character\",\n      area = \"numeric\",\n      poptotal = \"integer\",\n      popdensity = \"numeric\",\n      popwhite = \"integer\",\n      popblack = \"integer\",\n      popamerindian = \"integer\",\n      popasian = \"integer\",\n      popother = \"integer\",\n      percwhite = \"numeric\",\n      percblack = \"numeric\",\n      percamerindan = \"numeric\",\n      percasian = \"numeric\",\n      percother = \"numeric\",\n      popadults = \"integer\",\n      perchsd = \"numeric\",\n      percollege = \"numeric\",\n      percprof = \"numeric\",\n      poppovertyknown = \"integer\",\n      percpovertyknown = \"numeric\",\n      percbelowpoverty = \"numeric\",\n      percchildbelowpovert = \"numeric\",\n      percadultpoverty = \"numeric\",\n      percelderlypoverty = \"numeric\",\n      inmetro = \"integer\",\n      category = \"character\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `manufacturer` is of type: character\n  col_is_character(\n    columns = vars(manufacturer)\n  ) %>%\n  # Expect that column `model` is of type: character\n  col_is_character(\n    columns = vars(model)\n  ) %>%\n  # Expect that column `displ` is of type: numeric\n  col_is_numeric(\n    columns = vars(displ)\n  ) %>%\n  # Expect that values in `displ` should be between `1.6` and `7`\n  col_vals_between(\n    columns = vars(displ),\n    left = 1.6,\n    right = 7\n  ) %>%\n  # Expect that column `year` is of type: integer\n  col_is_integer(\n    columns = vars(year)\n  ) %>%\n  # Expect that values in `year` should be between `1999` and `2008`\n  col_vals_between(\n    columns = vars(year),\n    left = 1999,\n    right = 2008\n  ) %>%\n  # Expect that column `cyl` is of type: integer\n  col_is_integer(\n    columns = vars(cyl)\n  ) %>%\n  # Expect that values in `cyl` should be between `4` and `8`\n  col_vals_between(\n    columns = vars(cyl),\n    left = 4,\n    right = 8\n  ) %>%\n  # Expect that column `trans` is of type: character\n  col_is_character(\n    columns = vars(trans)\n  ) %>%\n  # Expect that column `drv` is of type: character\n  col_is_character(\n    columns = vars(drv)\n  ) %>%\n  # Expect that column `cty` is of type: integer\n  col_is_integer(\n    columns = vars(cty)\n  ) %>%\n  # Expect that values in `cty` should be between `9` and `35`\n  col_vals_between(\n    columns = vars(cty),\n    left = 9,\n    right = 35\n  ) %>%\n  # Expect that column `hwy` is of type: integer\n  col_is_integer(\n    columns = vars(hwy)\n  ) %>%\n  # Expect that values in `hwy` should be between `12` and `44`\n  col_vals_between(\n    columns = vars(hwy),\n    left = 12,\n    right = 44\n  ) %>%\n  # Expect that column `fl` is of type: character\n  col_is_character(\n    columns = vars(fl)\n  ) %>%\n  # Expect that column `class` is of type: character\n  col_is_character(\n    columns = vars(class)\n  ) %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      manufacturer = \"character\",\n      model = \"character\",\n      displ = \"numeric\",\n      year = \"integer\",\n      cyl = \"integer\",\n      trans = \"character\",\n      drv = \"character\",\n      cty = \"integer\",\n      hwy = \"integer\",\n      fl = \"character\",\n      class = \"character\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `name` is of type: character\n  col_is_character(\n    columns = vars(name)\n  ) %>%\n  # Expect that column `genus` is of type: character\n  col_is_character(\n    columns = vars(genus)\n  ) %>%\n  # Expect that column `vore` is of type: character\n  col_is_character(\n    columns = vars(vore)\n  ) %>%\n  # Expect that column `order` is of type: character\n  col_is_character(\n    columns = vars(order)\n  ) %>%\n  # Expect that column `conservation` is of type: character\n  col_is_character(\n    columns = vars(conservation)\n  ) %>%\n  # Expect that column `sleep_total` is of type: numeric\n  col_is_numeric(\n    columns = vars(sleep_total)\n  ) %>%\n  # Expect that values in `sleep_total` should be between `1.9` and `19.9`\n  col_vals_between(\n    columns = vars(sleep_total),\n    left = 1.9,\n    right = 19.9\n  ) %>%\n  # Expect that column `sleep_rem` is of type: numeric\n  col_is_numeric(\n    columns = vars(sleep_rem)\n  ) %>%\n  # Expect that values in `sleep_rem` should be between `0.1` and `6.6`\n  col_vals_between(\n    columns = vars(sleep_rem),\n    left = 0.1,\n    right = 6.6,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `sleep_cycle` is of type: numeric\n  col_is_numeric(\n    columns = vars(sleep_cycle)\n  ) %>%\n  # Expect that values in `sleep_cycle` should be between `0.116666667` and `1.5`\n  col_vals_between(\n    columns = vars(sleep_cycle),\n    left = 0.1166667,\n    right = 1.5,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `awake` is of type: numeric\n  col_is_numeric(\n    columns = vars(awake)\n  ) %>%\n  # Expect that values in `awake` should be between `4.1` and `22.1`\n  col_vals_between(\n    columns = vars(awake),\n    left = 4.1,\n    right = 22.1\n  ) %>%\n  # Expect that column `brainwt` is of type: numeric\n  col_is_numeric(\n    columns = vars(brainwt)\n  ) %>%\n  # Expect that values in `brainwt` should be between `0.00014` and `5.712`\n  col_vals_between(\n    columns = vars(brainwt),\n    left = 0.00014,\n    right = 5.712,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `bodywt` is of type: numeric\n  col_is_numeric(\n    columns = vars(bodywt)\n  ) %>%\n  # Expect that values in `bodywt` should be between `0.005` and `6654`\n  col_vals_between(\n    columns = vars(bodywt),\n    left = 0.005,\n    right = 6654\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      name = \"character\",\n      genus = \"character\",\n      vore = \"character\",\n      order = \"character\",\n      conservation = \"character\",\n      sleep_total = \"numeric\",\n      sleep_rem = \"numeric\",\n      sleep_cycle = \"numeric\",\n      awake = \"numeric\",\n      brainwt = \"numeric\",\n      bodywt = \"numeric\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `name` is of type: character\n  col_is_character(\n    columns = vars(name)\n  ) %>%\n  # Expect that column `party` is of type: character\n  col_is_character(\n    columns = vars(party)\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      name = \"character\",\n      start = \"Date\",\n      end = \"Date\",\n      party = \"character\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `lat` is of type: numeric\n  col_is_numeric(\n    columns = vars(lat)\n  ) %>%\n  # Expect that values in `lat` should be between `-90` and `90`\n  col_vals_between(\n    columns = vars(lat),\n    left = -90,\n    right = 90\n  ) %>%\n  # Expect that column `long` is of type: numeric\n  col_is_numeric(\n    columns = vars(long)\n  ) %>%\n  # Expect that values in `long` should be between `-180` and `180`\n  col_vals_between(\n    columns = vars(long),\n    left = -180,\n    right = 180\n  ) %>%\n  # Expect that column `delta_long` is of type: numeric\n  col_is_numeric(\n    columns = vars(delta_long)\n  ) %>%\n  # Expect that values in `delta_long` should be between `-180` and `180`\n  col_vals_between(\n    columns = vars(delta_long),\n    left = -180,\n    right = 180\n  ) %>%\n  # Expect that column `delta_lat` is of type: numeric\n  col_is_numeric(\n    columns = vars(delta_lat)\n  ) %>%\n  # Expect that values in `delta_lat` should be between `-90` and `90`\n  col_vals_between(\n    columns = vars(delta_lat),\n    left = -90,\n    right = 90\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      lat = \"numeric\",\n      long = \"numeric\",\n      delta_long = \"numeric\",\n      delta_lat = \"numeric\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `city` is of type: character\n  col_is_character(\n    columns = vars(city)\n  ) %>%\n  # Expect that column `year` is of type: integer\n  col_is_integer(\n    columns = vars(year)\n  ) %>%\n  # Expect that values in `year` should be between `2000` and `2015`\n  col_vals_between(\n    columns = vars(year),\n    left = 2000,\n    right = 2015\n  ) %>%\n  # Expect that column `month` is of type: integer\n  col_is_integer(\n    columns = vars(month)\n  ) %>%\n  # Expect that values in `month` should be between `1` and `12`\n  col_vals_between(\n    columns = vars(month),\n    left = 1,\n    right = 12\n  ) %>%\n  # Expect that column `sales` is of type: numeric\n  col_is_numeric(\n    columns = vars(sales)\n  ) %>%\n  # Expect that values in `sales` should be between `6` and `8945`\n  col_vals_between(\n    columns = vars(sales),\n    left = 6,\n    right = 8945,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `volume` is of type: numeric\n  col_is_numeric(\n    columns = vars(volume)\n  ) %>%\n  # Expect that values in `volume` should be between `835000` and `2568156780`\n  col_vals_between(\n    columns = vars(volume),\n    left = 835000,\n    right = 2568156800,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `median` is of type: numeric\n  col_is_numeric(\n    columns = vars(median)\n  ) %>%\n  # Expect that values in `median` should be between `50000` and `304200`\n  col_vals_between(\n    columns = vars(median),\n    left = 50000,\n    right = 304200,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `listings` is of type: numeric\n  col_is_numeric(\n    columns = vars(listings)\n  ) %>%\n  # Expect that values in `listings` should be between `0` and `43107`\n  col_vals_between(\n    columns = vars(listings),\n    left = 0,\n    right = 43107,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `inventory` is of type: numeric\n  col_is_numeric(\n    columns = vars(inventory)\n  ) %>%\n  # Expect that values in `inventory` should be between `0` and `55.9`\n  col_vals_between(\n    columns = vars(inventory),\n    left = 0,\n    right = 55.9,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `date` is of type: numeric\n  col_is_numeric(\n    columns = vars(date)\n  ) %>%\n  # Expect that values in `date` should be between `2000` and `2015.5`\n  col_vals_between(\n    columns = vars(date),\n    left = 2000,\n    right = 2015.5\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      city = \"character\",\n      year = \"integer\",\n      month = \"integer\",\n      sales = \"numeric\",\n      volume = \"numeric\",\n      median = \"numeric\",\n      listings = \"numeric\",\n      inventory = \"numeric\",\n      date = \"numeric\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `name` is of type: character\n  col_is_character(\n    columns = vars(name)\n  ) %>%\n  # Expect that column `plays` is of type: character\n  col_is_character(\n    columns = vars(plays)\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      name = \"character\",\n      plays = \"character\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `name` is of type: character\n  col_is_character(\n    columns = vars(name)\n  ) %>%\n  # Expect that column `band` is of type: character\n  col_is_character(\n    columns = vars(band)\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      name = \"character\",\n      band = \"character\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `name` is of type: character\n  col_is_character(\n    columns = vars(name)\n  ) %>%\n  # Expect that column `height` is of type: integer\n  col_is_integer(\n    columns = vars(height)\n  ) %>%\n  # Expect that values in `height` should be between `66` and `264`\n  col_vals_between(\n    columns = vars(height),\n    left = 66,\n    right = 264,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `mass` is of type: numeric\n  col_is_numeric(\n    columns = vars(mass)\n  ) %>%\n  # Expect that values in `mass` should be between `15` and `1358`\n  col_vals_between(\n    columns = vars(mass),\n    left = 15,\n    right = 1358,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `hair_color` is of type: character\n  col_is_character(\n    columns = vars(hair_color)\n  ) %>%\n  # Expect that column `skin_color` is of type: character\n  col_is_character(\n    columns = vars(skin_color)\n  ) %>%\n  # Expect that column `eye_color` is of type: character\n  col_is_character(\n    columns = vars(eye_color)\n  ) %>%\n  # Expect that column `birth_year` is of type: numeric\n  col_is_numeric(\n    columns = vars(birth_year)\n  ) %>%\n  # Expect that values in `birth_year` should be between `8` and `896`\n  col_vals_between(\n    columns = vars(birth_year),\n    left = 8,\n    right = 896,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `sex` is of type: character\n  col_is_character(\n    columns = vars(sex)\n  ) %>%\n  # Expect that column `gender` is of type: character\n  col_is_character(\n    columns = vars(gender)\n  ) %>%\n  # Expect that column `homeworld` is of type: character\n  col_is_character(\n    columns = vars(homeworld)\n  ) %>%\n  # Expect that column `species` is of type: character\n  col_is_character(\n    columns = vars(species)\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      name = \"character\",\n      height = \"integer\",\n      mass = \"numeric\",\n      hair_color = \"character\",\n      skin_color = \"character\",\n      eye_color = \"character\",\n      birth_year = \"numeric\",\n      sex = \"character\",\n      gender = \"character\",\n      homeworld = \"character\",\n      species = \"character\",\n      films = \"list\",\n      vehicles = \"list\",\n      starships = \"list\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `name` is of type: character\n  col_is_character(\n    columns = vars(name)\n  ) %>%\n  # Expect that column `year` is of type: numeric\n  col_is_numeric(\n    columns = vars(year)\n  ) %>%\n  # Expect that values in `year` should be between `1975` and `2020`\n  col_vals_between(\n    columns = vars(year),\n    left = 1975,\n    right = 2020\n  ) %>%\n  # Expect that column `month` is of type: numeric\n  col_is_numeric(\n    columns = vars(month)\n  ) %>%\n  # Expect that values in `month` should be between `1` and `12`\n  col_vals_between(\n    columns = vars(month),\n    left = 1,\n    right = 12\n  ) %>%\n  # Expect that column `day` is of type: integer\n  col_is_integer(\n    columns = vars(day)\n  ) %>%\n  # Expect that values in `day` should be between `1` and `31`\n  col_vals_between(\n    columns = vars(day),\n    left = 1,\n    right = 31\n  ) %>%\n  # Expect that column `hour` is of type: numeric\n  col_is_numeric(\n    columns = vars(hour)\n  ) %>%\n  # Expect that values in `hour` should be between `0` and `23`\n  col_vals_between(\n    columns = vars(hour),\n    left = 0,\n    right = 23\n  ) %>%\n  # Expect that column `lat` is of type: numeric\n  col_is_numeric(\n    columns = vars(lat)\n  ) %>%\n  # Expect that values in `lat` should be between `-90` and `90`\n  col_vals_between(\n    columns = vars(lat),\n    left = -90,\n    right = 90\n  ) %>%\n  # Expect that column `long` is of type: numeric\n  col_is_numeric(\n    columns = vars(long)\n  ) %>%\n  # Expect that values in `long` should be between `-180` and `180`\n  col_vals_between(\n    columns = vars(long),\n    left = -180,\n    right = 180\n  ) %>%\n  # Expect that column `status` is of type: character\n  col_is_character(\n    columns = vars(status)\n  ) %>%\n  # Expect that column `category` is of type: factor\n  col_is_factor(\n    columns = vars(category)\n  ) %>%\n  # Expect that column `wind` is of type: integer\n  col_is_integer(\n    columns = vars(wind)\n  ) %>%\n  # Expect that values in `wind` should be between `10` and `160`\n  col_vals_between(\n    columns = vars(wind),\n    left = 10,\n    right = 160\n  ) %>%\n  # Expect that column `pressure` is of type: integer\n  col_is_integer(\n    columns = vars(pressure)\n  ) %>%\n  # Expect that values in `pressure` should be between `882` and `1022`\n  col_vals_between(\n    columns = vars(pressure),\n    left = 882,\n    right = 1022\n  ) %>%\n  # Expect that column `tropicalstorm_force_diameter` is of type: integer\n  col_is_integer(\n    columns = vars(tropicalstorm_force_diameter)\n  ) %>%\n  # Expect that values in `tropicalstorm_force_diameter` should be between `0` and `870`\n  col_vals_between(\n    columns = vars(tropicalstorm_force_diameter),\n    left = 0,\n    right = 870,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `hurricane_force_diameter` is of type: integer\n  col_is_integer(\n    columns = vars(hurricane_force_diameter)\n  ) %>%\n  # Expect that values in `hurricane_force_diameter` should be between `0` and `300`\n  col_vals_between(\n    columns = vars(hurricane_force_diameter),\n    left = 0,\n    right = 300,\n    na_pass = TRUE\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      name = \"character\",\n      year = \"numeric\",\n      month = \"numeric\",\n      day = \"integer\",\n      hour = \"numeric\",\n      lat = \"numeric\",\n      long = \"numeric\",\n      status = \"character\",\n      category = c(\"ordered\", \"factor\"),\n      wind = \"integer\",\n      pressure = \"integer\",\n      tropicalstorm_force_diameter = \"integer\",\n      hurricane_force_diameter = \"integer\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `artist` is of type: character\n  col_is_character(\n    columns = vars(artist)\n  ) %>%\n  # Expect that column `track` is of type: character\n  col_is_character(\n    columns = vars(track)\n  ) %>%\n  # Expect that column `wk1` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk1)\n  ) %>%\n  # Expect that values in `wk1` should be between `15` and `100`\n  col_vals_between(\n    columns = vars(wk1),\n    left = 15,\n    right = 100\n  ) %>%\n  # Expect that column `wk2` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk2)\n  ) %>%\n  # Expect that values in `wk2` should be between `8` and `100`\n  col_vals_between(\n    columns = vars(wk2),\n    left = 8,\n    right = 100,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk3` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk3)\n  ) %>%\n  # Expect that values in `wk3` should be between `6` and `100`\n  col_vals_between(\n    columns = vars(wk3),\n    left = 6,\n    right = 100,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk4` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk4)\n  ) %>%\n  # Expect that values in `wk4` should be between `5` and `100`\n  col_vals_between(\n    columns = vars(wk4),\n    left = 5,\n    right = 100,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk5` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk5)\n  ) %>%\n  # Expect that values in `wk5` should be between `2` and `100`\n  col_vals_between(\n    columns = vars(wk5),\n    left = 2,\n    right = 100,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk6` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk6)\n  ) %>%\n  # Expect that values in `wk6` should be between `1` and `99`\n  col_vals_between(\n    columns = vars(wk6),\n    left = 1,\n    right = 99,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk7` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk7)\n  ) %>%\n  # Expect that values in `wk7` should be between `1` and `100`\n  col_vals_between(\n    columns = vars(wk7),\n    left = 1,\n    right = 100,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk8` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk8)\n  ) %>%\n  # Expect that values in `wk8` should be between `1` and `99`\n  col_vals_between(\n    columns = vars(wk8),\n    left = 1,\n    right = 99,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk9` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk9)\n  ) %>%\n  # Expect that values in `wk9` should be between `1` and `100`\n  col_vals_between(\n    columns = vars(wk9),\n    left = 1,\n    right = 100,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk10` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk10)\n  ) %>%\n  # Expect that values in `wk10` should be between `1` and `100`\n  col_vals_between(\n    columns = vars(wk10),\n    left = 1,\n    right = 100,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk11` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk11)\n  ) %>%\n  # Expect that values in `wk11` should be between `1` and `100`\n  col_vals_between(\n    columns = vars(wk11),\n    left = 1,\n    right = 100,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk12` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk12)\n  ) %>%\n  # Expect that values in `wk12` should be between `1` and `100`\n  col_vals_between(\n    columns = vars(wk12),\n    left = 1,\n    right = 100,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk13` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk13)\n  ) %>%\n  # Expect that values in `wk13` should be between `1` and `100`\n  col_vals_between(\n    columns = vars(wk13),\n    left = 1,\n    right = 100,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk14` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk14)\n  ) %>%\n  # Expect that values in `wk14` should be between `1` and `100`\n  col_vals_between(\n    columns = vars(wk14),\n    left = 1,\n    right = 100,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk15` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk15)\n  ) %>%\n  # Expect that values in `wk15` should be between `1` and `100`\n  col_vals_between(\n    columns = vars(wk15),\n    left = 1,\n    right = 100,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk16` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk16)\n  ) %>%\n  # Expect that values in `wk16` should be between `1` and `100`\n  col_vals_between(\n    columns = vars(wk16),\n    left = 1,\n    right = 100,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk17` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk17)\n  ) %>%\n  # Expect that values in `wk17` should be between `1` and `100`\n  col_vals_between(\n    columns = vars(wk17),\n    left = 1,\n    right = 100,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk18` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk18)\n  ) %>%\n  # Expect that values in `wk18` should be between `1` and `100`\n  col_vals_between(\n    columns = vars(wk18),\n    left = 1,\n    right = 100,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk19` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk19)\n  ) %>%\n  # Expect that values in `wk19` should be between `1` and `99`\n  col_vals_between(\n    columns = vars(wk19),\n    left = 1,\n    right = 99,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk20` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk20)\n  ) %>%\n  # Expect that values in `wk20` should be between `2` and `100`\n  col_vals_between(\n    columns = vars(wk20),\n    left = 2,\n    right = 100,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk21` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk21)\n  ) %>%\n  # Expect that values in `wk21` should be between `3` and `97`\n  col_vals_between(\n    columns = vars(wk21),\n    left = 3,\n    right = 97,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk22` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk22)\n  ) %>%\n  # Expect that values in `wk22` should be between `3` and `100`\n  col_vals_between(\n    columns = vars(wk22),\n    left = 3,\n    right = 100,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk23` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk23)\n  ) %>%\n  # Expect that values in `wk23` should be between `3` and `91`\n  col_vals_between(\n    columns = vars(wk23),\n    left = 3,\n    right = 91,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk24` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk24)\n  ) %>%\n  # Expect that values in `wk24` should be between `3` and `91`\n  col_vals_between(\n    columns = vars(wk24),\n    left = 3,\n    right = 91,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk25` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk25)\n  ) %>%\n  # Expect that values in `wk25` should be between `2` and `90`\n  col_vals_between(\n    columns = vars(wk25),\n    left = 2,\n    right = 90,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk26` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk26)\n  ) %>%\n  # Expect that values in `wk26` should be between `1` and `89`\n  col_vals_between(\n    columns = vars(wk26),\n    left = 1,\n    right = 89,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk27` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk27)\n  ) %>%\n  # Expect that values in `wk27` should be between `1` and `86`\n  col_vals_between(\n    columns = vars(wk27),\n    left = 1,\n    right = 86,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk28` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk28)\n  ) %>%\n  # Expect that values in `wk28` should be between `2` and `58`\n  col_vals_between(\n    columns = vars(wk28),\n    left = 2,\n    right = 58,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk29` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk29)\n  ) %>%\n  # Expect that values in `wk29` should be between `2` and `49`\n  col_vals_between(\n    columns = vars(wk29),\n    left = 2,\n    right = 49,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk30` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk30)\n  ) %>%\n  # Expect that values in `wk30` should be between `2` and `45`\n  col_vals_between(\n    columns = vars(wk30),\n    left = 2,\n    right = 45,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk31` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk31)\n  ) %>%\n  # Expect that values in `wk31` should be between `3` and `49`\n  col_vals_between(\n    columns = vars(wk31),\n    left = 3,\n    right = 49,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk32` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk32)\n  ) %>%\n  # Expect that values in `wk32` should be between `3` and `47`\n  col_vals_between(\n    columns = vars(wk32),\n    left = 3,\n    right = 47,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk33` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk33)\n  ) %>%\n  # Expect that values in `wk33` should be between `2` and `50`\n  col_vals_between(\n    columns = vars(wk33),\n    left = 2,\n    right = 50,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk34` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk34)\n  ) %>%\n  # Expect that values in `wk34` should be between `3` and `49`\n  col_vals_between(\n    columns = vars(wk34),\n    left = 3,\n    right = 49,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk35` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk35)\n  ) %>%\n  # Expect that values in `wk35` should be between `4` and `34`\n  col_vals_between(\n    columns = vars(wk35),\n    left = 4,\n    right = 34,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk36` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk36)\n  ) %>%\n  # Expect that values in `wk36` should be between `5` and `41`\n  col_vals_between(\n    columns = vars(wk36),\n    left = 5,\n    right = 41,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk37` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk37)\n  ) %>%\n  # Expect that values in `wk37` should be between `5` and `48`\n  col_vals_between(\n    columns = vars(wk37),\n    left = 5,\n    right = 48,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk38` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk38)\n  ) %>%\n  # Expect that values in `wk38` should be between `9` and `40`\n  col_vals_between(\n    columns = vars(wk38),\n    left = 9,\n    right = 40,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk39` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk39)\n  ) %>%\n  # Expect that values in `wk39` should be between `3` and `50`\n  col_vals_between(\n    columns = vars(wk39),\n    left = 3,\n    right = 50,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk40` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk40)\n  ) %>%\n  # Expect that values in `wk40` should be between `1` and `47`\n  col_vals_between(\n    columns = vars(wk40),\n    left = 1,\n    right = 47,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk41` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk41)\n  ) %>%\n  # Expect that values in `wk41` should be between `1` and `50`\n  col_vals_between(\n    columns = vars(wk41),\n    left = 1,\n    right = 50,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk42` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk42)\n  ) %>%\n  # Expect that values in `wk42` should be between `2` and `22`\n  col_vals_between(\n    columns = vars(wk42),\n    left = 2,\n    right = 22,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk43` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk43)\n  ) %>%\n  # Expect that values in `wk43` should be between `3` and `32`\n  col_vals_between(\n    columns = vars(wk43),\n    left = 3,\n    right = 32,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk44` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk44)\n  ) %>%\n  # Expect that values in `wk44` should be between `4` and `45`\n  col_vals_between(\n    columns = vars(wk44),\n    left = 4,\n    right = 45,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk45` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk45)\n  ) %>%\n  # Expect that values in `wk45` should be between `4` and `31`\n  col_vals_between(\n    columns = vars(wk45),\n    left = 4,\n    right = 31,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk46` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk46)\n  ) %>%\n  # Expect that values in `wk46` should be between `5` and `37`\n  col_vals_between(\n    columns = vars(wk46),\n    left = 5,\n    right = 37,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk47` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk47)\n  ) %>%\n  # Expect that values in `wk47` should be between `6` and `41`\n  col_vals_between(\n    columns = vars(wk47),\n    left = 6,\n    right = 41,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk48` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk48)\n  ) %>%\n  # Expect that values in `wk48` should be between `8` and `39`\n  col_vals_between(\n    columns = vars(wk48),\n    left = 8,\n    right = 39,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk49` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk49)\n  ) %>%\n  # Expect that values in `wk49` should be between `9` and `42`\n  col_vals_between(\n    columns = vars(wk49),\n    left = 9,\n    right = 42,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk50` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk50)\n  ) %>%\n  # Expect that values in `wk50` should be between `10` and `49`\n  col_vals_between(\n    columns = vars(wk50),\n    left = 10,\n    right = 49,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk51` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk51)\n  ) %>%\n  # Expect that values in `wk51` should be between `12` and `49`\n  col_vals_between(\n    columns = vars(wk51),\n    left = 12,\n    right = 49,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk52` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk52)\n  ) %>%\n  # Expect that values in `wk52` should be between `15` and `48`\n  col_vals_between(\n    columns = vars(wk52),\n    left = 15,\n    right = 48,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk53` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk53)\n  ) %>%\n  # Expect that values in `wk53` should be between `17` and `49`\n  col_vals_between(\n    columns = vars(wk53),\n    left = 17,\n    right = 49,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk54` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk54)\n  ) %>%\n  # Expect that values in `wk54` should be between `17` and `22`\n  col_vals_between(\n    columns = vars(wk54),\n    left = 17,\n    right = 22,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk55` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk55)\n  ) %>%\n  # Expect that values in `wk55` should be between `21` and `22`\n  col_vals_between(\n    columns = vars(wk55),\n    left = 21,\n    right = 22,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk56` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk56)\n  ) %>%\n  # Expect that values in `wk56` should be between `25` and `26`\n  col_vals_between(\n    columns = vars(wk56),\n    left = 25,\n    right = 26,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk57` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk57)\n  ) %>%\n  # Expect that values in `wk57` should be between `26` and `29`\n  col_vals_between(\n    columns = vars(wk57),\n    left = 26,\n    right = 29,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk58` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk58)\n  ) %>%\n  # Expect that values in `wk58` should be between `31` and `32`\n  col_vals_between(\n    columns = vars(wk58),\n    left = 31,\n    right = 32,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk59` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk59)\n  ) %>%\n  # Expect that values in `wk59` should be between `32` and `39`\n  col_vals_between(\n    columns = vars(wk59),\n    left = 32,\n    right = 39,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk60` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk60)\n  ) %>%\n  # Expect that values in `wk60` should be between `37` and `39`\n  col_vals_between(\n    columns = vars(wk60),\n    left = 37,\n    right = 39,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk61` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk61)\n  ) %>%\n  # Expect that values in `wk61` should be between `42` and `43`\n  col_vals_between(\n    columns = vars(wk61),\n    left = 42,\n    right = 43,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk62` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk62)\n  ) %>%\n  # Expect that values in `wk62` should be between `42` and `47`\n  col_vals_between(\n    columns = vars(wk62),\n    left = 42,\n    right = 47,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk63` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk63)\n  ) %>%\n  # Expect that values in `wk63` should be between `45` and `50`\n  col_vals_between(\n    columns = vars(wk63),\n    left = 45,\n    right = 50,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk64` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk64)\n  ) %>%\n  # Expect that values in `wk64` should be between `50` and `50`\n  col_vals_between(\n    columns = vars(wk64),\n    left = 50,\n    right = 50,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk65` is of type: numeric\n  col_is_numeric(\n    columns = vars(wk65)\n  ) %>%\n  # Expect that values in `wk65` should be between `49` and `49`\n  col_vals_between(\n    columns = vars(wk65),\n    left = 49,\n    right = 49,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `wk66` is of type: logical\n  col_is_logical(\n    columns = vars(wk66)\n  ) %>%\n  # Expect that column `wk67` is of type: logical\n  col_is_logical(\n    columns = vars(wk67)\n  ) %>%\n  # Expect that column `wk68` is of type: logical\n  col_is_logical(\n    columns = vars(wk68)\n  ) %>%\n  # Expect that column `wk69` is of type: logical\n  col_is_logical(\n    columns = vars(wk69)\n  ) %>%\n  # Expect that column `wk70` is of type: logical\n  col_is_logical(\n    columns = vars(wk70)\n  ) %>%\n  # Expect that column `wk71` is of type: logical\n  col_is_logical(\n    columns = vars(wk71)\n  ) %>%\n  # Expect that column `wk72` is of type: logical\n  col_is_logical(\n    columns = vars(wk72)\n  ) %>%\n  # Expect that column `wk73` is of type: logical\n  col_is_logical(\n    columns = vars(wk73)\n  ) %>%\n  # Expect that column `wk74` is of type: logical\n  col_is_logical(\n    columns = vars(wk74)\n  ) %>%\n  # Expect that column `wk75` is of type: logical\n  col_is_logical(\n    columns = vars(wk75)\n  ) %>%\n  # Expect that column `wk76` is of type: logical\n  col_is_logical(\n    columns = vars(wk76)\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      artist = \"character\",\n      track = \"character\",\n      date.entered = \"Date\",\n      wk1 = \"numeric\",\n      wk2 = \"numeric\",\n      wk3 = \"numeric\",\n      wk4 = \"numeric\",\n      wk5 = \"numeric\",\n      wk6 = \"numeric\",\n      wk7 = \"numeric\",\n      wk8 = \"numeric\",\n      wk9 = \"numeric\",\n      wk10 = \"numeric\",\n      wk11 = \"numeric\",\n      wk12 = \"numeric\",\n      wk13 = \"numeric\",\n      wk14 = \"numeric\",\n      wk15 = \"numeric\",\n      wk16 = \"numeric\",\n      wk17 = \"numeric\",\n      wk18 = \"numeric\",\n      wk19 = \"numeric\",\n      wk20 = \"numeric\",\n      wk21 = \"numeric\",\n      wk22 = \"numeric\",\n      wk23 = \"numeric\",\n      wk24 = \"numeric\",\n      wk25 = \"numeric\",\n      wk26 = \"numeric\",\n      wk27 = \"numeric\",\n      wk28 = \"numeric\",\n      wk29 = \"numeric\",\n      wk30 = \"numeric\",\n      wk31 = \"numeric\",\n      wk32 = \"numeric\",\n      wk33 = \"numeric\",\n      wk34 = \"numeric\",\n      wk35 = \"numeric\",\n      wk36 = \"numeric\",\n      wk37 = \"numeric\",\n      wk38 = \"numeric\",\n      wk39 = \"numeric\",\n      wk40 = \"numeric\",\n      wk41 = \"numeric\",\n      wk42 = \"numeric\",\n      wk43 = \"numeric\",\n      wk44 = \"numeric\",\n      wk45 = \"numeric\",\n      wk46 = \"numeric\",\n      wk47 = \"numeric\",\n      wk48 = \"numeric\",\n      wk49 = \"numeric\",\n      wk50 = \"numeric\",\n      wk51 = \"numeric\",\n      wk52 = \"numeric\",\n      wk53 = \"numeric\",\n      wk54 = \"numeric\",\n      wk55 = \"numeric\",\n      wk56 = \"numeric\",\n      wk57 = \"numeric\",\n      wk58 = \"numeric\",\n      wk59 = \"numeric\",\n      wk60 = \"numeric\",\n      wk61 = \"numeric\",\n      wk62 = \"numeric\",\n      wk63 = \"numeric\",\n      wk64 = \"numeric\",\n      wk65 = \"numeric\",\n      wk66 = \"logical\",\n      wk67 = \"logical\",\n      wk68 = \"logical\",\n      wk69 = \"logical\",\n      wk70 = \"logical\",\n      wk71 = \"logical\",\n      wk72 = \"logical\",\n      wk73 = \"logical\",\n      wk74 = \"logical\",\n      wk75 = \"logical\",\n      wk76 = \"logical\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `Year` is of type: numeric\n  col_is_numeric(\n    columns = vars(Year)\n  ) %>%\n  # Expect that values in `Year` should be between `2018` and `2018`\n  col_vals_between(\n    columns = vars(Year),\n    left = 2018,\n    right = 2018\n  ) %>%\n  # Expect that column `Month` is of type: character\n  col_is_character(\n    columns = vars(Month)\n  ) %>%\n  # Expect that column `1 unit` is of type: numeric\n  col_is_numeric(\n    columns = vars(1 unit)\n  ) %>%\n  # Expect that values in `1 unit` should be between `797` and `939`\n  col_vals_between(\n    columns = vars(1 unit),\n    left = 797,\n    right = 939\n  ) %>%\n  # Expect that column `2 to 4 units` is of type: logical\n  col_is_logical(\n    columns = vars(2 to 4 units)\n  ) %>%\n  # Expect that column `5 units or more` is of type: numeric\n  col_is_numeric(\n    columns = vars(5 units or more)\n  ) %>%\n  # Expect that values in `5 units or more` should be between `286` and `447`\n  col_vals_between(\n    columns = vars(5 units or more),\n    left = 286,\n    right = 447\n  ) %>%\n  # Expect that column `Northeast` is of type: numeric\n  col_is_numeric(\n    columns = vars(Northeast)\n  ) %>%\n  # Expect that values in `Northeast` should be between `76` and `150`\n  col_vals_between(\n    columns = vars(Northeast),\n    left = 76,\n    right = 150\n  ) %>%\n  # Expect that column `Midwest` is of type: numeric\n  col_is_numeric(\n    columns = vars(Midwest)\n  ) %>%\n  # Expect that values in `Midwest` should be between `154` and `205`\n  col_vals_between(\n    columns = vars(Midwest),\n    left = 154,\n    right = 205\n  ) %>%\n  # Expect that column `South` is of type: numeric\n  col_is_numeric(\n    columns = vars(South)\n  ) %>%\n  # Expect that values in `South` should be between `560` and `673`\n  col_vals_between(\n    columns = vars(South),\n    left = 560,\n    right = 673\n  ) %>%\n  # Expect that column `West` is of type: numeric\n  col_is_numeric(\n    columns = vars(West)\n  ) %>%\n  # Expect that values in `West` should be between `286` and `360`\n  col_vals_between(\n    columns = vars(West),\n    left = 286,\n    right = 360\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      Year = \"numeric\",\n      Month = \"character\",\n      1 unit = \"numeric\",\n      2 to 4 units = \"logical\",\n      5 units or more = \"numeric\",\n      Northeast = \"numeric\",\n      Midwest = \"numeric\",\n      South = \"numeric\",\n      West = \"numeric\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `fish` is of type: factor\n  col_is_factor(\n    columns = vars(fish)\n  ) %>%\n  # Expect that column `station` is of type: factor\n  col_is_factor(\n    columns = vars(station)\n  ) %>%\n  # Expect that column `seen` is of type: integer\n  col_is_integer(\n    columns = vars(seen)\n  ) %>%\n  # Expect that values in `seen` should be between `1` and `1`\n  col_vals_between(\n    columns = vars(seen),\n    left = 1,\n    right = 1\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      fish = \"factor\",\n      station = \"factor\",\n      seen = \"integer\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `country` is of type: character\n  col_is_character(\n    columns = vars(country)\n  ) %>%\n  # Expect that values in `country` should be in the set of `Afghanistan`, `Albania`, `Algeria` (and 216 more)\n  col_vals_in_set(\n    columns = vars(country),\n    set = c(\"Afghanistan\", \"Albania\", \"Algeria\", \"American Samoa\", \"Andorra\", \"Angola\", \"Anguilla\", \"Antigua and Barbuda\", \"Argentina\", \"Armenia\", \"Aruba\", \"Australia\", \"Austria\", \"Azerbaijan\", \"Bahamas\", \"Bahrain\", \"Bangladesh\", \"Barbados\", \"Belarus\", \"Belgium\", \"Belize\", \"Benin\", \"Bermuda\", \"Bhutan\", \"Bolivia (Plurinational State of)\", \"Bonaire, Saint Eustatius and Saba\", \"Bosnia and Herzegovina\", \"Botswana\", \"Brazil\", \"British Virgin Islands\", \"Brunei Darussalam\", \"Bulgaria\", \"Burkina Faso\", \"Burundi\", \"Cabo Verde\", \"Cambodia\", \"Cameroon\", \"Canada\", \"Cayman Islands\", \"Central African Republic\", \"Chad\", \"Chile\", \"China\", \"China, Hong Kong SAR\", \"China, Macao SAR\", \"Colombia\", \"Comoros\", \"Congo\", \"Cook Islands\", \"Costa Rica\", \"Côte d'Ivoire\", \"Croatia\", \"Cuba\", \"Curaçao\", \"Cyprus\", \"Czech Republic\", \"Democratic People's Republic of Korea\", \"Democratic Republic of the Congo\", \"Denmark\", \"Djibouti\", \"Dominica\", \"Dominican Republic\", \"Ecuador\", \"Egypt\", \"El Salvador\", \"Equatorial Guinea\", \"Eritrea\", \"Estonia\", \"Ethiopia\", \"Fiji\", \"Finland\", \"France\", \"French Polynesia\", \"Gabon\", \"Gambia\", \"Georgia\", \"Germany\", \"Ghana\", \"Greece\", \"Greenland\", \"Grenada\", \"Guam\", \"Guatemala\", \"Guinea\", \"Guinea-Bissau\", \"Guyana\", \"Haiti\", \"Honduras\", \"Hungary\", \"Iceland\", \"India\", \"Indonesia\", \"Iran (Islamic Republic of)\", \"Iraq\", \"Ireland\", \"Israel\", \"Italy\", \"Jamaica\", \"Japan\", \"Jordan\", \"Kazakhstan\", \"Kenya\", \"Kiribati\", \"Kuwait\", \"Kyrgyzstan\", \"Lao People's Democratic Republic\", \"Latvia\", \"Lebanon\", \"Lesotho\", \"Liberia\", \"Libya\", \"Lithuania\", \"Luxembourg\", \"Madagascar\", \"Malawi\", \"Malaysia\", \"Maldives\", \"Mali\", \"Malta\", \"Marshall Islands\", \"Mauritania\", \"Mauritius\", \"Mexico\", \"Micronesia (Federated States of)\", \"Monaco\", \"Mongolia\", \"Montenegro\", \"Montserrat\", \"Morocco\", \"Mozambique\", \"Myanmar\", \"Namibia\", \"Nauru\", \"Nepal\", \"Netherlands Antilles\", \"Netherlands\", \"New Caledonia\", \"New Zealand\", \"Nicaragua\", \"Niger\", \"Nigeria\", \"Niue\", \"Northern Mariana Islands\", \"Norway\", \"Oman\", \"Pakistan\", \"Palau\", \"Panama\", \"Papua New Guinea\", \"Paraguay\", \"Peru\", \"Philippines\", \"Poland\", \"Portugal\", \"Puerto Rico\", \"Qatar\", \"Republic of Korea\", \"Republic of Moldova\", \"Romania\", \"Russian Federation\", \"Rwanda\", \"Saint Kitts and Nevis\", \"Saint Lucia\", \"Saint Vincent and the Grenadines\", \"Samoa\", \"San Marino\", \"Sao Tome and Principe\", \"Saudi Arabia\", \"Senegal\", \"Serbia & Montenegro\", \"Serbia\", \"Seychelles\", \"Sierra Leone\", \"Singapore\", \"Sint Maarten (Dutch part)\", \"Slovakia\", \"Slovenia\", \"Solomon Islands\", \"Somalia\", \"South Africa\", \"South Sudan\", \"Spain\", \"Sri Lanka\", \"Sudan\", \"Suriname\", \"Swaziland\", \"Sweden\", \"Switzerland\", \"Syrian Arab Republic\", \"Tajikistan\", \"Thailand\", \"The Former Yugoslav Republic of Macedonia\", \"Timor-Leste\", \"Togo\", \"Tokelau\", \"Tonga\", \"Trinidad and Tobago\", \"Tunisia\", \"Turkey\", \"Turkmenistan\", \"Turks and Caicos Islands\", \"Tuvalu\", \"Uganda\", \"Ukraine\", \"United Arab Emirates\", \"United Kingdom of Great Britain and Northern Ireland\", \"United Republic of Tanzania\", \"United States of America\", \"Uruguay\", \"US Virgin Islands\", \"Uzbekistan\", \"Vanuatu\", \"Venezuela (Bolivarian Republic of)\", \"Viet Nam\", \"Wallis and Futuna Islands\", \"West Bank and Gaza Strip\", \"Yemen\", \"Zambia\", \"Zimbabwe\")\n  ) %>%\n  # Expect that column `year` is of type: integer\n  col_is_integer(\n    columns = vars(year)\n  ) %>%\n  # Expect that values in `year` should be between `1995` and `2013`\n  col_vals_between(\n    columns = vars(year),\n    left = 1995,\n    right = 2013\n  ) %>%\n  # Expect that column `population` is of type: integer\n  col_is_integer(\n    columns = vars(population)\n  ) %>%\n  # Expect that values in `population` should be between `1129` and `1385566537`\n  col_vals_between(\n    columns = vars(population),\n    left = 1129,\n    right = 1385566500\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      country = \"character\",\n      year = \"integer\",\n      population = \"integer\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `religion` is of type: character\n  col_is_character(\n    columns = vars(religion)\n  ) %>%\n  # Expect that column `<$10k` is of type: numeric\n  col_is_numeric(\n    columns = vars(<$10k)\n  ) %>%\n  # Expect that values in `<$10k` should be between `1` and `575`\n  col_vals_between(\n    columns = vars(<$10k),\n    left = 1,\n    right = 575\n  ) %>%\n  # Expect that column `$10-20k` is of type: numeric\n  col_is_numeric(\n    columns = vars($10-20k)\n  ) %>%\n  # Expect that values in `$10-20k` should be between `2` and `869`\n  col_vals_between(\n    columns = vars($10-20k),\n    left = 2,\n    right = 869\n  ) %>%\n  # Expect that column `$20-30k` is of type: numeric\n  col_is_numeric(\n    columns = vars($20-30k)\n  ) %>%\n  # Expect that values in `$20-30k` should be between `3` and `1064`\n  col_vals_between(\n    columns = vars($20-30k),\n    left = 3,\n    right = 1064\n  ) %>%\n  # Expect that column `$30-40k` is of type: numeric\n  col_is_numeric(\n    columns = vars($30-40k)\n  ) %>%\n  # Expect that values in `$30-40k` should be between `4` and `982`\n  col_vals_between(\n    columns = vars($30-40k),\n    left = 4,\n    right = 982\n  ) %>%\n  # Expect that column `$40-50k` is of type: numeric\n  col_is_numeric(\n    columns = vars($40-50k)\n  ) %>%\n  # Expect that values in `$40-50k` should be between `2` and `881`\n  col_vals_between(\n    columns = vars($40-50k),\n    left = 2,\n    right = 881\n  ) %>%\n  # Expect that column `$50-75k` is of type: numeric\n  col_is_numeric(\n    columns = vars($50-75k)\n  ) %>%\n  # Expect that values in `$50-75k` should be between `7` and `1486`\n  col_vals_between(\n    columns = vars($50-75k),\n    left = 7,\n    right = 1486\n  ) %>%\n  # Expect that column `$75-100k` is of type: numeric\n  col_is_numeric(\n    columns = vars($75-100k)\n  ) %>%\n  # Expect that values in `$75-100k` should be between `3` and `949`\n  col_vals_between(\n    columns = vars($75-100k),\n    left = 3,\n    right = 949\n  ) %>%\n  # Expect that column `$100-150k` is of type: numeric\n  col_is_numeric(\n    columns = vars($100-150k)\n  ) %>%\n  # Expect that values in `$100-150k` should be between `4` and `792`\n  col_vals_between(\n    columns = vars($100-150k),\n    left = 4,\n    right = 792\n  ) %>%\n  # Expect that column `>150k` is of type: numeric\n  col_is_numeric(\n    columns = vars(>150k)\n  ) %>%\n  # Expect that values in `>150k` should be between `4` and `634`\n  col_vals_between(\n    columns = vars(>150k),\n    left = 4,\n    right = 634\n  ) %>%\n  # Expect that column `Don't know/refused` is of type: numeric\n  col_is_numeric(\n    columns = vars(Don't know/refused)\n  ) %>%\n  # Expect that values in `Don't know/refused` should be between `8` and `1529`\n  col_vals_between(\n    columns = vars(Don't know/refused),\n    left = 8,\n    right = 1529\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      religion = \"character\",\n      <$10k = \"numeric\",\n      $10-20k = \"numeric\",\n      $20-30k = \"numeric\",\n      $30-40k = \"numeric\",\n      $40-50k = \"numeric\",\n      $50-75k = \"numeric\",\n      $75-100k = \"numeric\",\n      $100-150k = \"numeric\",\n      >150k = \"numeric\",\n      Don't know/refused = \"numeric\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `subject` is of type: character\n  col_is_character(\n    columns = vars(subject)\n  ) %>%\n  # Expect that column `time` is of type: numeric\n  col_is_numeric(\n    columns = vars(time)\n  ) %>%\n  # Expect that values in `time` should be between `1` and `1`\n  col_vals_between(\n    columns = vars(time),\n    left = 1,\n    right = 1\n  ) %>%\n  # Expect that column `age` is of type: numeric\n  col_is_numeric(\n    columns = vars(age)\n  ) %>%\n  # Expect that values in `age` should be between `33` and `33`\n  col_vals_between(\n    columns = vars(age),\n    left = 33,\n    right = 33,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `weight` is of type: numeric\n  col_is_numeric(\n    columns = vars(weight)\n  ) %>%\n  # Expect that values in `weight` should be between `90` and `90`\n  col_vals_between(\n    columns = vars(weight),\n    left = 90,\n    right = 90,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `height` is of type: numeric\n  col_is_numeric(\n    columns = vars(height)\n  ) %>%\n  # Expect that values in `height` should be between `1.54` and `1.87`\n  col_vals_between(\n    columns = vars(height),\n    left = 1.54,\n    right = 1.87\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      subject = \"character\",\n      time = \"numeric\",\n      age = \"numeric\",\n      weight = \"numeric\",\n      height = \"numeric\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `GEOID` is of type: character\n  col_is_character(\n    columns = vars(GEOID)\n  ) %>%\n  # Expect that column `NAME` is of type: character\n  col_is_character(\n    columns = vars(NAME)\n  ) %>%\n  # Expect that column `variable` is of type: character\n  col_is_character(\n    columns = vars(variable)\n  ) %>%\n  # Expect that column `estimate` is of type: numeric\n  col_is_numeric(\n    columns = vars(estimate)\n  ) %>%\n  # Expect that values in `estimate` should be between `464` and `43198`\n  col_vals_between(\n    columns = vars(estimate),\n    left = 464,\n    right = 43198,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `moe` is of type: numeric\n  col_is_numeric(\n    columns = vars(moe)\n  ) %>%\n  # Expect that values in `moe` should be between `2` and `681`\n  col_vals_between(\n    columns = vars(moe),\n    left = 2,\n    right = 681,\n    na_pass = TRUE\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      GEOID = \"character\",\n      NAME = \"character\",\n      variable = \"character\",\n      estimate = \"numeric\",\n      moe = \"numeric\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `country` is of type: character\n  col_is_character(\n    columns = vars(country)\n  ) %>%\n  # Expect that values in `country` should be in the set of `Afghanistan`, `Albania`, `Algeria` (and 216 more)\n  col_vals_in_set(\n    columns = vars(country),\n    set = c(\"Afghanistan\", \"Albania\", \"Algeria\", \"American Samoa\", \"Andorra\", \"Angola\", \"Anguilla\", \"Antigua and Barbuda\", \"Argentina\", \"Armenia\", \"Aruba\", \"Australia\", \"Austria\", \"Azerbaijan\", \"Bahamas\", \"Bahrain\", \"Bangladesh\", \"Barbados\", \"Belarus\", \"Belgium\", \"Belize\", \"Benin\", \"Bermuda\", \"Bhutan\", \"Bolivia (Plurinational State of)\", \"Bonaire, Saint Eustatius and Saba\", \"Bosnia and Herzegovina\", \"Botswana\", \"Brazil\", \"British Virgin Islands\", \"Brunei Darussalam\", \"Bulgaria\", \"Burkina Faso\", \"Burundi\", \"Cabo Verde\", \"Cambodia\", \"Cameroon\", \"Canada\", \"Cayman Islands\", \"Central African Republic\", \"Chad\", \"Chile\", \"China\", \"China, Hong Kong SAR\", \"China, Macao SAR\", \"Colombia\", \"Comoros\", \"Congo\", \"Cook Islands\", \"Costa Rica\", \"Cote d'Ivoire\", \"Croatia\", \"Cuba\", \"Curacao\", \"Cyprus\", \"Czech Republic\", \"Democratic People's Republic of Korea\", \"Democratic Republic of the Congo\", \"Denmark\", \"Djibouti\", \"Dominica\", \"Dominican Republic\", \"Ecuador\", \"Egypt\", \"El Salvador\", \"Equatorial Guinea\", \"Eritrea\", \"Estonia\", \"Ethiopia\", \"Fiji\", \"Finland\", \"France\", \"French Polynesia\", \"Gabon\", \"Gambia\", \"Georgia\", \"Germany\", \"Ghana\", \"Greece\", \"Greenland\", \"Grenada\", \"Guam\", \"Guatemala\", \"Guinea\", \"Guinea-Bissau\", \"Guyana\", \"Haiti\", \"Honduras\", \"Hungary\", \"Iceland\", \"India\", \"Indonesia\", \"Iran (Islamic Republic of)\", \"Iraq\", \"Ireland\", \"Israel\", \"Italy\", \"Jamaica\", \"Japan\", \"Jordan\", \"Kazakhstan\", \"Kenya\", \"Kiribati\", \"Kuwait\", \"Kyrgyzstan\", \"Lao People's Democratic Republic\", \"Latvia\", \"Lebanon\", \"Lesotho\", \"Liberia\", \"Libya\", \"Lithuania\", \"Luxembourg\", \"Madagascar\", \"Malawi\", \"Malaysia\", \"Maldives\", \"Mali\", \"Malta\", \"Marshall Islands\", \"Mauritania\", \"Mauritius\", \"Mexico\", \"Micronesia (Federated States of)\", \"Monaco\", \"Mongolia\", \"Montenegro\", \"Montserrat\", \"Morocco\", \"Mozambique\", \"Myanmar\", \"Namibia\", \"Nauru\", \"Nepal\", \"Netherlands\", \"Netherlands Antilles\", \"New Caledonia\", \"New Zealand\", \"Nicaragua\", \"Niger\", \"Nigeria\", \"Niue\", \"Northern Mariana Islands\", \"Norway\", \"Oman\", \"Pakistan\", \"Palau\", \"Panama\", \"Papua New Guinea\", \"Paraguay\", \"Peru\", \"Philippines\", \"Poland\", \"Portugal\", \"Puerto Rico\", \"Qatar\", \"Republic of Korea\", \"Republic of Moldova\", \"Romania\", \"Russian Federation\", \"Rwanda\", \"Saint Kitts and Nevis\", \"Saint Lucia\", \"Saint Vincent and the Grenadines\", \"Samoa\", \"San Marino\", \"Sao Tome and Principe\", \"Saudi Arabia\", \"Senegal\", \"Serbia\", \"Serbia & Montenegro\", \"Seychelles\", \"Sierra Leone\", \"Singapore\", \"Sint Maarten (Dutch part)\", \"Slovakia\", \"Slovenia\", \"Solomon Islands\", \"Somalia\", \"South Africa\", \"South Sudan\", \"Spain\", \"Sri Lanka\", \"Sudan\", \"Suriname\", \"Swaziland\", \"Sweden\", \"Switzerland\", \"Syrian Arab Republic\", \"Tajikistan\", \"Thailand\", \"The Former Yugoslav Republic of Macedonia\", \"Timor-Leste\", \"Togo\", \"Tokelau\", \"Tonga\", \"Trinidad and Tobago\", \"Tunisia\", \"Turkey\", \"Turkmenistan\", \"Turks and Caicos Islands\", \"Tuvalu\", \"Uganda\", \"Ukraine\", \"United Arab Emirates\", \"United Kingdom of Great Britain and Northern Ireland\", \"United Republic of Tanzania\", \"United States of America\", \"Uruguay\", \"US Virgin Islands\", \"Uzbekistan\", \"Vanuatu\", \"Venezuela (Bolivarian Republic of)\", \"Viet Nam\", \"Wallis and Futuna Islands\", \"West Bank and Gaza Strip\", \"Yemen\", \"Zambia\", \"Zimbabwe\")\n  ) %>%\n  # Expect that column `iso2` is of type: character\n  col_is_character(\n    columns = vars(iso2)\n  ) %>%\n  # Expect that values in `iso2` should be in the set of `AD`, `AE`, `AF` (and 246 more)\n  col_vals_in_set(\n    columns = vars(iso2),\n    set = c(\"AD\", \"AE\", \"AF\", \"AG\", \"AI\", \"AL\", \"AM\", \"AO\", \"AQ\", \"AR\", \"AS\", \"AT\", \"AU\", \"AW\", \"AX\", \"AZ\", \"BA\", \"BB\", \"BD\", \"BE\", \"BF\", \"BG\", \"BH\", \"BI\", \"BJ\", \"BL\", \"BM\", \"BN\", \"BO\", \"BQ\", \"BR\", \"BS\", \"BT\", \"BV\", \"BW\", \"BY\", \"BZ\", \"CA\", \"CC\", \"CD\", \"CF\", \"CG\", \"CH\", \"CI\", \"CK\", \"CL\", \"CM\", \"CN\", \"CO\", \"CR\", \"CU\", \"CV\", \"CW\", \"CX\", \"CY\", \"CZ\", \"DE\", \"DJ\", \"DK\", \"DM\", \"DO\", \"DZ\", \"EC\", \"EE\", \"EG\", \"EH\", \"ER\", \"ES\", \"ET\", \"FI\", \"FJ\", \"FK\", \"FM\", \"FO\", \"FR\", \"GA\", \"GB\", \"GD\", \"GE\", \"GF\", \"GG\", \"GH\", \"GI\", \"GL\", \"GM\", \"GN\", \"GP\", \"GQ\", \"GR\", \"GS\", \"GT\", \"GU\", \"GW\", \"GY\", \"HK\", \"HM\", \"HN\", \"HR\", \"HT\", \"HU\", \"ID\", \"IE\", \"IL\", \"IM\", \"IN\", \"IO\", \"IQ\", \"IR\", \"IS\", \"IT\", \"JE\", \"JM\", \"JO\", \"JP\", \"KE\", \"KG\", \"KH\", \"KI\", \"KM\", \"KN\", \"KP\", \"KR\", \"KW\", \"KY\", \"KZ\", \"LA\", \"LB\", \"LC\", \"LI\", \"LK\", \"LR\", \"LS\", \"LT\", \"LU\", \"LV\", \"LY\", \"MA\", \"MC\", \"MD\", \"ME\", \"MF\", \"MG\", \"MH\", \"MK\", \"ML\", \"MM\", \"MN\", \"MO\", \"MP\", \"MQ\", \"MR\", \"MS\", \"MT\", \"MU\", \"MV\", \"MW\", \"MX\", \"MY\", \"MZ\", \"NA\", \"NC\", \"NE\", \"NF\", \"NG\", \"NI\", \"NL\", \"NO\", \"NP\", \"NR\", \"NU\", \"NZ\", \"OM\", \"PA\", \"PE\", \"PF\", \"PG\", \"PH\", \"PK\", \"PL\", \"PM\", \"PN\", \"PR\", \"PS\", \"PT\", \"PW\", \"PY\", \"QA\", \"RE\", \"RO\", \"RS\", \"RU\", \"RW\", \"SA\", \"SB\", \"SC\", \"SD\", \"SE\", \"SG\", \"SH\", \"SI\", \"SJ\", \"SK\", \"SL\", \"SM\", \"SN\", \"SO\", \"SR\", \"SS\", \"ST\", \"SV\", \"SX\", \"SY\", \"SZ\", \"TC\", \"TD\", \"TF\", \"TG\", \"TH\", \"TJ\", \"TK\", \"TL\", \"TM\", \"TN\", \"TO\", \"TR\", \"TT\", \"TV\", \"TW\", \"TZ\", \"UA\", \"UG\", \"UM\", \"US\", \"UY\", \"UZ\", \"VA\", \"VC\", \"VE\", \"VG\", \"VI\", \"VN\", \"VU\", \"WF\", \"WS\", \"YE\", \"YT\", \"ZA\", \"ZM\", \"ZW\")\n  ) %>%\n  # Expect that column `iso3` is of type: character\n  col_is_character(\n    columns = vars(iso3)\n  ) %>%\n  # Expect that values in `iso3` should be in the set of `AND`, `ARE`, `AFG` (and 246 more)\n  col_vals_in_set(\n    columns = vars(iso3),\n    set = c(\"AND\", \"ARE\", \"AFG\", \"ATG\", \"AIA\", \"ALB\", \"ARM\", \"AGO\", \"ATA\", \"ARG\", \"ASM\", \"AUT\", \"AUS\", \"ABW\", \"ALA\", \"AZE\", \"BIH\", \"BRB\", \"BGD\", \"BEL\", \"BFA\", \"BGR\", \"BHR\", \"BDI\", \"BEN\", \"BLM\", \"BMU\", \"BRN\", \"BOL\", \"BES\", \"BRA\", \"BHS\", \"BTN\", \"BVT\", \"BWA\", \"BLR\", \"BLZ\", \"CAN\", \"CCK\", \"COD\", \"CAF\", \"COG\", \"CHE\", \"CIV\", \"COK\", \"CHL\", \"CMR\", \"CHN\", \"COL\", \"CRI\", \"CUB\", \"CPV\", \"CUW\", \"CXR\", \"CYP\", \"CZE\", \"DEU\", \"DJI\", \"DNK\", \"DMA\", \"DOM\", \"DZA\", \"ECU\", \"EST\", \"EGY\", \"ESH\", \"ERI\", \"ESP\", \"ETH\", \"FIN\", \"FJI\", \"FLK\", \"FSM\", \"FRO\", \"FRA\", \"GAB\", \"GBR\", \"GRD\", \"GEO\", \"GUF\", \"GGY\", \"GHA\", \"GIB\", \"GRL\", \"GMB\", \"GIN\", \"GLP\", \"GNQ\", \"GRC\", \"SGS\", \"GTM\", \"GUM\", \"GNB\", \"GUY\", \"HKG\", \"HMD\", \"HND\", \"HRV\", \"HTI\", \"HUN\", \"IDN\", \"IRL\", \"ISR\", \"IMN\", \"IND\", \"IOT\", \"IRQ\", \"IRN\", \"ISL\", \"ITA\", \"JEY\", \"JAM\", \"JOR\", \"JPN\", \"KEN\", \"KGZ\", \"KHM\", \"KIR\", \"COM\", \"KNA\", \"PRK\", \"KOR\", \"KWT\", \"CYM\", \"KAZ\", \"LAO\", \"LBN\", \"LCA\", \"LIE\", \"LKA\", \"LBR\", \"LSO\", \"LTU\", \"LUX\", \"LVA\", \"LBY\", \"MAR\", \"MCO\", \"MDA\", \"MNE\", \"MAF\", \"MDG\", \"MHL\", \"MKD\", \"MLI\", \"MMR\", \"MNG\", \"MAC\", \"MNP\", \"MTQ\", \"MRT\", \"MSR\", \"MLT\", \"MUS\", \"MDV\", \"MWI\", \"MEX\", \"MYS\", \"MOZ\", \"NAM\", \"NCL\", \"NER\", \"NFK\", \"NGA\", \"NIC\", \"NLD\", \"NOR\", \"NPL\", \"NRU\", \"NIU\", \"NZL\", \"OMN\", \"PAN\", \"PER\", \"PYF\", \"PNG\", \"PHL\", \"PAK\", \"POL\", \"SPM\", \"PCN\", \"PRI\", \"PSE\", \"PRT\", \"PLW\", \"PRY\", \"QAT\", \"REU\", \"ROU\", \"SRB\", \"RUS\", \"RWA\", \"SAU\", \"SLB\", \"SYC\", \"SDN\", \"SWE\", \"SGP\", \"SHN\", \"SVN\", \"SJM\", \"SVK\", \"SLE\", \"SMR\", \"SEN\", \"SOM\", \"SUR\", \"SSD\", \"STP\", \"SLV\", \"SXM\", \"SYR\", \"SWZ\", \"TCA\", \"TCD\", \"ATF\", \"TGO\", \"THA\", \"TJK\", \"TKL\", \"TLS\", \"TKM\", \"TUN\", \"TON\", \"TUR\", \"TTO\", \"TUV\", \"TWN\", \"TZA\", \"UKR\", \"UGA\", \"UMI\", \"USA\", \"URY\", \"UZB\", \"VAT\", \"VCT\", \"VEN\", \"VGB\", \"VIR\", \"VNM\", \"VUT\", \"WLF\", \"WSM\", \"YEM\", \"MYT\", \"ZAF\", \"ZMB\", \"ZWE\")\n  ) %>%\n  # Expect that column `year` is of type: integer\n  col_is_integer(\n    columns = vars(year)\n  ) %>%\n  # Expect that values in `year` should be between `1980` and `2013`\n  col_vals_between(\n    columns = vars(year),\n    left = 1980,\n    right = 2013\n  ) %>%\n  # Expect that column `new_sp_m014` is of type: integer\n  col_is_integer(\n    columns = vars(new_sp_m014)\n  ) %>%\n  # Expect that values in `new_sp_m014` should be between `0` and `5001`\n  col_vals_between(\n    columns = vars(new_sp_m014),\n    left = 0,\n    right = 5001,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_sp_m1524` is of type: integer\n  col_is_integer(\n    columns = vars(new_sp_m1524)\n  ) %>%\n  # Expect that values in `new_sp_m1524` should be between `0` and `78278`\n  col_vals_between(\n    columns = vars(new_sp_m1524),\n    left = 0,\n    right = 78278,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_sp_m2534` is of type: integer\n  col_is_integer(\n    columns = vars(new_sp_m2534)\n  ) %>%\n  # Expect that values in `new_sp_m2534` should be between `0` and `84003`\n  col_vals_between(\n    columns = vars(new_sp_m2534),\n    left = 0,\n    right = 84003,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_sp_m3544` is of type: integer\n  col_is_integer(\n    columns = vars(new_sp_m3544)\n  ) %>%\n  # Expect that values in `new_sp_m3544` should be between `0` and `90830`\n  col_vals_between(\n    columns = vars(new_sp_m3544),\n    left = 0,\n    right = 90830,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_sp_m4554` is of type: integer\n  col_is_integer(\n    columns = vars(new_sp_m4554)\n  ) %>%\n  # Expect that values in `new_sp_m4554` should be between `0` and `82921`\n  col_vals_between(\n    columns = vars(new_sp_m4554),\n    left = 0,\n    right = 82921,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_sp_m5564` is of type: integer\n  col_is_integer(\n    columns = vars(new_sp_m5564)\n  ) %>%\n  # Expect that values in `new_sp_m5564` should be between `0` and `63814`\n  col_vals_between(\n    columns = vars(new_sp_m5564),\n    left = 0,\n    right = 63814,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_sp_m65` is of type: integer\n  col_is_integer(\n    columns = vars(new_sp_m65)\n  ) %>%\n  # Expect that values in `new_sp_m65` should be between `0` and `70376`\n  col_vals_between(\n    columns = vars(new_sp_m65),\n    left = 0,\n    right = 70376,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_sp_f014` is of type: integer\n  col_is_integer(\n    columns = vars(new_sp_f014)\n  ) %>%\n  # Expect that values in `new_sp_f014` should be between `0` and `8576`\n  col_vals_between(\n    columns = vars(new_sp_f014),\n    left = 0,\n    right = 8576,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_sp_f1524` is of type: integer\n  col_is_integer(\n    columns = vars(new_sp_f1524)\n  ) %>%\n  # Expect that values in `new_sp_f1524` should be between `0` and `53975`\n  col_vals_between(\n    columns = vars(new_sp_f1524),\n    left = 0,\n    right = 53975,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_sp_f2534` is of type: integer\n  col_is_integer(\n    columns = vars(new_sp_f2534)\n  ) %>%\n  # Expect that values in `new_sp_f2534` should be between `0` and `49887`\n  col_vals_between(\n    columns = vars(new_sp_f2534),\n    left = 0,\n    right = 49887,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_sp_f3544` is of type: integer\n  col_is_integer(\n    columns = vars(new_sp_f3544)\n  ) %>%\n  # Expect that values in `new_sp_f3544` should be between `0` and `34698`\n  col_vals_between(\n    columns = vars(new_sp_f3544),\n    left = 0,\n    right = 34698,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_sp_f4554` is of type: integer\n  col_is_integer(\n    columns = vars(new_sp_f4554)\n  ) %>%\n  # Expect that values in `new_sp_f4554` should be between `0` and `23977`\n  col_vals_between(\n    columns = vars(new_sp_f4554),\n    left = 0,\n    right = 23977,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_sp_f5564` is of type: integer\n  col_is_integer(\n    columns = vars(new_sp_f5564)\n  ) %>%\n  # Expect that values in `new_sp_f5564` should be between `0` and `18203`\n  col_vals_between(\n    columns = vars(new_sp_f5564),\n    left = 0,\n    right = 18203,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_sp_f65` is of type: integer\n  col_is_integer(\n    columns = vars(new_sp_f65)\n  ) %>%\n  # Expect that values in `new_sp_f65` should be between `0` and `21339`\n  col_vals_between(\n    columns = vars(new_sp_f65),\n    left = 0,\n    right = 21339,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_sn_m014` is of type: integer\n  col_is_integer(\n    columns = vars(new_sn_m014)\n  ) %>%\n  # Expect that values in `new_sn_m014` should be between `0` and `22355`\n  col_vals_between(\n    columns = vars(new_sn_m014),\n    left = 0,\n    right = 22355,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_sn_m1524` is of type: integer\n  col_is_integer(\n    columns = vars(new_sn_m1524)\n  ) %>%\n  # Expect that values in `new_sn_m1524` should be between `0` and `60246`\n  col_vals_between(\n    columns = vars(new_sn_m1524),\n    left = 0,\n    right = 60246,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_sn_m2534` is of type: integer\n  col_is_integer(\n    columns = vars(new_sn_m2534)\n  ) %>%\n  # Expect that values in `new_sn_m2534` should be between `0` and `50282`\n  col_vals_between(\n    columns = vars(new_sn_m2534),\n    left = 0,\n    right = 50282,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_sn_m3544` is of type: integer\n  col_is_integer(\n    columns = vars(new_sn_m3544)\n  ) %>%\n  # Expect that values in `new_sn_m3544` should be between `0` and `250051`\n  col_vals_between(\n    columns = vars(new_sn_m3544),\n    left = 0,\n    right = 250051,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_sn_m4554` is of type: integer\n  col_is_integer(\n    columns = vars(new_sn_m4554)\n  ) %>%\n  # Expect that values in `new_sn_m4554` should be between `0` and `57181`\n  col_vals_between(\n    columns = vars(new_sn_m4554),\n    left = 0,\n    right = 57181,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_sn_m5564` is of type: integer\n  col_is_integer(\n    columns = vars(new_sn_m5564)\n  ) %>%\n  # Expect that values in `new_sn_m5564` should be between `0` and `64972`\n  col_vals_between(\n    columns = vars(new_sn_m5564),\n    left = 0,\n    right = 64972,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_sn_m65` is of type: integer\n  col_is_integer(\n    columns = vars(new_sn_m65)\n  ) %>%\n  # Expect that values in `new_sn_m65` should be between `0` and `74282`\n  col_vals_between(\n    columns = vars(new_sn_m65),\n    left = 0,\n    right = 74282,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_sn_f014` is of type: integer\n  col_is_integer(\n    columns = vars(new_sn_f014)\n  ) %>%\n  # Expect that values in `new_sn_f014` should be between `0` and `21406`\n  col_vals_between(\n    columns = vars(new_sn_f014),\n    left = 0,\n    right = 21406,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_sn_f1524` is of type: integer\n  col_is_integer(\n    columns = vars(new_sn_f1524)\n  ) %>%\n  # Expect that values in `new_sn_f1524` should be between `0` and `35518`\n  col_vals_between(\n    columns = vars(new_sn_f1524),\n    left = 0,\n    right = 35518,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_sn_f2534` is of type: integer\n  col_is_integer(\n    columns = vars(new_sn_f2534)\n  ) %>%\n  # Expect that values in `new_sn_f2534` should be between `0` and `28753`\n  col_vals_between(\n    columns = vars(new_sn_f2534),\n    left = 0,\n    right = 28753,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_sn_f3544` is of type: integer\n  col_is_integer(\n    columns = vars(new_sn_f3544)\n  ) %>%\n  # Expect that values in `new_sn_f3544` should be between `0` and `148811`\n  col_vals_between(\n    columns = vars(new_sn_f3544),\n    left = 0,\n    right = 148811,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_sn_f4554` is of type: integer\n  col_is_integer(\n    columns = vars(new_sn_f4554)\n  ) %>%\n  # Expect that values in `new_sn_f4554` should be between `0` and `23869`\n  col_vals_between(\n    columns = vars(new_sn_f4554),\n    left = 0,\n    right = 23869,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_sn_f5564` is of type: integer\n  col_is_integer(\n    columns = vars(new_sn_f5564)\n  ) %>%\n  # Expect that values in `new_sn_f5564` should be between `0` and `26085`\n  col_vals_between(\n    columns = vars(new_sn_f5564),\n    left = 0,\n    right = 26085,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_sn_f65` is of type: integer\n  col_is_integer(\n    columns = vars(new_sn_f65)\n  ) %>%\n  # Expect that values in `new_sn_f65` should be between `0` and `29630`\n  col_vals_between(\n    columns = vars(new_sn_f65),\n    left = 0,\n    right = 29630,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_ep_m014` is of type: integer\n  col_is_integer(\n    columns = vars(new_ep_m014)\n  ) %>%\n  # Expect that values in `new_ep_m014` should be between `0` and `7869`\n  col_vals_between(\n    columns = vars(new_ep_m014),\n    left = 0,\n    right = 7869,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_ep_m1524` is of type: integer\n  col_is_integer(\n    columns = vars(new_ep_m1524)\n  ) %>%\n  # Expect that values in `new_ep_m1524` should be between `0` and `8558`\n  col_vals_between(\n    columns = vars(new_ep_m1524),\n    left = 0,\n    right = 8558,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_ep_m2534` is of type: integer\n  col_is_integer(\n    columns = vars(new_ep_m2534)\n  ) %>%\n  # Expect that values in `new_ep_m2534` should be between `0` and `11843`\n  col_vals_between(\n    columns = vars(new_ep_m2534),\n    left = 0,\n    right = 11843,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_ep_m3544` is of type: integer\n  col_is_integer(\n    columns = vars(new_ep_m3544)\n  ) %>%\n  # Expect that values in `new_ep_m3544` should be between `0` and `105825`\n  col_vals_between(\n    columns = vars(new_ep_m3544),\n    left = 0,\n    right = 105825,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_ep_m4554` is of type: integer\n  col_is_integer(\n    columns = vars(new_ep_m4554)\n  ) %>%\n  # Expect that values in `new_ep_m4554` should be between `0` and `5875`\n  col_vals_between(\n    columns = vars(new_ep_m4554),\n    left = 0,\n    right = 5875,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_ep_m5564` is of type: integer\n  col_is_integer(\n    columns = vars(new_ep_m5564)\n  ) %>%\n  # Expect that values in `new_ep_m5564` should be between `0` and `3957`\n  col_vals_between(\n    columns = vars(new_ep_m5564),\n    left = 0,\n    right = 3957,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_ep_m65` is of type: integer\n  col_is_integer(\n    columns = vars(new_ep_m65)\n  ) %>%\n  # Expect that values in `new_ep_m65` should be between `0` and `3061`\n  col_vals_between(\n    columns = vars(new_ep_m65),\n    left = 0,\n    right = 3061,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_ep_f014` is of type: integer\n  col_is_integer(\n    columns = vars(new_ep_f014)\n  ) %>%\n  # Expect that values in `new_ep_f014` should be between `0` and `6960`\n  col_vals_between(\n    columns = vars(new_ep_f014),\n    left = 0,\n    right = 6960,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_ep_f1524` is of type: integer\n  col_is_integer(\n    columns = vars(new_ep_f1524)\n  ) %>%\n  # Expect that values in `new_ep_f1524` should be between `0` and `7866`\n  col_vals_between(\n    columns = vars(new_ep_f1524),\n    left = 0,\n    right = 7866,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_ep_f2534` is of type: integer\n  col_is_integer(\n    columns = vars(new_ep_f2534)\n  ) %>%\n  # Expect that values in `new_ep_f2534` should be between `0` and `10759`\n  col_vals_between(\n    columns = vars(new_ep_f2534),\n    left = 0,\n    right = 10759,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_ep_f3544` is of type: integer\n  col_is_integer(\n    columns = vars(new_ep_f3544)\n  ) %>%\n  # Expect that values in `new_ep_f3544` should be between `0` and `101015`\n  col_vals_between(\n    columns = vars(new_ep_f3544),\n    left = 0,\n    right = 101015,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_ep_f4554` is of type: integer\n  col_is_integer(\n    columns = vars(new_ep_f4554)\n  ) %>%\n  # Expect that values in `new_ep_f4554` should be between `0` and `6759`\n  col_vals_between(\n    columns = vars(new_ep_f4554),\n    left = 0,\n    right = 6759,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_ep_f5564` is of type: integer\n  col_is_integer(\n    columns = vars(new_ep_f5564)\n  ) %>%\n  # Expect that values in `new_ep_f5564` should be between `0` and `4684`\n  col_vals_between(\n    columns = vars(new_ep_f5564),\n    left = 0,\n    right = 4684,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `new_ep_f65` is of type: integer\n  col_is_integer(\n    columns = vars(new_ep_f65)\n  ) %>%\n  # Expect that values in `new_ep_f65` should be between `0` and `2548`\n  col_vals_between(\n    columns = vars(new_ep_f65),\n    left = 0,\n    right = 2548,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `newrel_m014` is of type: integer\n  col_is_integer(\n    columns = vars(newrel_m014)\n  ) %>%\n  # Expect that values in `newrel_m014` should be between `0` and `18617`\n  col_vals_between(\n    columns = vars(newrel_m014),\n    left = 0,\n    right = 18617,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `newrel_m1524` is of type: integer\n  col_is_integer(\n    columns = vars(newrel_m1524)\n  ) %>%\n  # Expect that values in `newrel_m1524` should be between `0` and `84785`\n  col_vals_between(\n    columns = vars(newrel_m1524),\n    left = 0,\n    right = 84785,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `newrel_m2534` is of type: integer\n  col_is_integer(\n    columns = vars(newrel_m2534)\n  ) %>%\n  # Expect that values in `newrel_m2534` should be between `0` and `76917`\n  col_vals_between(\n    columns = vars(newrel_m2534),\n    left = 0,\n    right = 76917,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `newrel_m3544` is of type: integer\n  col_is_integer(\n    columns = vars(newrel_m3544)\n  ) %>%\n  # Expect that values in `newrel_m3544` should be between `0` and `84565`\n  col_vals_between(\n    columns = vars(newrel_m3544),\n    left = 0,\n    right = 84565,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `newrel_m4554` is of type: integer\n  col_is_integer(\n    columns = vars(newrel_m4554)\n  ) %>%\n  # Expect that values in `newrel_m4554` should be between `0` and `100297`\n  col_vals_between(\n    columns = vars(newrel_m4554),\n    left = 0,\n    right = 100297,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `newrel_m5564` is of type: integer\n  col_is_integer(\n    columns = vars(newrel_m5564)\n  ) %>%\n  # Expect that values in `newrel_m5564` should be between `0` and `112558`\n  col_vals_between(\n    columns = vars(newrel_m5564),\n    left = 0,\n    right = 112558,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `newrel_m65` is of type: integer\n  col_is_integer(\n    columns = vars(newrel_m65)\n  ) %>%\n  # Expect that values in `newrel_m65` should be between `0` and `124476`\n  col_vals_between(\n    columns = vars(newrel_m65),\n    left = 0,\n    right = 124476,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `newrel_f014` is of type: integer\n  col_is_integer(\n    columns = vars(newrel_f014)\n  ) %>%\n  # Expect that values in `newrel_f014` should be between `0` and `18054`\n  col_vals_between(\n    columns = vars(newrel_f014),\n    left = 0,\n    right = 18054,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `newrel_f1524` is of type: integer\n  col_is_integer(\n    columns = vars(newrel_f1524)\n  ) %>%\n  # Expect that values in `newrel_f1524` should be between `0` and `49491`\n  col_vals_between(\n    columns = vars(newrel_f1524),\n    left = 0,\n    right = 49491,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `newrel_f2534` is of type: integer\n  col_is_integer(\n    columns = vars(newrel_f2534)\n  ) %>%\n  # Expect that values in `newrel_f2534` should be between `0` and `44985`\n  col_vals_between(\n    columns = vars(newrel_f2534),\n    left = 0,\n    right = 44985,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `newrel_f3544` is of type: integer\n  col_is_integer(\n    columns = vars(newrel_f3544)\n  ) %>%\n  # Expect that values in `newrel_f3544` should be between `0` and `38804`\n  col_vals_between(\n    columns = vars(newrel_f3544),\n    left = 0,\n    right = 38804,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `newrel_f4554` is of type: integer\n  col_is_integer(\n    columns = vars(newrel_f4554)\n  ) %>%\n  # Expect that values in `newrel_f4554` should be between `0` and `37138`\n  col_vals_between(\n    columns = vars(newrel_f4554),\n    left = 0,\n    right = 37138,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `newrel_f5564` is of type: integer\n  col_is_integer(\n    columns = vars(newrel_f5564)\n  ) %>%\n  # Expect that values in `newrel_f5564` should be between `0` and `40892`\n  col_vals_between(\n    columns = vars(newrel_f5564),\n    left = 0,\n    right = 40892,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `newrel_f65` is of type: integer\n  col_is_integer(\n    columns = vars(newrel_f65)\n  ) %>%\n  # Expect that values in `newrel_f65` should be between `0` and `47438`\n  col_vals_between(\n    columns = vars(newrel_f65),\n    left = 0,\n    right = 47438,\n    na_pass = TRUE\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      country = \"character\",\n      iso2 = \"character\",\n      iso3 = \"character\",\n      year = \"integer\",\n      new_sp_m014 = \"integer\",\n      new_sp_m1524 = \"integer\",\n      new_sp_m2534 = \"integer\",\n      new_sp_m3544 = \"integer\",\n      new_sp_m4554 = \"integer\",\n      new_sp_m5564 = \"integer\",\n      new_sp_m65 = \"integer\",\n      new_sp_f014 = \"integer\",\n      new_sp_f1524 = \"integer\",\n      new_sp_f2534 = \"integer\",\n      new_sp_f3544 = \"integer\",\n      new_sp_f4554 = \"integer\",\n      new_sp_f5564 = \"integer\",\n      new_sp_f65 = \"integer\",\n      new_sn_m014 = \"integer\",\n      new_sn_m1524 = \"integer\",\n      new_sn_m2534 = \"integer\",\n      new_sn_m3544 = \"integer\",\n      new_sn_m4554 = \"integer\",\n      new_sn_m5564 = \"integer\",\n      new_sn_m65 = \"integer\",\n      new_sn_f014 = \"integer\",\n      new_sn_f1524 = \"integer\",\n      new_sn_f2534 = \"integer\",\n      new_sn_f3544 = \"integer\",\n      new_sn_f4554 = \"integer\",\n      new_sn_f5564 = \"integer\",\n      new_sn_f65 = \"integer\",\n      new_ep_m014 = \"integer\",\n      new_ep_m1524 = \"integer\",\n      new_ep_m2534 = \"integer\",\n      new_ep_m3544 = \"integer\",\n      new_ep_m4554 = \"integer\",\n      new_ep_m5564 = \"integer\",\n      new_ep_m65 = \"integer\",\n      new_ep_f014 = \"integer\",\n      new_ep_f1524 = \"integer\",\n      new_ep_f2534 = \"integer\",\n      new_ep_f3544 = \"integer\",\n      new_ep_f4554 = \"integer\",\n      new_ep_f5564 = \"integer\",\n      new_ep_f65 = \"integer\",\n      newrel_m014 = \"integer\",\n      newrel_m1524 = \"integer\",\n      newrel_m2534 = \"integer\",\n      newrel_m3544 = \"integer\",\n      newrel_m4554 = \"integer\",\n      newrel_m5564 = \"integer\",\n      newrel_m65 = \"integer\",\n      newrel_f014 = \"integer\",\n      newrel_f1524 = \"integer\",\n      newrel_f2534 = \"integer\",\n      newrel_f3544 = \"integer\",\n      newrel_f4554 = \"integer\",\n      newrel_f5564 = \"integer\",\n      newrel_f65 = \"integer\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `country` is of type: character\n  col_is_character(\n    columns = vars(country)\n  ) %>%\n  # Expect that column `indicator` is of type: character\n  col_is_character(\n    columns = vars(indicator)\n  ) %>%\n  # Expect that column `2000` is of type: numeric\n  col_is_numeric(\n    columns = vars(2000)\n  ) %>%\n  # Expect that values in `2000` should be between `-4.07538613162288` and `6121682736`\n  col_vals_between(\n    columns = vars(2000),\n    left = -4.0753861,\n    right = 6121682700,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `2001` is of type: numeric\n  col_is_numeric(\n    columns = vars(2001)\n  ) %>%\n  # Expect that values in `2001` should be between `-3.6617798581649` and `6201340258`\n  col_vals_between(\n    columns = vars(2001),\n    left = -3.6617799,\n    right = 6201340300,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `2002` is of type: numeric\n  col_is_numeric(\n    columns = vars(2002)\n  ) %>%\n  # Expect that values in `2002` should be between `-3.43729442930536` and `6280530065`\n  col_vals_between(\n    columns = vars(2002),\n    left = -3.4372944,\n    right = 6280530100,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `2003` is of type: numeric\n  col_is_numeric(\n    columns = vars(2003)\n  ) %>%\n  # Expect that values in `2003` should be between `-3.56459008301928` and `6359899296`\n  col_vals_between(\n    columns = vars(2003),\n    left = -3.5645901,\n    right = 6359899300,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `2004` is of type: numeric\n  col_is_numeric(\n    columns = vars(2004)\n  ) %>%\n  # Expect that values in `2004` should be between `-3.59926997581487` and `6439825381`\n  col_vals_between(\n    columns = vars(2004),\n    left = -3.59927,\n    right = 6439825400,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `2005` is of type: numeric\n  col_is_numeric(\n    columns = vars(2005)\n  ) %>%\n  # Expect that values in `2005` should be between `-3.54297671077206` and `6520298763`\n  col_vals_between(\n    columns = vars(2005),\n    left = -3.5429767,\n    right = 6520298800,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `2006` is of type: numeric\n  col_is_numeric(\n    columns = vars(2006)\n  ) %>%\n  # Expect that values in `2006` should be between `-3.47568466836343` and `6601476541`\n  col_vals_between(\n    columns = vars(2006),\n    left = -3.4756847,\n    right = 6601476500,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `2007` is of type: numeric\n  col_is_numeric(\n    columns = vars(2007)\n  ) %>%\n  # Expect that values in `2007` should be between `-4.60004061604386` and `6683223772`\n  col_vals_between(\n    columns = vars(2007),\n    left = -4.6000406,\n    right = 6683223800,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `2008` is of type: numeric\n  col_is_numeric(\n    columns = vars(2008)\n  ) %>%\n  # Expect that values in `2008` should be between `-3.56105488548614` and `6766296679`\n  col_vals_between(\n    columns = vars(2008),\n    left = -3.5610549,\n    right = 6766296700,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `2009` is of type: numeric\n  col_is_numeric(\n    columns = vars(2009)\n  ) %>%\n  # Expect that values in `2009` should be between `-3.61045729542404` and `6849569339`\n  col_vals_between(\n    columns = vars(2009),\n    left = -3.6104573,\n    right = 6849569300,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `2010` is of type: numeric\n  col_is_numeric(\n    columns = vars(2010)\n  ) %>%\n  # Expect that values in `2010` should be between `-3.14404789659775` and `6932869743`\n  col_vals_between(\n    columns = vars(2010),\n    left = -3.1440479,\n    right = 6932869700,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `2011` is of type: numeric\n  col_is_numeric(\n    columns = vars(2011)\n  ) %>%\n  # Expect that values in `2011` should be between `-2.85157808256588` and `7014983968`\n  col_vals_between(\n    columns = vars(2011),\n    left = -2.8515781,\n    right = 7014984000,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `2012` is of type: numeric\n  col_is_numeric(\n    columns = vars(2012)\n  ) %>%\n  # Expect that values in `2012` should be between `-4.04340662026782` and `7099557649`\n  col_vals_between(\n    columns = vars(2012),\n    left = -4.0434066,\n    right = 7099557600,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `2013` is of type: numeric\n  col_is_numeric(\n    columns = vars(2013)\n  ) %>%\n  # Expect that values in `2013` should be between `-4.97493389750611` and `7185137526`\n  col_vals_between(\n    columns = vars(2013),\n    left = -4.9749339,\n    right = 7185137500,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `2014` is of type: numeric\n  col_is_numeric(\n    columns = vars(2014)\n  ) %>%\n  # Expect that values in `2014` should be between `-5.0855951159836` and `7271322821`\n  col_vals_between(\n    columns = vars(2014),\n    left = -5.0855951,\n    right = 7271322800,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `2015` is of type: numeric\n  col_is_numeric(\n    columns = vars(2015)\n  ) %>%\n  # Expect that values in `2015` should be between `-2.46784652277199` and `7357559450`\n  col_vals_between(\n    columns = vars(2015),\n    left = -2.4678465,\n    right = 7357559400,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `2016` is of type: numeric\n  col_is_numeric(\n    columns = vars(2016)\n  ) %>%\n  # Expect that values in `2016` should be between `-1.9613385773036` and `7444157356`\n  col_vals_between(\n    columns = vars(2016),\n    left = -1.9613386,\n    right = 7444157400,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `2017` is of type: numeric\n  col_is_numeric(\n    columns = vars(2017)\n  ) %>%\n  # Expect that values in `2017` should be between `-2.07262635183259` and `7530360149`\n  col_vals_between(\n    columns = vars(2017),\n    left = -2.0726264,\n    right = 7530360100,\n    na_pass = TRUE\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      country = \"character\",\n      indicator = \"character\",\n      2000 = \"numeric\",\n      2001 = \"numeric\",\n      2002 = \"numeric\",\n      2003 = \"numeric\",\n      2004 = \"numeric\",\n      2005 = \"numeric\",\n      2006 = \"numeric\",\n      2007 = \"numeric\",\n      2008 = \"numeric\",\n      2009 = \"numeric\",\n      2010 = \"numeric\",\n      2011 = \"numeric\",\n      2012 = \"numeric\",\n      2013 = \"numeric\",\n      2014 = \"numeric\",\n      2015 = \"numeric\",\n      2016 = \"numeric\",\n      2017 = \"numeric\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `date` is of type: integer\n  col_is_integer(\n    columns = vars(date)\n  ) %>%\n  # Expect that values in `date` should be between `20081028` and `20090414`\n  col_vals_between(\n    columns = vars(date),\n    left = 20081028,\n    right = 20090414\n  ) %>%\n  # Expect that column `opponent` is of type: character\n  col_is_character(\n    columns = vars(opponent)\n  ) %>%\n  # Expect that column `game_type` is of type: character\n  col_is_character(\n    columns = vars(game_type)\n  ) %>%\n  # Expect that column `time` is of type: character\n  col_is_character(\n    columns = vars(time)\n  ) %>%\n  # Expect that column `period` is of type: integer\n  col_is_integer(\n    columns = vars(period)\n  ) %>%\n  # Expect that values in `period` should be between `1` and `5`\n  col_vals_between(\n    columns = vars(period),\n    left = 1,\n    right = 5\n  ) %>%\n  # Expect that column `etype` is of type: character\n  col_is_character(\n    columns = vars(etype)\n  ) %>%\n  # Expect that column `team` is of type: character\n  col_is_character(\n    columns = vars(team)\n  ) %>%\n  # Expect that column `player` is of type: character\n  col_is_character(\n    columns = vars(player)\n  ) %>%\n  # Expect that column `result` is of type: character\n  col_is_character(\n    columns = vars(result)\n  ) %>%\n  # Expect that column `points` is of type: integer\n  col_is_integer(\n    columns = vars(points)\n  ) %>%\n  # Expect that values in `points` should be between `0` and `3`\n  col_vals_between(\n    columns = vars(points),\n    left = 0,\n    right = 3\n  ) %>%\n  # Expect that column `type` is of type: character\n  col_is_character(\n    columns = vars(type)\n  ) %>%\n  # Expect that column `x` is of type: integer\n  col_is_integer(\n    columns = vars(x)\n  ) %>%\n  # Expect that values in `x` should be between `0` and `51`\n  col_vals_between(\n    columns = vars(x),\n    left = 0,\n    right = 51,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `y` is of type: integer\n  col_is_integer(\n    columns = vars(y)\n  ) %>%\n  # Expect that values in `y` should be between `3` and `90`\n  col_vals_between(\n    columns = vars(y),\n    left = 3,\n    right = 90,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      date = \"integer\",\n      opponent = \"character\",\n      game_type = \"character\",\n      time = \"character\",\n      period = \"integer\",\n      etype = \"character\",\n      team = \"character\",\n      player = \"character\",\n      result = \"character\",\n      points = \"integer\",\n      type = \"character\",\n      x = \"integer\",\n      y = \"integer\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `Ozone` is of type: integer\n  col_is_integer(\n    columns = vars(Ozone)\n  ) %>%\n  # Expect that values in `Ozone` should be between `1` and `168`\n  col_vals_between(\n    columns = vars(Ozone),\n    left = 1,\n    right = 168,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `Solar.R` is of type: integer\n  col_is_integer(\n    columns = vars(Solar.R)\n  ) %>%\n  # Expect that values in `Solar.R` should be between `7` and `334`\n  col_vals_between(\n    columns = vars(Solar.R),\n    left = 7,\n    right = 334,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `Wind` is of type: numeric\n  col_is_numeric(\n    columns = vars(Wind)\n  ) %>%\n  # Expect that values in `Wind` should be between `1.7` and `20.7`\n  col_vals_between(\n    columns = vars(Wind),\n    left = 1.7,\n    right = 20.7\n  ) %>%\n  # Expect that column `Temp` is of type: integer\n  col_is_integer(\n    columns = vars(Temp)\n  ) %>%\n  # Expect that values in `Temp` should be between `56` and `97`\n  col_vals_between(\n    columns = vars(Temp),\n    left = 56,\n    right = 97\n  ) %>%\n  # Expect that column `Month` is of type: integer\n  col_is_integer(\n    columns = vars(Month)\n  ) %>%\n  # Expect that values in `Month` should be between `5` and `9`\n  col_vals_between(\n    columns = vars(Month),\n    left = 5,\n    right = 9\n  ) %>%\n  # Expect that column `Day` is of type: integer\n  col_is_integer(\n    columns = vars(Day)\n  ) %>%\n  # Expect that values in `Day` should be between `1` and `31`\n  col_vals_between(\n    columns = vars(Day),\n    left = 1,\n    right = 31\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      Ozone = \"integer\",\n      Solar.R = \"integer\",\n      Wind = \"numeric\",\n      Temp = \"integer\",\n      Month = \"integer\",\n      Day = \"integer\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `weight` is of type: numeric\n  col_is_numeric(\n    columns = vars(weight)\n  ) %>%\n  # Expect that values in `weight` should be between `108` and `423`\n  col_vals_between(\n    columns = vars(weight),\n    left = 108,\n    right = 423\n  ) %>%\n  # Expect that column `feed` is of type: factor\n  col_is_factor(\n    columns = vars(feed)\n  ) %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      weight = \"numeric\",\n      feed = \"factor\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `Sepal.Length` is of type: numeric\n  col_is_numeric(\n    columns = vars(Sepal.Length)\n  ) %>%\n  # Expect that values in `Sepal.Length` should be between `4.3` and `7.9`\n  col_vals_between(\n    columns = vars(Sepal.Length),\n    left = 4.3,\n    right = 7.9\n  ) %>%\n  # Expect that column `Sepal.Width` is of type: numeric\n  col_is_numeric(\n    columns = vars(Sepal.Width)\n  ) %>%\n  # Expect that values in `Sepal.Width` should be between `2` and `4.4`\n  col_vals_between(\n    columns = vars(Sepal.Width),\n    left = 2,\n    right = 4.4\n  ) %>%\n  # Expect that column `Petal.Length` is of type: numeric\n  col_is_numeric(\n    columns = vars(Petal.Length)\n  ) %>%\n  # Expect that values in `Petal.Length` should be between `1` and `6.9`\n  col_vals_between(\n    columns = vars(Petal.Length),\n    left = 1,\n    right = 6.9\n  ) %>%\n  # Expect that column `Petal.Width` is of type: numeric\n  col_is_numeric(\n    columns = vars(Petal.Width)\n  ) %>%\n  # Expect that values in `Petal.Width` should be between `0.1` and `2.5`\n  col_vals_between(\n    columns = vars(Petal.Width),\n    left = 0.1,\n    right = 2.5\n  ) %>%\n  # Expect that column `Species` is of type: factor\n  col_is_factor(\n    columns = vars(Species)\n  ) %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      Sepal.Length = \"numeric\",\n      Sepal.Width = \"numeric\",\n      Petal.Length = \"numeric\",\n      Petal.Width = \"numeric\",\n      Species = \"factor\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `sr` is of type: numeric\n  col_is_numeric(\n    columns = vars(sr)\n  ) %>%\n  # Expect that values in `sr` should be between `0.6` and `21.1`\n  col_vals_between(\n    columns = vars(sr),\n    left = 0.6,\n    right = 21.1\n  ) %>%\n  # Expect that column `pop15` is of type: numeric\n  col_is_numeric(\n    columns = vars(pop15)\n  ) %>%\n  # Expect that values in `pop15` should be between `21.44` and `47.64`\n  col_vals_between(\n    columns = vars(pop15),\n    left = 21.44,\n    right = 47.64\n  ) %>%\n  # Expect that column `pop75` is of type: numeric\n  col_is_numeric(\n    columns = vars(pop75)\n  ) %>%\n  # Expect that values in `pop75` should be between `0.56` and `4.7`\n  col_vals_between(\n    columns = vars(pop75),\n    left = 0.56,\n    right = 4.7\n  ) %>%\n  # Expect that column `dpi` is of type: numeric\n  col_is_numeric(\n    columns = vars(dpi)\n  ) %>%\n  # Expect that values in `dpi` should be between `88.94` and `4001.89`\n  col_vals_between(\n    columns = vars(dpi),\n    left = 88.94,\n    right = 4001.89\n  ) %>%\n  # Expect that column `ddpi` is of type: numeric\n  col_is_numeric(\n    columns = vars(ddpi)\n  ) %>%\n  # Expect that values in `ddpi` should be between `0.22` and `16.71`\n  col_vals_between(\n    columns = vars(ddpi),\n    left = 0.22,\n    right = 16.71\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      sr = \"numeric\",\n      pop15 = \"numeric\",\n      pop75 = \"numeric\",\n      dpi = \"numeric\",\n      ddpi = \"numeric\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `GNP.deflator` is of type: numeric\n  col_is_numeric(\n    columns = vars(GNP.deflator)\n  ) %>%\n  # Expect that values in `GNP.deflator` should be between `83` and `116.9`\n  col_vals_between(\n    columns = vars(GNP.deflator),\n    left = 83,\n    right = 116.9\n  ) %>%\n  # Expect that column `GNP` is of type: numeric\n  col_is_numeric(\n    columns = vars(GNP)\n  ) %>%\n  # Expect that values in `GNP` should be between `234.289` and `554.894`\n  col_vals_between(\n    columns = vars(GNP),\n    left = 234.289,\n    right = 554.894\n  ) %>%\n  # Expect that column `Unemployed` is of type: numeric\n  col_is_numeric(\n    columns = vars(Unemployed)\n  ) %>%\n  # Expect that values in `Unemployed` should be between `187` and `480.6`\n  col_vals_between(\n    columns = vars(Unemployed),\n    left = 187,\n    right = 480.6\n  ) %>%\n  # Expect that column `Armed.Forces` is of type: numeric\n  col_is_numeric(\n    columns = vars(Armed.Forces)\n  ) %>%\n  # Expect that values in `Armed.Forces` should be between `145.6` and `359.4`\n  col_vals_between(\n    columns = vars(Armed.Forces),\n    left = 145.6,\n    right = 359.4\n  ) %>%\n  # Expect that column `Population` is of type: numeric\n  col_is_numeric(\n    columns = vars(Population)\n  ) %>%\n  # Expect that values in `Population` should be between `107.608` and `130.081`\n  col_vals_between(\n    columns = vars(Population),\n    left = 107.608,\n    right = 130.081\n  ) %>%\n  # Expect that column `Year` is of type: integer\n  col_is_integer(\n    columns = vars(Year)\n  ) %>%\n  # Expect that values in `Year` should be between `1947` and `1962`\n  col_vals_between(\n    columns = vars(Year),\n    left = 1947,\n    right = 1962\n  ) %>%\n  # Expect that column `Employed` is of type: numeric\n  col_is_numeric(\n    columns = vars(Employed)\n  ) %>%\n  # Expect that values in `Employed` should be between `60.171` and `70.551`\n  col_vals_between(\n    columns = vars(Employed),\n    left = 60.171,\n    right = 70.551\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      GNP.deflator = \"numeric\",\n      GNP = \"numeric\",\n      Unemployed = \"numeric\",\n      Armed.Forces = \"numeric\",\n      Population = \"numeric\",\n      Year = \"integer\",\n      Employed = \"numeric\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `Expt` is of type: integer\n  col_is_integer(\n    columns = vars(Expt)\n  ) %>%\n  # Expect that values in `Expt` should be between `1` and `5`\n  col_vals_between(\n    columns = vars(Expt),\n    left = 1,\n    right = 5\n  ) %>%\n  # Expect that column `Run` is of type: integer\n  col_is_integer(\n    columns = vars(Run)\n  ) %>%\n  # Expect that values in `Run` should be between `1` and `20`\n  col_vals_between(\n    columns = vars(Run),\n    left = 1,\n    right = 20\n  ) %>%\n  # Expect that column `Speed` is of type: integer\n  col_is_integer(\n    columns = vars(Speed)\n  ) %>%\n  # Expect that values in `Speed` should be between `620` and `1070`\n  col_vals_between(\n    columns = vars(Speed),\n    left = 620,\n    right = 1070\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      Expt = \"integer\",\n      Run = \"integer\",\n      Speed = \"integer\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `mpg` is of type: numeric\n  col_is_numeric(\n    columns = vars(mpg)\n  ) %>%\n  # Expect that values in `mpg` should be between `10.4` and `33.9`\n  col_vals_between(\n    columns = vars(mpg),\n    left = 10.4,\n    right = 33.9\n  ) %>%\n  # Expect that column `cyl` is of type: numeric\n  col_is_numeric(\n    columns = vars(cyl)\n  ) %>%\n  # Expect that values in `cyl` should be between `4` and `8`\n  col_vals_between(\n    columns = vars(cyl),\n    left = 4,\n    right = 8\n  ) %>%\n  # Expect that column `disp` is of type: numeric\n  col_is_numeric(\n    columns = vars(disp)\n  ) %>%\n  # Expect that values in `disp` should be between `71.1` and `472`\n  col_vals_between(\n    columns = vars(disp),\n    left = 71.1,\n    right = 472\n  ) %>%\n  # Expect that column `hp` is of type: numeric\n  col_is_numeric(\n    columns = vars(hp)\n  ) %>%\n  # Expect that values in `hp` should be between `52` and `335`\n  col_vals_between(\n    columns = vars(hp),\n    left = 52,\n    right = 335\n  ) %>%\n  # Expect that column `drat` is of type: numeric\n  col_is_numeric(\n    columns = vars(drat)\n  ) %>%\n  # Expect that values in `drat` should be between `2.76` and `4.93`\n  col_vals_between(\n    columns = vars(drat),\n    left = 2.76,\n    right = 4.93\n  ) %>%\n  # Expect that column `wt` is of type: numeric\n  col_is_numeric(\n    columns = vars(wt)\n  ) %>%\n  # Expect that values in `wt` should be between `1.513` and `5.424`\n  col_vals_between(\n    columns = vars(wt),\n    left = 1.513,\n    right = 5.424\n  ) %>%\n  # Expect that column `qsec` is of type: numeric\n  col_is_numeric(\n    columns = vars(qsec)\n  ) %>%\n  # Expect that values in `qsec` should be between `14.5` and `22.9`\n  col_vals_between(\n    columns = vars(qsec),\n    left = 14.5,\n    right = 22.9\n  ) %>%\n  # Expect that column `vs` is of type: numeric\n  col_is_numeric(\n    columns = vars(vs)\n  ) %>%\n  # Expect that values in `vs` should be between `0` and `1`\n  col_vals_between(\n    columns = vars(vs),\n    left = 0,\n    right = 1\n  ) %>%\n  # Expect that column `am` is of type: numeric\n  col_is_numeric(\n    columns = vars(am)\n  ) %>%\n  # Expect that values in `am` should be between `0` and `1`\n  col_vals_between(\n    columns = vars(am),\n    left = 0,\n    right = 1\n  ) %>%\n  # Expect that column `gear` is of type: numeric\n  col_is_numeric(\n    columns = vars(gear)\n  ) %>%\n  # Expect that values in `gear` should be between `3` and `5`\n  col_vals_between(\n    columns = vars(gear),\n    left = 3,\n    right = 5\n  ) %>%\n  # Expect that column `carb` is of type: numeric\n  col_is_numeric(\n    columns = vars(carb)\n  ) %>%\n  # Expect that values in `carb` should be between `1` and `8`\n  col_vals_between(\n    columns = vars(carb),\n    left = 1,\n    right = 8\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      mpg = \"numeric\",\n      cyl = \"numeric\",\n      disp = \"numeric\",\n      hp = \"numeric\",\n      drat = \"numeric\",\n      wt = \"numeric\",\n      qsec = \"numeric\",\n      vs = \"numeric\",\n      am = \"numeric\",\n      gear = \"numeric\",\n      carb = \"numeric\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `Tree` is of type: factor\n  col_is_factor(\n    columns = vars(Tree)\n  ) %>%\n  # Expect that column `age` is of type: numeric\n  col_is_numeric(\n    columns = vars(age)\n  ) %>%\n  # Expect that values in `age` should be between `118` and `1582`\n  col_vals_between(\n    columns = vars(age),\n    left = 118,\n    right = 1582\n  ) %>%\n  # Expect that column `circumference` is of type: numeric\n  col_is_numeric(\n    columns = vars(circumference)\n  ) %>%\n  # Expect that values in `circumference` should be between `30` and `214`\n  col_vals_between(\n    columns = vars(circumference),\n    left = 30,\n    right = 214\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      Tree = c(\"ordered\", \"factor\"),\n      age = \"numeric\",\n      circumference = \"numeric\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `temperature` is of type: numeric\n  col_is_numeric(\n    columns = vars(temperature)\n  ) %>%\n  # Expect that values in `temperature` should be between `0` and `360`\n  col_vals_between(\n    columns = vars(temperature),\n    left = 0,\n    right = 360\n  ) %>%\n  # Expect that column `pressure` is of type: numeric\n  col_is_numeric(\n    columns = vars(pressure)\n  ) %>%\n  # Expect that values in `pressure` should be between `2e-04` and `806`\n  col_vals_between(\n    columns = vars(pressure),\n    left = 2e-04,\n    right = 806\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      temperature = \"numeric\",\n      pressure = \"numeric\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `lat` is of type: numeric\n  col_is_numeric(\n    columns = vars(lat)\n  ) %>%\n  # Expect that values in `lat` should be between `-90` and `90`\n  col_vals_between(\n    columns = vars(lat),\n    left = -90,\n    right = 90\n  ) %>%\n  # Expect that column `long` is of type: numeric\n  col_is_numeric(\n    columns = vars(long)\n  ) %>%\n  # Expect that values in `long` should be between `-180` and `180`\n  col_vals_between(\n    columns = vars(long),\n    left = -180,\n    right = 180\n  ) %>%\n  # Expect that column `depth` is of type: integer\n  col_is_integer(\n    columns = vars(depth)\n  ) %>%\n  # Expect that values in `depth` should be between `40` and `680`\n  col_vals_between(\n    columns = vars(depth),\n    left = 40,\n    right = 680\n  ) %>%\n  # Expect that column `mag` is of type: numeric\n  col_is_numeric(\n    columns = vars(mag)\n  ) %>%\n  # Expect that values in `mag` should be between `4` and `6.4`\n  col_vals_between(\n    columns = vars(mag),\n    left = 4,\n    right = 6.4\n  ) %>%\n  # Expect that column `stations` is of type: integer\n  col_is_integer(\n    columns = vars(stations)\n  ) %>%\n  # Expect that values in `stations` should be between `10` and `132`\n  col_vals_between(\n    columns = vars(stations),\n    left = 10,\n    right = 132\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      lat = \"numeric\",\n      long = \"numeric\",\n      depth = \"integer\",\n      mag = \"numeric\",\n      stations = \"integer\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `area` is of type: integer\n  col_is_integer(\n    columns = vars(area)\n  ) %>%\n  # Expect that values in `area` should be between `1016` and `12212`\n  col_vals_between(\n    columns = vars(area),\n    left = 1016,\n    right = 12212\n  ) %>%\n  # Expect that column `peri` is of type: numeric\n  col_is_numeric(\n    columns = vars(peri)\n  ) %>%\n  # Expect that values in `peri` should be between `308.642` and `4864.22`\n  col_vals_between(\n    columns = vars(peri),\n    left = 308.642,\n    right = 4864.22\n  ) %>%\n  # Expect that column `shape` is of type: numeric\n  col_is_numeric(\n    columns = vars(shape)\n  ) %>%\n  # Expect that values in `shape` should be between `0.0903296` and `0.464125`\n  col_vals_between(\n    columns = vars(shape),\n    left = 0.0903296,\n    right = 0.464125\n  ) %>%\n  # Expect that column `perm` is of type: numeric\n  col_is_numeric(\n    columns = vars(perm)\n  ) %>%\n  # Expect that values in `perm` should be between `6.3` and `1300`\n  col_vals_between(\n    columns = vars(perm),\n    left = 6.3,\n    right = 1300\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      area = \"integer\",\n      peri = \"numeric\",\n      shape = \"numeric\",\n      perm = \"numeric\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `Fertility` is of type: numeric\n  col_is_numeric(\n    columns = vars(Fertility)\n  ) %>%\n  # Expect that values in `Fertility` should be between `35` and `92.5`\n  col_vals_between(\n    columns = vars(Fertility),\n    left = 35,\n    right = 92.5\n  ) %>%\n  # Expect that column `Agriculture` is of type: numeric\n  col_is_numeric(\n    columns = vars(Agriculture)\n  ) %>%\n  # Expect that values in `Agriculture` should be between `1.2` and `89.7`\n  col_vals_between(\n    columns = vars(Agriculture),\n    left = 1.2,\n    right = 89.7\n  ) %>%\n  # Expect that column `Examination` is of type: integer\n  col_is_integer(\n    columns = vars(Examination)\n  ) %>%\n  # Expect that values in `Examination` should be between `3` and `37`\n  col_vals_between(\n    columns = vars(Examination),\n    left = 3,\n    right = 37\n  ) %>%\n  # Expect that column `Education` is of type: integer\n  col_is_integer(\n    columns = vars(Education)\n  ) %>%\n  # Expect that values in `Education` should be between `1` and `53`\n  col_vals_between(\n    columns = vars(Education),\n    left = 1,\n    right = 53\n  ) %>%\n  # Expect that column `Catholic` is of type: numeric\n  col_is_numeric(\n    columns = vars(Catholic)\n  ) %>%\n  # Expect that values in `Catholic` should be between `2.15` and `100`\n  col_vals_between(\n    columns = vars(Catholic),\n    left = 2.15,\n    right = 100\n  ) %>%\n  # Expect that column `Infant.Mortality` is of type: numeric\n  col_is_numeric(\n    columns = vars(Infant.Mortality)\n  ) %>%\n  # Expect that values in `Infant.Mortality` should be between `10.8` and `26.6`\n  col_vals_between(\n    columns = vars(Infant.Mortality),\n    left = 10.8,\n    right = 26.6\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      Fertility = \"numeric\",\n      Agriculture = \"numeric\",\n      Examination = \"integer\",\n      Education = \"integer\",\n      Catholic = \"numeric\",\n      Infant.Mortality = \"numeric\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `CONT` is of type: numeric\n  col_is_numeric(\n    columns = vars(CONT)\n  ) %>%\n  # Expect that values in `CONT` should be between `5.7` and `10.6`\n  col_vals_between(\n    columns = vars(CONT),\n    left = 5.7,\n    right = 10.6\n  ) %>%\n  # Expect that column `INTG` is of type: numeric\n  col_is_numeric(\n    columns = vars(INTG)\n  ) %>%\n  # Expect that values in `INTG` should be between `5.9` and `9.2`\n  col_vals_between(\n    columns = vars(INTG),\n    left = 5.9,\n    right = 9.2\n  ) %>%\n  # Expect that column `DMNR` is of type: numeric\n  col_is_numeric(\n    columns = vars(DMNR)\n  ) %>%\n  # Expect that values in `DMNR` should be between `4.3` and `9`\n  col_vals_between(\n    columns = vars(DMNR),\n    left = 4.3,\n    right = 9\n  ) %>%\n  # Expect that column `DILG` is of type: numeric\n  col_is_numeric(\n    columns = vars(DILG)\n  ) %>%\n  # Expect that values in `DILG` should be between `5.1` and `9`\n  col_vals_between(\n    columns = vars(DILG),\n    left = 5.1,\n    right = 9\n  ) %>%\n  # Expect that column `CFMG` is of type: numeric\n  col_is_numeric(\n    columns = vars(CFMG)\n  ) %>%\n  # Expect that values in `CFMG` should be between `5.4` and `8.7`\n  col_vals_between(\n    columns = vars(CFMG),\n    left = 5.4,\n    right = 8.7\n  ) %>%\n  # Expect that column `DECI` is of type: numeric\n  col_is_numeric(\n    columns = vars(DECI)\n  ) %>%\n  # Expect that values in `DECI` should be between `5.7` and `8.8`\n  col_vals_between(\n    columns = vars(DECI),\n    left = 5.7,\n    right = 8.8\n  ) %>%\n  # Expect that column `PREP` is of type: numeric\n  col_is_numeric(\n    columns = vars(PREP)\n  ) %>%\n  # Expect that values in `PREP` should be between `4.8` and `9.1`\n  col_vals_between(\n    columns = vars(PREP),\n    left = 4.8,\n    right = 9.1\n  ) %>%\n  # Expect that column `FAMI` is of type: numeric\n  col_is_numeric(\n    columns = vars(FAMI)\n  ) %>%\n  # Expect that values in `FAMI` should be between `5.1` and `9.1`\n  col_vals_between(\n    columns = vars(FAMI),\n    left = 5.1,\n    right = 9.1\n  ) %>%\n  # Expect that column `ORAL` is of type: numeric\n  col_is_numeric(\n    columns = vars(ORAL)\n  ) %>%\n  # Expect that values in `ORAL` should be between `4.7` and `8.9`\n  col_vals_between(\n    columns = vars(ORAL),\n    left = 4.7,\n    right = 8.9\n  ) %>%\n  # Expect that column `WRIT` is of type: numeric\n  col_is_numeric(\n    columns = vars(WRIT)\n  ) %>%\n  # Expect that values in `WRIT` should be between `4.9` and `9`\n  col_vals_between(\n    columns = vars(WRIT),\n    left = 4.9,\n    right = 9\n  ) %>%\n  # Expect that column `PHYS` is of type: numeric\n  col_is_numeric(\n    columns = vars(PHYS)\n  ) %>%\n  # Expect that values in `PHYS` should be between `4.7` and `9.1`\n  col_vals_between(\n    columns = vars(PHYS),\n    left = 4.7,\n    right = 9.1\n  ) %>%\n  # Expect that column `RTEN` is of type: numeric\n  col_is_numeric(\n    columns = vars(RTEN)\n  ) %>%\n  # Expect that values in `RTEN` should be between `4.8` and `9.2`\n  col_vals_between(\n    columns = vars(RTEN),\n    left = 4.8,\n    right = 9.2\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      CONT = \"numeric\",\n      INTG = \"numeric\",\n      DMNR = \"numeric\",\n      DILG = \"numeric\",\n      CFMG = \"numeric\",\n      DECI = \"numeric\",\n      PREP = \"numeric\",\n      FAMI = \"numeric\",\n      ORAL = \"numeric\",\n      WRIT = \"numeric\",\n      PHYS = \"numeric\",\n      RTEN = \"numeric\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

# draft validations for data tables can be generated in different languages

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `a` is of type: integer\n  col_is_integer(\n    columns = vars(a)\n  ) %>%\n  # Expect that values in `a` should be between `1` and `8`\n  col_vals_between(\n    columns = vars(a),\n    left = 1,\n    right = 8\n  ) %>%\n  # Expect that column `b` is of type: character\n  col_is_character(\n    columns = vars(b)\n  ) %>%\n  # Expect that column `c` is of type: numeric\n  col_is_numeric(\n    columns = vars(c)\n  ) %>%\n  # Expect that values in `c` should be between `2` and `9`\n  col_vals_between(\n    columns = vars(c),\n    left = 2,\n    right = 9,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `d` is of type: numeric\n  col_is_numeric(\n    columns = vars(d)\n  ) %>%\n  # Expect that values in `d` should be between `108.34` and `9999.99`\n  col_vals_between(\n    columns = vars(d),\n    left = 108.34,\n    right = 9999.99\n  ) %>%\n  # Expect that column `e` is of type: logical\n  col_is_logical(\n    columns = vars(e)\n  ) %>%\n  # Expect that column `f` is of type: character\n  col_is_character(\n    columns = vars(f)\n  ) %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      date_time = c(\"POSIXct\", \"POSIXt\"),\n      date = \"Date\",\n      a = \"integer\",\n      b = \"character\",\n      c = \"numeric\",\n      d = \"numeric\",\n      e = \"logical\",\n      f = \"character\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\",\n    lang = \"fr\",\n    locale = \"fr\"\n  ) %>%\n  # Attendez-vous à ce que la colonne `a` soit de type: integer\n  col_is_integer(\n    columns = vars(a)\n  ) %>%\n  # Attendez-vous à ce que les valeurs de `a` soient comprises entre `1` et `8`\n  col_vals_between(\n    columns = vars(a),\n    left = 1,\n    right = 8\n  ) %>%\n  # Attendez-vous à ce que la colonne `b` soit de type: character\n  col_is_character(\n    columns = vars(b)\n  ) %>%\n  # Attendez-vous à ce que la colonne `c` soit de type: numeric\n  col_is_numeric(\n    columns = vars(c)\n  ) %>%\n  # Attendez-vous à ce que les valeurs de `c` soient comprises entre `2` et `9`\n  col_vals_between(\n    columns = vars(c),\n    left = 2,\n    right = 9,\n    na_pass = TRUE\n  ) %>%\n  # Attendez-vous à ce que la colonne `d` soit de type: numeric\n  col_is_numeric(\n    columns = vars(d)\n  ) %>%\n  # Attendez-vous à ce que les valeurs de `d` soient comprises entre `108.34` et `9999.99`\n  col_vals_between(\n    columns = vars(d),\n    left = 108.34,\n    right = 9999.99\n  ) %>%\n  # Attendez-vous à ce que la colonne `e` soit de type: logical\n  col_is_logical(\n    columns = vars(e)\n  ) %>%\n  # Attendez-vous à ce que la colonne `f` soit de type: character\n  col_is_character(\n    columns = vars(f)\n  ) %>%\n  # Attendez-vous à ce que les schémas de colonnes correspondent\n  col_schema_match(\n    schema = col_schema(\n      date_time = c(\"POSIXct\", \"POSIXt\"),\n      date = \"Date\",\n      a = \"integer\",\n      b = \"character\",\n      c = \"numeric\",\n      d = \"numeric\",\n      e = \"logical\",\n      f = \"character\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\",\n    lang = \"de\",\n    locale = \"de\"\n  ) %>%\n  # Erwarten Sie, dass die Spalte `a` vom Typ integer ist\n  col_is_integer(\n    columns = vars(a)\n  ) %>%\n  # Erwarten Sie, dass die Werte in `a` zwischen `1` und `8` liegen sollten\n  col_vals_between(\n    columns = vars(a),\n    left = 1,\n    right = 8\n  ) %>%\n  # Erwarten Sie, dass die Spalte `b` vom Typ character ist\n  col_is_character(\n    columns = vars(b)\n  ) %>%\n  # Erwarten Sie, dass die Spalte `c` vom Typ numeric ist\n  col_is_numeric(\n    columns = vars(c)\n  ) %>%\n  # Erwarten Sie, dass die Werte in `c` zwischen `2` und `9` liegen sollten\n  col_vals_between(\n    columns = vars(c),\n    left = 2,\n    right = 9,\n    na_pass = TRUE\n  ) %>%\n  # Erwarten Sie, dass die Spalte `d` vom Typ numeric ist\n  col_is_numeric(\n    columns = vars(d)\n  ) %>%\n  # Erwarten Sie, dass die Werte in `d` zwischen `108.34` und `9999.99` liegen sollten\n  col_vals_between(\n    columns = vars(d),\n    left = 108.34,\n    right = 9999.99\n  ) %>%\n  # Erwarten Sie, dass die Spalte `e` vom Typ logical ist\n  col_is_logical(\n    columns = vars(e)\n  ) %>%\n  # Erwarten Sie, dass die Spalte `f` vom Typ character ist\n  col_is_character(\n    columns = vars(f)\n  ) %>%\n  # Erwarten Sie, dass die Spaltenschemata übereinstimmen\n  col_schema_match(\n    schema = col_schema(\n      date_time = c(\"POSIXct\", \"POSIXt\"),\n      date = \"Date\",\n      a = \"integer\",\n      b = \"character\",\n      c = \"numeric\",\n      d = \"numeric\",\n      e = \"logical\",\n      f = \"character\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\",\n    lang = \"it\",\n    locale = \"it\"\n  ) %>%\n  # Aspettati che la colonna `a` sia di tipo: integer\n  col_is_integer(\n    columns = vars(a)\n  ) %>%\n  # Aspettati che i valori in `a` siano compresi tra `1` e `8`\n  col_vals_between(\n    columns = vars(a),\n    left = 1,\n    right = 8\n  ) %>%\n  # Aspettati che la colonna `b` sia di tipo: character\n  col_is_character(\n    columns = vars(b)\n  ) %>%\n  # Aspettati che la colonna `c` sia di tipo: numeric\n  col_is_numeric(\n    columns = vars(c)\n  ) %>%\n  # Aspettati che i valori in `c` siano compresi tra `2` e `9`\n  col_vals_between(\n    columns = vars(c),\n    left = 2,\n    right = 9,\n    na_pass = TRUE\n  ) %>%\n  # Aspettati che la colonna `d` sia di tipo: numeric\n  col_is_numeric(\n    columns = vars(d)\n  ) %>%\n  # Aspettati che i valori in `d` siano compresi tra `108.34` e `9999.99`\n  col_vals_between(\n    columns = vars(d),\n    left = 108.34,\n    right = 9999.99\n  ) %>%\n  # Aspettati che la colonna `e` sia di tipo: logical\n  col_is_logical(\n    columns = vars(e)\n  ) %>%\n  # Aspettati che la colonna `f` sia di tipo: character\n  col_is_character(\n    columns = vars(f)\n  ) %>%\n  # Aspettati che gli schemi di colonna corrispondano\n  col_schema_match(\n    schema = col_schema(\n      date_time = c(\"POSIXct\", \"POSIXt\"),\n      date = \"Date\",\n      a = \"integer\",\n      b = \"character\",\n      c = \"numeric\",\n      d = \"numeric\",\n      e = \"logical\",\n      f = \"character\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\",\n    lang = \"es\",\n    locale = \"es\"\n  ) %>%\n  # Se espera que la columna `a` sea del tipo \n  col_is_integer(\n    columns = vars(a)\n  ) %>%\n  # Se espera que los valores en `a` estén entre `1` y `8`\n  col_vals_between(\n    columns = vars(a),\n    left = 1,\n    right = 8\n  ) %>%\n  # Se espera que la columna `b` sea del tipo \n  col_is_character(\n    columns = vars(b)\n  ) %>%\n  # Se espera que la columna `c` sea del tipo \n  col_is_numeric(\n    columns = vars(c)\n  ) %>%\n  # Se espera que los valores en `c` estén entre `2` y `9`\n  col_vals_between(\n    columns = vars(c),\n    left = 2,\n    right = 9,\n    na_pass = TRUE\n  ) %>%\n  # Se espera que la columna `d` sea del tipo \n  col_is_numeric(\n    columns = vars(d)\n  ) %>%\n  # Se espera que los valores en `d` estén entre `108.34` y `9999.99`\n  col_vals_between(\n    columns = vars(d),\n    left = 108.34,\n    right = 9999.99\n  ) %>%\n  # Se espera que la columna `e` sea del tipo \n  col_is_logical(\n    columns = vars(e)\n  ) %>%\n  # Se espera que la columna `f` sea del tipo \n  col_is_character(\n    columns = vars(f)\n  ) %>%\n  # Se espera que los esquemas de columna coincidan\n  col_schema_match(\n    schema = col_schema(\n      date_time = c(\"POSIXct\", \"POSIXt\"),\n      date = \"Date\",\n      a = \"integer\",\n      b = \"character\",\n      c = \"numeric\",\n      d = \"numeric\",\n      e = \"logical\",\n      f = \"character\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\",\n    lang = \"pt\",\n    locale = \"pt\"\n  ) %>%\n  # Espera-se que coluna `a` seja do tipo \n  col_is_integer(\n    columns = vars(a)\n  ) %>%\n  # Espera-se que os valores em `a` devem estar entre `1` e `8`\n  col_vals_between(\n    columns = vars(a),\n    left = 1,\n    right = 8\n  ) %>%\n  # Espera-se que coluna `b` seja do tipo \n  col_is_character(\n    columns = vars(b)\n  ) %>%\n  # Espera-se que coluna `c` seja do tipo \n  col_is_numeric(\n    columns = vars(c)\n  ) %>%\n  # Espera-se que os valores em `c` devem estar entre `2` e `9`\n  col_vals_between(\n    columns = vars(c),\n    left = 2,\n    right = 9,\n    na_pass = TRUE\n  ) %>%\n  # Espera-se que coluna `d` seja do tipo \n  col_is_numeric(\n    columns = vars(d)\n  ) %>%\n  # Espera-se que os valores em `d` devem estar entre `108.34` e `9999.99`\n  col_vals_between(\n    columns = vars(d),\n    left = 108.34,\n    right = 9999.99\n  ) %>%\n  # Espera-se que coluna `e` seja do tipo \n  col_is_logical(\n    columns = vars(e)\n  ) %>%\n  # Espera-se que coluna `f` seja do tipo \n  col_is_character(\n    columns = vars(f)\n  ) %>%\n  # Espera-se que os esquemas de coluna concordem\n  col_schema_match(\n    schema = col_schema(\n      date_time = c(\"POSIXct\", \"POSIXt\"),\n      date = \"Date\",\n      a = \"integer\",\n      b = \"character\",\n      c = \"numeric\",\n      d = \"numeric\",\n      e = \"logical\",\n      f = \"character\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\",\n    lang = \"tr\",\n    locale = \"tr\"\n  ) %>%\n  # `a` sütununun şu türde olmasını bekleyin: integer\n  col_is_integer(\n    columns = vars(a)\n  ) %>%\n  # Beklenti, `a` 'deki değerlerin `1` ile `8` arasında olması gerektiğidir\n  col_vals_between(\n    columns = vars(a),\n    left = 1,\n    right = 8\n  ) %>%\n  # `b` sütununun şu türde olmasını bekleyin: character\n  col_is_character(\n    columns = vars(b)\n  ) %>%\n  # `c` sütununun şu türde olmasını bekleyin: numeric\n  col_is_numeric(\n    columns = vars(c)\n  ) %>%\n  # Beklenti, `c` 'deki değerlerin `2` ile `9` arasında olması gerektiğidir\n  col_vals_between(\n    columns = vars(c),\n    left = 2,\n    right = 9,\n    na_pass = TRUE\n  ) %>%\n  # `d` sütununun şu türde olmasını bekleyin: numeric\n  col_is_numeric(\n    columns = vars(d)\n  ) %>%\n  # Beklenti, `d` 'deki değerlerin `108.34` ile `9999.99` arasında olması gerektiğidir\n  col_vals_between(\n    columns = vars(d),\n    left = 108.34,\n    right = 9999.99\n  ) %>%\n  # `e` sütununun şu türde olmasını bekleyin: logical\n  col_is_logical(\n    columns = vars(e)\n  ) %>%\n  # `f` sütununun şu türde olmasını bekleyin: character\n  col_is_character(\n    columns = vars(f)\n  ) %>%\n  # Sütun şemalarının eşleşmesini bekleyin\n  col_schema_match(\n    schema = col_schema(\n      date_time = c(\"POSIXct\", \"POSIXt\"),\n      date = \"Date\",\n      a = \"integer\",\n      b = \"character\",\n      c = \"numeric\",\n      d = \"numeric\",\n      e = \"logical\",\n      f = \"character\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\",\n    lang = \"zh\",\n    locale = \"zh\"\n  ) %>%\n  # 预期列 `a`为类型 \n  col_is_integer(\n    columns = vars(a)\n  ) %>%\n  # 预期在`a` 的值应当在 `1`和 `8`之间。 \n  col_vals_between(\n    columns = vars(a),\n    left = 1,\n    right = 8\n  ) %>%\n  # 预期列 `b`为类型 \n  col_is_character(\n    columns = vars(b)\n  ) %>%\n  # 预期列 `c`为类型 \n  col_is_numeric(\n    columns = vars(c)\n  ) %>%\n  # 预期在`c` 的值应当在 `2`和 `9`之间。 \n  col_vals_between(\n    columns = vars(c),\n    left = 2,\n    right = 9,\n    na_pass = TRUE\n  ) %>%\n  # 预期列 `d`为类型 \n  col_is_numeric(\n    columns = vars(d)\n  ) %>%\n  # 预期在`d` 的值应当在 `108.34`和 `9999.99`之间。 \n  col_vals_between(\n    columns = vars(d),\n    left = 108.34,\n    right = 9999.99\n  ) %>%\n  # 预期列 `e`为类型 \n  col_is_logical(\n    columns = vars(e)\n  ) %>%\n  # 预期列 `f`为类型 \n  col_is_character(\n    columns = vars(f)\n  ) %>%\n  # 预期列模式（column schemas）应当匹配。 \n  col_schema_match(\n    schema = col_schema(\n      date_time = c(\"POSIXct\", \"POSIXt\"),\n      date = \"Date\",\n      a = \"integer\",\n      b = \"character\",\n      c = \"numeric\",\n      d = \"numeric\",\n      e = \"logical\",\n      f = \"character\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\",\n    lang = \"ru\",\n    locale = \"ru\"\n  ) %>%\n  # Ожидайте, что столбец `a` имеет тип: integer\n  col_is_integer(\n    columns = vars(a)\n  ) %>%\n  # Ожидайте, что значения в `a` должны находиться между `1` и `8`\n  col_vals_between(\n    columns = vars(a),\n    left = 1,\n    right = 8\n  ) %>%\n  # Ожидайте, что столбец `b` имеет тип: character\n  col_is_character(\n    columns = vars(b)\n  ) %>%\n  # Ожидайте, что столбец `c` имеет тип: numeric\n  col_is_numeric(\n    columns = vars(c)\n  ) %>%\n  # Ожидайте, что значения в `c` должны находиться между `2` и `9`\n  col_vals_between(\n    columns = vars(c),\n    left = 2,\n    right = 9,\n    na_pass = TRUE\n  ) %>%\n  # Ожидайте, что столбец `d` имеет тип: numeric\n  col_is_numeric(\n    columns = vars(d)\n  ) %>%\n  # Ожидайте, что значения в `d` должны находиться между `108.34` и `9999.99`\n  col_vals_between(\n    columns = vars(d),\n    left = 108.34,\n    right = 9999.99\n  ) %>%\n  # Ожидайте, что столбец `e` имеет тип: logical\n  col_is_logical(\n    columns = vars(e)\n  ) %>%\n  # Ожидайте, что столбец `f` имеет тип: character\n  col_is_character(\n    columns = vars(f)\n  ) %>%\n  # Ожидайте, что схемы столбцов совпадают\n  col_schema_match(\n    schema = col_schema(\n      date_time = c(\"POSIXct\", \"POSIXt\"),\n      date = \"Date\",\n      a = \"integer\",\n      b = \"character\",\n      c = \"numeric\",\n      d = \"numeric\",\n      e = \"logical\",\n      f = \"character\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\",\n    lang = \"pl\",\n    locale = \"pl\"\n  ) %>%\n  # Spodziewaj się, że kolumna `a` jest typu: integer\n  col_is_integer(\n    columns = vars(a)\n  ) %>%\n  # Spodziewaj się, że wartości w `a` powinny zawierac się między `1` a `8`\n  col_vals_between(\n    columns = vars(a),\n    left = 1,\n    right = 8\n  ) %>%\n  # Spodziewaj się, że kolumna `b` jest typu: character\n  col_is_character(\n    columns = vars(b)\n  ) %>%\n  # Spodziewaj się, że kolumna `c` jest typu: numeric\n  col_is_numeric(\n    columns = vars(c)\n  ) %>%\n  # Spodziewaj się, że wartości w `c` powinny zawierac się między `2` a `9`\n  col_vals_between(\n    columns = vars(c),\n    left = 2,\n    right = 9,\n    na_pass = TRUE\n  ) %>%\n  # Spodziewaj się, że kolumna `d` jest typu: numeric\n  col_is_numeric(\n    columns = vars(d)\n  ) %>%\n  # Spodziewaj się, że wartości w `d` powinny zawierac się między `108.34` a `9999.99`\n  col_vals_between(\n    columns = vars(d),\n    left = 108.34,\n    right = 9999.99\n  ) %>%\n  # Spodziewaj się, że kolumna `e` jest typu: logical\n  col_is_logical(\n    columns = vars(e)\n  ) %>%\n  # Spodziewaj się, że kolumna `f` jest typu: character\n  col_is_character(\n    columns = vars(f)\n  ) %>%\n  # Spodziewaj się, że schematy kolumn będa zgodne\n  col_schema_match(\n    schema = col_schema(\n      date_time = c(\"POSIXct\", \"POSIXt\"),\n      date = \"Date\",\n      a = \"integer\",\n      b = \"character\",\n      c = \"numeric\",\n      d = \"numeric\",\n      e = \"logical\",\n      f = \"character\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\",\n    lang = \"da\",\n    locale = \"da\"\n  ) %>%\n  # Forvent at kolonne `a` er af typen: integer\n  col_is_integer(\n    columns = vars(a)\n  ) %>%\n  # Forvent at værdierne i `a` skal være imellem `1` og `8`\n  col_vals_between(\n    columns = vars(a),\n    left = 1,\n    right = 8\n  ) %>%\n  # Forvent at kolonne `b` er af typen: character\n  col_is_character(\n    columns = vars(b)\n  ) %>%\n  # Forvent at kolonne `c` er af typen: numeric\n  col_is_numeric(\n    columns = vars(c)\n  ) %>%\n  # Forvent at værdierne i `c` skal være imellem `2` og `9`\n  col_vals_between(\n    columns = vars(c),\n    left = 2,\n    right = 9,\n    na_pass = TRUE\n  ) %>%\n  # Forvent at kolonne `d` er af typen: numeric\n  col_is_numeric(\n    columns = vars(d)\n  ) %>%\n  # Forvent at værdierne i `d` skal være imellem `108.34` og `9999.99`\n  col_vals_between(\n    columns = vars(d),\n    left = 108.34,\n    right = 9999.99\n  ) %>%\n  # Forvent at kolonne `e` er af typen: logical\n  col_is_logical(\n    columns = vars(e)\n  ) %>%\n  # Forvent at kolonne `f` er af typen: character\n  col_is_character(\n    columns = vars(f)\n  ) %>%\n  # Forvent overensstemmelse med kolonne schema\n  col_schema_match(\n    schema = col_schema(\n      date_time = c(\"POSIXct\", \"POSIXt\"),\n      date = \"Date\",\n      a = \"integer\",\n      b = \"character\",\n      c = \"numeric\",\n      d = \"numeric\",\n      e = \"logical\",\n      f = \"character\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\",\n    lang = \"sv\",\n    locale = \"sv\"\n  ) %>%\n  # Förvänta dig att kolumn `a` är av typen: integer\n  col_is_integer(\n    columns = vars(a)\n  ) %>%\n  # Förvänta dig att värdena i `a` ligger mellan `1` och `8`\n  col_vals_between(\n    columns = vars(a),\n    left = 1,\n    right = 8\n  ) %>%\n  # Förvänta dig att kolumn `b` är av typen: character\n  col_is_character(\n    columns = vars(b)\n  ) %>%\n  # Förvänta dig att kolumn `c` är av typen: numeric\n  col_is_numeric(\n    columns = vars(c)\n  ) %>%\n  # Förvänta dig att värdena i `c` ligger mellan `2` och `9`\n  col_vals_between(\n    columns = vars(c),\n    left = 2,\n    right = 9,\n    na_pass = TRUE\n  ) %>%\n  # Förvänta dig att kolumn `d` är av typen: numeric\n  col_is_numeric(\n    columns = vars(d)\n  ) %>%\n  # Förvänta dig att värdena i `d` ligger mellan `108.34` och `9999.99`\n  col_vals_between(\n    columns = vars(d),\n    left = 108.34,\n    right = 9999.99\n  ) %>%\n  # Förvänta dig att kolumn `e` är av typen: logical\n  col_is_logical(\n    columns = vars(e)\n  ) %>%\n  # Förvänta dig att kolumn `f` är av typen: character\n  col_is_character(\n    columns = vars(f)\n  ) %>%\n  # Förvänta överensstämmelse med kolumn schema\n  col_schema_match(\n    schema = col_schema(\n      date_time = c(\"POSIXct\", \"POSIXt\"),\n      date = \"Date\",\n      a = \"integer\",\n      b = \"character\",\n      c = \"numeric\",\n      d = \"numeric\",\n      e = \"logical\",\n      f = \"character\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\",\n    lang = \"nl\",\n    locale = \"nl\"\n  ) %>%\n  # Verwacht dat de kolom `a` van het type integer is\n  col_is_integer(\n    columns = vars(a)\n  ) %>%\n  # Verwacht dat de waarden in `a` tussen `1` en `8` moeten liggen\n  col_vals_between(\n    columns = vars(a),\n    left = 1,\n    right = 8\n  ) %>%\n  # Verwacht dat de kolom `b` van het type character is\n  col_is_character(\n    columns = vars(b)\n  ) %>%\n  # Verwacht dat de kolom `c` van het type numeric is\n  col_is_numeric(\n    columns = vars(c)\n  ) %>%\n  # Verwacht dat de waarden in `c` tussen `2` en `9` moeten liggen\n  col_vals_between(\n    columns = vars(c),\n    left = 2,\n    right = 9,\n    na_pass = TRUE\n  ) %>%\n  # Verwacht dat de kolom `d` van het type numeric is\n  col_is_numeric(\n    columns = vars(d)\n  ) %>%\n  # Verwacht dat de waarden in `d` tussen `108.34` en `9999.99` moeten liggen\n  col_vals_between(\n    columns = vars(d),\n    left = 108.34,\n    right = 9999.99\n  ) %>%\n  # Verwacht dat de kolom `e` van het type logical is\n  col_is_logical(\n    columns = vars(e)\n  ) %>%\n  # Verwacht dat de kolom `f` van het type character is\n  col_is_character(\n    columns = vars(f)\n  ) %>%\n  # Verwacht dat de kolomschema's overeenkomen\n  col_schema_match(\n    schema = col_schema(\n      date_time = c(\"POSIXct\", \"POSIXt\"),\n      date = \"Date\",\n      a = \"integer\",\n      b = \"character\",\n      c = \"numeric\",\n      d = \"numeric\",\n      e = \"logical\",\n      f = \"character\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

# draft validations for data tables can be generated in .Rmd format

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "---\ntitle: \"tbl\"\noutput: html_document\n---\n\n```{r setup, include=FALSE}\nknitr::opts_chunk$set(echo = TRUE)\nlibrary(pointblank)\n```\n\n\n```{r create_agent, echo=TRUE}\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `country_name` is of type: character\n  col_is_character(\n    columns = vars(country_name)\n  ) %>%\n  # Expect that values in `country_name` should be in the set of `Aruba`, `Afghanistan`, `Angola` (and 212 more)\n  col_vals_in_set(\n    columns = vars(country_name),\n    set = c(\"Aruba\", \"Afghanistan\", \"Angola\", \"Albania\", \"Andorra\", \"United Arab Emirates\", \"Argentina\", \"Armenia\", \"American Samoa\", \"Antigua and Barbuda\", \"Australia\", \"Austria\", \"Azerbaijan\", \"Burundi\", \"Belgium\", \"Benin\", \"Burkina Faso\", \"Bangladesh\", \"Bulgaria\", \"Bahrain\", \"Bahamas\", \"Bosnia and Herzegovina\", \"Belarus\", \"Belize\", \"Bermuda\", \"Bolivia\", \"Brazil\", \"Barbados\", \"Brunei Darussalam\", \"Bhutan\", \"Botswana\", \"Central African Republic\", \"Canada\", \"Switzerland\", \"Chile\", \"China\", \"Cote d'Ivoire\", \"Cameroon\", \"Congo (Democratic Republic)\", \"Congo\", \"Colombia\", \"Comoros\", \"Cabo Verde\", \"Costa Rica\", \"Cuba\", \"Curacao\", \"Cayman Islands\", \"Cyprus\", \"Czech Republic\", \"Germany\", \"Djibouti\", \"Dominica\", \"Denmark\", \"Dominican Republic\", \"Algeria\", \"Ecuador\", \"Egypt\", \"Eritrea\", \"Spain\", \"Estonia\", \"Ethiopia\", \"Finland\", \"Fiji\", \"France\", \"Faroe Islands\", \"Micronesia (Federated States)\", \"Gabon\", \"United Kingdom\", \"Georgia\", \"Ghana\", \"Gibraltar\", \"Guinea\", \"Gambia, The\", \"Guinea-Bissau\", \"Equatorial Guinea\", \"Greece\", \"Grenada\", \"Greenland\", \"Guatemala\", \"Guam\", \"Guyana\", \"Hong Kong\", \"Honduras\", \"Croatia\", \"Haiti\", \"Hungary\", \"Indonesia\", \"Isle of Man\", \"India\", \"Ireland\", \"Iran (Islamic Republic)\", \"Iraq\", \"Iceland\", \"Israel\", \"Italy\", \"Jamaica\", \"Jordan\", \"Japan\", \"Kazakhstan\", \"Kenya\", \"Kyrgyzstan\", \"Cambodia\", \"Kiribati\", \"St. Kitts and Nevis\", \"Korea (Republic of)\", \"Kuwait\", \"Lao (People’s Democratic Republic)\", \"Lebanon\", \"Liberia\", \"Libya\", \"Saint Lucia\", \"Liechtenstein\", \"Sri Lanka\", \"Lesotho\", \"Lithuania\", \"Luxembourg\", \"Latvia\", \"Macao\", \"Saint Martin (French part)\", \"Morocco\", \"Monaco\", \"Moldova (Republic of)\", \"Madagascar\", \"Maldives\", \"Mexico\", \"Marshall Islands\", \"Macedonia (FYR)\", \"Mali\", \"Malta\", \"Myanmar\", \"Montenegro\", \"Mongolia\", \"Northern Mariana Islands\", \"Mozambique\", \"Mauritania\", \"Mauritius\", \"Malawi\", \"Malaysia\", \"Namibia\", \"New Caledonia\", \"Niger\", \"Nigeria\", \"Nicaragua\", \"Netherlands\", \"Norway\", \"Nepal\", \"Nauru\", \"New Zealand\", \"Oman\", \"Pakistan\", \"Panama\", \"Peru\", \"Philippines\", \"Palau\", \"Papua New Guinea\", \"Poland\", \"Puerto Rico\", \"Korea (Dem. People’s Rep.)\", \"Portugal\", \"Paraguay\", \"Palestine (State of)\", \"French Polynesia\", \"Qatar\", \"Romania\", \"Russian Federation\", \"Rwanda\", \"Saudi Arabia\", \"Sudan\", \"Senegal\", \"Singapore\", \"Solomon Islands\", \"Sierra Leone\", \"El Salvador\", \"San Marino\", \"Somalia\", \"Serbia\", \"South Sudan\", \"Sao Tome and Principe\", \"Suriname\", \"Slovak Republic\", \"Slovenia\", \"Sweden\", \"Eswatini\", \"Sint Maarten (Dutch part)\", \"Seychelles\", \"Syrian Arab Republic\", \"Turks and Caicos Islands\", \"Chad\", \"Togo\", \"Thailand\", \"Tajikistan\", \"Turkmenistan\", \"Timor-Leste\", \"Tonga\", \"Trinidad and Tobago\", \"Tunisia\", \"Turkey\", \"Tuvalu\", \"Tanzania\", \"Uganda\", \"Ukraine\", \"Uruguay\", \"United States\", \"Uzbekistan\", \"St. Vincent and the Grenadines\", \"Venezuela (Bolivarian Republic of)\", \"Virgin Islands (British)\", \"Virgin Islands (U.S.)\", \"Vietnam\", \"Vanuatu\", \"Samoa\", \"Yemen\", \"South Africa\", \"Zambia\", \"Zimbabwe\")\n  ) %>%\n  # Expect that column `country_code_2` is of type: character\n  col_is_character(\n    columns = vars(country_code_2)\n  ) %>%\n  # Expect that values in `country_code_2` should be in the set of `AD`, `AE`, `AF` (and 246 more)\n  col_vals_in_set(\n    columns = vars(country_code_2),\n    set = c(\"AD\", \"AE\", \"AF\", \"AG\", \"AI\", \"AL\", \"AM\", \"AO\", \"AQ\", \"AR\", \"AS\", \"AT\", \"AU\", \"AW\", \"AX\", \"AZ\", \"BA\", \"BB\", \"BD\", \"BE\", \"BF\", \"BG\", \"BH\", \"BI\", \"BJ\", \"BL\", \"BM\", \"BN\", \"BO\", \"BQ\", \"BR\", \"BS\", \"BT\", \"BV\", \"BW\", \"BY\", \"BZ\", \"CA\", \"CC\", \"CD\", \"CF\", \"CG\", \"CH\", \"CI\", \"CK\", \"CL\", \"CM\", \"CN\", \"CO\", \"CR\", \"CU\", \"CV\", \"CW\", \"CX\", \"CY\", \"CZ\", \"DE\", \"DJ\", \"DK\", \"DM\", \"DO\", \"DZ\", \"EC\", \"EE\", \"EG\", \"EH\", \"ER\", \"ES\", \"ET\", \"FI\", \"FJ\", \"FK\", \"FM\", \"FO\", \"FR\", \"GA\", \"GB\", \"GD\", \"GE\", \"GF\", \"GG\", \"GH\", \"GI\", \"GL\", \"GM\", \"GN\", \"GP\", \"GQ\", \"GR\", \"GS\", \"GT\", \"GU\", \"GW\", \"GY\", \"HK\", \"HM\", \"HN\", \"HR\", \"HT\", \"HU\", \"ID\", \"IE\", \"IL\", \"IM\", \"IN\", \"IO\", \"IQ\", \"IR\", \"IS\", \"IT\", \"JE\", \"JM\", \"JO\", \"JP\", \"KE\", \"KG\", \"KH\", \"KI\", \"KM\", \"KN\", \"KP\", \"KR\", \"KW\", \"KY\", \"KZ\", \"LA\", \"LB\", \"LC\", \"LI\", \"LK\", \"LR\", \"LS\", \"LT\", \"LU\", \"LV\", \"LY\", \"MA\", \"MC\", \"MD\", \"ME\", \"MF\", \"MG\", \"MH\", \"MK\", \"ML\", \"MM\", \"MN\", \"MO\", \"MP\", \"MQ\", \"MR\", \"MS\", \"MT\", \"MU\", \"MV\", \"MW\", \"MX\", \"MY\", \"MZ\", \"NA\", \"NC\", \"NE\", \"NF\", \"NG\", \"NI\", \"NL\", \"NO\", \"NP\", \"NR\", \"NU\", \"NZ\", \"OM\", \"PA\", \"PE\", \"PF\", \"PG\", \"PH\", \"PK\", \"PL\", \"PM\", \"PN\", \"PR\", \"PS\", \"PT\", \"PW\", \"PY\", \"QA\", \"RE\", \"RO\", \"RS\", \"RU\", \"RW\", \"SA\", \"SB\", \"SC\", \"SD\", \"SE\", \"SG\", \"SH\", \"SI\", \"SJ\", \"SK\", \"SL\", \"SM\", \"SN\", \"SO\", \"SR\", \"SS\", \"ST\", \"SV\", \"SX\", \"SY\", \"SZ\", \"TC\", \"TD\", \"TF\", \"TG\", \"TH\", \"TJ\", \"TK\", \"TL\", \"TM\", \"TN\", \"TO\", \"TR\", \"TT\", \"TV\", \"TW\", \"TZ\", \"UA\", \"UG\", \"UM\", \"US\", \"UY\", \"UZ\", \"VA\", \"VC\", \"VE\", \"VG\", \"VI\", \"VN\", \"VU\", \"WF\", \"WS\", \"YE\", \"YT\", \"ZA\", \"ZM\", \"ZW\")\n  ) %>%\n  # Expect that column `country_code_3` is of type: character\n  col_is_character(\n    columns = vars(country_code_3)\n  ) %>%\n  # Expect that values in `country_code_3` should be in the set of `AND`, `ARE`, `AFG` (and 246 more)\n  col_vals_in_set(\n    columns = vars(country_code_3),\n    set = c(\"AND\", \"ARE\", \"AFG\", \"ATG\", \"AIA\", \"ALB\", \"ARM\", \"AGO\", \"ATA\", \"ARG\", \"ASM\", \"AUT\", \"AUS\", \"ABW\", \"ALA\", \"AZE\", \"BIH\", \"BRB\", \"BGD\", \"BEL\", \"BFA\", \"BGR\", \"BHR\", \"BDI\", \"BEN\", \"BLM\", \"BMU\", \"BRN\", \"BOL\", \"BES\", \"BRA\", \"BHS\", \"BTN\", \"BVT\", \"BWA\", \"BLR\", \"BLZ\", \"CAN\", \"CCK\", \"COD\", \"CAF\", \"COG\", \"CHE\", \"CIV\", \"COK\", \"CHL\", \"CMR\", \"CHN\", \"COL\", \"CRI\", \"CUB\", \"CPV\", \"CUW\", \"CXR\", \"CYP\", \"CZE\", \"DEU\", \"DJI\", \"DNK\", \"DMA\", \"DOM\", \"DZA\", \"ECU\", \"EST\", \"EGY\", \"ESH\", \"ERI\", \"ESP\", \"ETH\", \"FIN\", \"FJI\", \"FLK\", \"FSM\", \"FRO\", \"FRA\", \"GAB\", \"GBR\", \"GRD\", \"GEO\", \"GUF\", \"GGY\", \"GHA\", \"GIB\", \"GRL\", \"GMB\", \"GIN\", \"GLP\", \"GNQ\", \"GRC\", \"SGS\", \"GTM\", \"GUM\", \"GNB\", \"GUY\", \"HKG\", \"HMD\", \"HND\", \"HRV\", \"HTI\", \"HUN\", \"IDN\", \"IRL\", \"ISR\", \"IMN\", \"IND\", \"IOT\", \"IRQ\", \"IRN\", \"ISL\", \"ITA\", \"JEY\", \"JAM\", \"JOR\", \"JPN\", \"KEN\", \"KGZ\", \"KHM\", \"KIR\", \"COM\", \"KNA\", \"PRK\", \"KOR\", \"KWT\", \"CYM\", \"KAZ\", \"LAO\", \"LBN\", \"LCA\", \"LIE\", \"LKA\", \"LBR\", \"LSO\", \"LTU\", \"LUX\", \"LVA\", \"LBY\", \"MAR\", \"MCO\", \"MDA\", \"MNE\", \"MAF\", \"MDG\", \"MHL\", \"MKD\", \"MLI\", \"MMR\", \"MNG\", \"MAC\", \"MNP\", \"MTQ\", \"MRT\", \"MSR\", \"MLT\", \"MUS\", \"MDV\", \"MWI\", \"MEX\", \"MYS\", \"MOZ\", \"NAM\", \"NCL\", \"NER\", \"NFK\", \"NGA\", \"NIC\", \"NLD\", \"NOR\", \"NPL\", \"NRU\", \"NIU\", \"NZL\", \"OMN\", \"PAN\", \"PER\", \"PYF\", \"PNG\", \"PHL\", \"PAK\", \"POL\", \"SPM\", \"PCN\", \"PRI\", \"PSE\", \"PRT\", \"PLW\", \"PRY\", \"QAT\", \"REU\", \"ROU\", \"SRB\", \"RUS\", \"RWA\", \"SAU\", \"SLB\", \"SYC\", \"SDN\", \"SWE\", \"SGP\", \"SHN\", \"SVN\", \"SJM\", \"SVK\", \"SLE\", \"SMR\", \"SEN\", \"SOM\", \"SUR\", \"SSD\", \"STP\", \"SLV\", \"SXM\", \"SYR\", \"SWZ\", \"TCA\", \"TCD\", \"ATF\", \"TGO\", \"THA\", \"TJK\", \"TKL\", \"TLS\", \"TKM\", \"TUN\", \"TON\", \"TUR\", \"TTO\", \"TUV\", \"TWN\", \"TZA\", \"UKR\", \"UGA\", \"UMI\", \"USA\", \"URY\", \"UZB\", \"VAT\", \"VCT\", \"VEN\", \"VGB\", \"VIR\", \"VNM\", \"VUT\", \"WLF\", \"WSM\", \"YEM\", \"MYT\", \"ZAF\", \"ZMB\", \"ZWE\")\n  ) %>%\n  # Expect that column `year` is of type: integer\n  col_is_integer(\n    columns = vars(year)\n  ) %>%\n  # Expect that values in `year` should be between `1960` and `2017`\n  col_vals_between(\n    columns = vars(year),\n    left = 1960,\n    right = 2017\n  ) %>%\n  # Expect that column `population` is of type: integer\n  col_is_integer(\n    columns = vars(population)\n  ) %>%\n  # Expect that values in `population` should be between `4279` and `1386395000`\n  col_vals_between(\n    columns = vars(population),\n    left = 4279,\n    right = 1386395000,\n    na_pass = TRUE\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      country_name = \"character\",\n      country_code_2 = \"character\",\n      country_code_3 = \"character\",\n      year = \"integer\",\n      population = \"integer\"\n    )\n  ) %>%\n  interrogate()\n```\n\n\n```{r print_agent, echo=FALSE}\nagent\n```\n"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "---\ntitle: \"tbl\"\noutput: html_document\n---\n\n```{r setup, include=FALSE}\nknitr::opts_chunk$set(echo = TRUE)\nlibrary(pointblank)\n```\n\n\n```{r create_agent, echo=TRUE}\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `latitude` is of type: numeric\n  col_is_numeric(\n    columns = vars(latitude)\n  ) %>%\n  # Expect that values in `latitude` should be between `-90` and `90`\n  col_vals_between(\n    columns = vars(latitude),\n    left = -90,\n    right = 90\n  ) %>%\n  # Expect that column `month` is of type: factor\n  col_is_factor(\n    columns = vars(month)\n  ) %>%\n  # Expect that column `tst` is of type: character\n  col_is_character(\n    columns = vars(tst)\n  ) %>%\n  # Expect that column `sza` is of type: numeric\n  col_is_numeric(\n    columns = vars(sza)\n  ) %>%\n  # Expect that values in `sza` should be between `1.9` and `89.7`\n  col_vals_between(\n    columns = vars(sza),\n    left = 1.9,\n    right = 89.7,\n    na_pass = TRUE\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      latitude = \"numeric\",\n      month = \"factor\",\n      tst = \"character\",\n      sza = \"numeric\"\n    )\n  ) %>%\n  interrogate()\n```\n\n\n```{r print_agent, echo=FALSE}\nagent\n```\n"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "---\ntitle: \"tbl\"\noutput: html_document\n---\n\n```{r setup, include=FALSE}\nknitr::opts_chunk$set(echo = TRUE)\nlibrary(pointblank)\n```\n\n\n```{r create_agent, echo=TRUE}\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `mfr` is of type: character\n  col_is_character(\n    columns = vars(mfr)\n  ) %>%\n  # Expect that column `model` is of type: character\n  col_is_character(\n    columns = vars(model)\n  ) %>%\n  # Expect that column `year` is of type: numeric\n  col_is_numeric(\n    columns = vars(year)\n  ) %>%\n  # Expect that values in `year` should be between `2014` and `2017`\n  col_vals_between(\n    columns = vars(year),\n    left = 2014,\n    right = 2017\n  ) %>%\n  # Expect that column `trim` is of type: character\n  col_is_character(\n    columns = vars(trim)\n  ) %>%\n  # Expect that column `bdy_style` is of type: character\n  col_is_character(\n    columns = vars(bdy_style)\n  ) %>%\n  # Expect that column `hp` is of type: numeric\n  col_is_numeric(\n    columns = vars(hp)\n  ) %>%\n  # Expect that values in `hp` should be between `259` and `949`\n  col_vals_between(\n    columns = vars(hp),\n    left = 259,\n    right = 949\n  ) %>%\n  # Expect that column `hp_rpm` is of type: numeric\n  col_is_numeric(\n    columns = vars(hp_rpm)\n  ) %>%\n  # Expect that values in `hp_rpm` should be between `5000` and `9000`\n  col_vals_between(\n    columns = vars(hp_rpm),\n    left = 5000,\n    right = 9000\n  ) %>%\n  # Expect that column `trq` is of type: numeric\n  col_is_numeric(\n    columns = vars(trq)\n  ) %>%\n  # Expect that values in `trq` should be between `243` and `664`\n  col_vals_between(\n    columns = vars(trq),\n    left = 243,\n    right = 664\n  ) %>%\n  # Expect that column `trq_rpm` is of type: numeric\n  col_is_numeric(\n    columns = vars(trq_rpm)\n  ) %>%\n  # Expect that values in `trq_rpm` should be between `1400` and `6750`\n  col_vals_between(\n    columns = vars(trq_rpm),\n    left = 1400,\n    right = 6750,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `mpg_c` is of type: numeric\n  col_is_numeric(\n    columns = vars(mpg_c)\n  ) %>%\n  # Expect that values in `mpg_c` should be between `11` and `28`\n  col_vals_between(\n    columns = vars(mpg_c),\n    left = 11,\n    right = 28,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `mpg_h` is of type: numeric\n  col_is_numeric(\n    columns = vars(mpg_h)\n  ) %>%\n  # Expect that values in `mpg_h` should be between `16` and `30`\n  col_vals_between(\n    columns = vars(mpg_h),\n    left = 16,\n    right = 30,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `drivetrain` is of type: character\n  col_is_character(\n    columns = vars(drivetrain)\n  ) %>%\n  # Expect that column `trsmn` is of type: character\n  col_is_character(\n    columns = vars(trsmn)\n  ) %>%\n  # Expect that column `ctry_origin` is of type: character\n  col_is_character(\n    columns = vars(ctry_origin)\n  ) %>%\n  # Expect that values in `ctry_origin` should be in the set of `United States`, `Italy`, `Japan` (and 2 more)\n  col_vals_in_set(\n    columns = vars(ctry_origin),\n    set = c(\"United States\", \"Italy\", \"Japan\", \"United Kingdom\", \"Germany\")\n  ) %>%\n  # Expect that column `msrp` is of type: numeric\n  col_is_numeric(\n    columns = vars(msrp)\n  ) %>%\n  # Expect that values in `msrp` should be between `53900` and `1416362`\n  col_vals_between(\n    columns = vars(msrp),\n    left = 53900,\n    right = 1416362\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      mfr = \"character\",\n      model = \"character\",\n      year = \"numeric\",\n      trim = \"character\",\n      bdy_style = \"character\",\n      hp = \"numeric\",\n      hp_rpm = \"numeric\",\n      trq = \"numeric\",\n      trq_rpm = \"numeric\",\n      mpg_c = \"numeric\",\n      mpg_h = \"numeric\",\n      drivetrain = \"character\",\n      trsmn = \"character\",\n      ctry_origin = \"character\",\n      msrp = \"numeric\"\n    )\n  ) %>%\n  interrogate()\n```\n\n\n```{r print_agent, echo=FALSE}\nagent\n```\n"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "---\ntitle: \"tbl\"\noutput: html_document\n---\n\n```{r setup, include=FALSE}\nknitr::opts_chunk$set(echo = TRUE)\nlibrary(pointblank)\n```\n\n\n```{r create_agent, echo=TRUE}\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `open` is of type: numeric\n  col_is_numeric(\n    columns = vars(open)\n  ) %>%\n  # Expect that values in `open` should be between `16.66` and `2130.3601`\n  col_vals_between(\n    columns = vars(open),\n    left = 16.66,\n    right = 2130.3601\n  ) %>%\n  # Expect that column `high` is of type: numeric\n  col_is_numeric(\n    columns = vars(high)\n  ) %>%\n  # Expect that values in `high` should be between `16.66` and `2134.72`\n  col_vals_between(\n    columns = vars(high),\n    left = 16.66,\n    right = 2134.72\n  ) %>%\n  # Expect that column `low` is of type: numeric\n  col_is_numeric(\n    columns = vars(low)\n  ) %>%\n  # Expect that values in `low` should be between `16.66` and `2126.0601`\n  col_vals_between(\n    columns = vars(low),\n    left = 16.66,\n    right = 2126.0601\n  ) %>%\n  # Expect that column `close` is of type: numeric\n  col_is_numeric(\n    columns = vars(close)\n  ) %>%\n  # Expect that values in `close` should be between `16.66` and `2130.8201`\n  col_vals_between(\n    columns = vars(close),\n    left = 16.66,\n    right = 2130.8201\n  ) %>%\n  # Expect that column `volume` is of type: numeric\n  col_is_numeric(\n    columns = vars(volume)\n  ) %>%\n  # Expect that values in `volume` should be between `680000` and `11456230400`\n  col_vals_between(\n    columns = vars(volume),\n    left = 680000,\n    right = 11456230000\n  ) %>%\n  # Expect that column `adj_close` is of type: numeric\n  col_is_numeric(\n    columns = vars(adj_close)\n  ) %>%\n  # Expect that values in `adj_close` should be between `16.66` and `2130.8201`\n  col_vals_between(\n    columns = vars(adj_close),\n    left = 16.66,\n    right = 2130.8201\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      date = \"Date\",\n      open = \"numeric\",\n      high = \"numeric\",\n      low = \"numeric\",\n      close = \"numeric\",\n      volume = \"numeric\",\n      adj_close = \"numeric\"\n    )\n  ) %>%\n  interrogate()\n```\n\n\n```{r print_agent, echo=FALSE}\nagent\n```\n"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "---\ntitle: \"tbl\"\noutput: html_document\n---\n\n```{r setup, include=FALSE}\nknitr::opts_chunk$set(echo = TRUE)\nlibrary(pointblank)\n```\n\n\n```{r create_agent, echo=TRUE}\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `id` is of type: character\n  col_is_character(\n    columns = vars(id)\n  ) %>%\n  # Expect that column `date` is of type: character\n  col_is_character(\n    columns = vars(date)\n  ) %>%\n  # Expect that column `time` is of type: character\n  col_is_character(\n    columns = vars(time)\n  ) %>%\n  # Expect that column `name` is of type: character\n  col_is_character(\n    columns = vars(name)\n  ) %>%\n  # Expect that column `size` is of type: character\n  col_is_character(\n    columns = vars(size)\n  ) %>%\n  # Expect that column `type` is of type: character\n  col_is_character(\n    columns = vars(type)\n  ) %>%\n  # Expect that column `price` is of type: numeric\n  col_is_numeric(\n    columns = vars(price)\n  ) %>%\n  # Expect that values in `price` should be between `9.75` and `35.95`\n  col_vals_between(\n    columns = vars(price),\n    left = 9.75,\n    right = 35.95\n  ) %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      id = \"character\",\n      date = \"character\",\n      time = \"character\",\n      name = \"character\",\n      size = \"character\",\n      type = \"character\",\n      price = \"numeric\"\n    )\n  ) %>%\n  interrogate()\n```\n\n\n```{r print_agent, echo=FALSE}\nagent\n```\n"

---

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "---\ntitle: \"tbl\"\noutput: html_document\n---\n\n```{r setup, include=FALSE}\nknitr::opts_chunk$set(echo = TRUE)\nlibrary(pointblank)\n```\n\n\n```{r create_agent, echo=TRUE}\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  # Expect that column `num` is of type: numeric\n  col_is_numeric(\n    columns = vars(num)\n  ) %>%\n  # Expect that values in `num` should be between `0.1111` and `8880000`\n  col_vals_between(\n    columns = vars(num),\n    left = 0.1111,\n    right = 8880000,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `char` is of type: character\n  col_is_character(\n    columns = vars(char)\n  ) %>%\n  # Expect that column `fctr` is of type: factor\n  col_is_factor(\n    columns = vars(fctr)\n  ) %>%\n  # Expect that column `date` is of type: character\n  col_is_character(\n    columns = vars(date)\n  ) %>%\n  # Expect that column `time` is of type: character\n  col_is_character(\n    columns = vars(time)\n  ) %>%\n  # Expect that column `datetime` is of type: character\n  col_is_character(\n    columns = vars(datetime)\n  ) %>%\n  # Expect that column `currency` is of type: numeric\n  col_is_numeric(\n    columns = vars(currency)\n  ) %>%\n  # Expect that values in `currency` should be between `0.44` and `65100`\n  col_vals_between(\n    columns = vars(currency),\n    left = 0.44,\n    right = 65100,\n    na_pass = TRUE\n  ) %>%\n  # Expect that column `row` is of type: character\n  col_is_character(\n    columns = vars(row)\n  ) %>%\n  # Expect that column `group` is of type: character\n  col_is_character(\n    columns = vars(group)\n  ) %>%\n  # Expect entirely distinct rows across all columns\n  rows_distinct() %>%\n  # Expect that column schemas match\n  col_schema_match(\n    schema = col_schema(\n      num = \"numeric\",\n      char = \"character\",\n      fctr = \"factor\",\n      date = \"character\",\n      time = \"character\",\n      datetime = \"character\",\n      currency = \"numeric\",\n      row = \"character\",\n      group = \"character\"\n    )\n  ) %>%\n  interrogate()\n```\n\n\n```{r print_agent, echo=FALSE}\nagent\n```\n"

# draft validations for data tables can be generated without comments

    Code
      readLines(con = path) %>% paste0(collapse = "\n")
    Output
      [1] "library(pointblank)\n\nagent <-\n  create_agent(\n    tbl = ~ tbl,\n    actions = action_levels(\n      warn_at = 0.05,\n      stop_at = 0.10\n    ),\n    tbl_name = \"tbl\",\n    label = \"Validation plan generated by `draft_validation()`.\"\n  ) %>%\n  col_is_character(\n    columns = vars(country_name)\n  ) %>%\n  col_vals_in_set(\n    columns = vars(country_name),\n    set = c(\"Aruba\", \"Afghanistan\", \"Angola\", \"Albania\", \"Andorra\", \"United Arab Emirates\", \"Argentina\", \"Armenia\", \"American Samoa\", \"Antigua and Barbuda\", \"Australia\", \"Austria\", \"Azerbaijan\", \"Burundi\", \"Belgium\", \"Benin\", \"Burkina Faso\", \"Bangladesh\", \"Bulgaria\", \"Bahrain\", \"Bahamas\", \"Bosnia and Herzegovina\", \"Belarus\", \"Belize\", \"Bermuda\", \"Bolivia\", \"Brazil\", \"Barbados\", \"Brunei Darussalam\", \"Bhutan\", \"Botswana\", \"Central African Republic\", \"Canada\", \"Switzerland\", \"Chile\", \"China\", \"Cote d'Ivoire\", \"Cameroon\", \"Congo (Democratic Republic)\", \"Congo\", \"Colombia\", \"Comoros\", \"Cabo Verde\", \"Costa Rica\", \"Cuba\", \"Curacao\", \"Cayman Islands\", \"Cyprus\", \"Czech Republic\", \"Germany\", \"Djibouti\", \"Dominica\", \"Denmark\", \"Dominican Republic\", \"Algeria\", \"Ecuador\", \"Egypt\", \"Eritrea\", \"Spain\", \"Estonia\", \"Ethiopia\", \"Finland\", \"Fiji\", \"France\", \"Faroe Islands\", \"Micronesia (Federated States)\", \"Gabon\", \"United Kingdom\", \"Georgia\", \"Ghana\", \"Gibraltar\", \"Guinea\", \"Gambia, The\", \"Guinea-Bissau\", \"Equatorial Guinea\", \"Greece\", \"Grenada\", \"Greenland\", \"Guatemala\", \"Guam\", \"Guyana\", \"Hong Kong\", \"Honduras\", \"Croatia\", \"Haiti\", \"Hungary\", \"Indonesia\", \"Isle of Man\", \"India\", \"Ireland\", \"Iran (Islamic Republic)\", \"Iraq\", \"Iceland\", \"Israel\", \"Italy\", \"Jamaica\", \"Jordan\", \"Japan\", \"Kazakhstan\", \"Kenya\", \"Kyrgyzstan\", \"Cambodia\", \"Kiribati\", \"St. Kitts and Nevis\", \"Korea (Republic of)\", \"Kuwait\", \"Lao (People’s Democratic Republic)\", \"Lebanon\", \"Liberia\", \"Libya\", \"Saint Lucia\", \"Liechtenstein\", \"Sri Lanka\", \"Lesotho\", \"Lithuania\", \"Luxembourg\", \"Latvia\", \"Macao\", \"Saint Martin (French part)\", \"Morocco\", \"Monaco\", \"Moldova (Republic of)\", \"Madagascar\", \"Maldives\", \"Mexico\", \"Marshall Islands\", \"Macedonia (FYR)\", \"Mali\", \"Malta\", \"Myanmar\", \"Montenegro\", \"Mongolia\", \"Northern Mariana Islands\", \"Mozambique\", \"Mauritania\", \"Mauritius\", \"Malawi\", \"Malaysia\", \"Namibia\", \"New Caledonia\", \"Niger\", \"Nigeria\", \"Nicaragua\", \"Netherlands\", \"Norway\", \"Nepal\", \"Nauru\", \"New Zealand\", \"Oman\", \"Pakistan\", \"Panama\", \"Peru\", \"Philippines\", \"Palau\", \"Papua New Guinea\", \"Poland\", \"Puerto Rico\", \"Korea (Dem. People’s Rep.)\", \"Portugal\", \"Paraguay\", \"Palestine (State of)\", \"French Polynesia\", \"Qatar\", \"Romania\", \"Russian Federation\", \"Rwanda\", \"Saudi Arabia\", \"Sudan\", \"Senegal\", \"Singapore\", \"Solomon Islands\", \"Sierra Leone\", \"El Salvador\", \"San Marino\", \"Somalia\", \"Serbia\", \"South Sudan\", \"Sao Tome and Principe\", \"Suriname\", \"Slovak Republic\", \"Slovenia\", \"Sweden\", \"Eswatini\", \"Sint Maarten (Dutch part)\", \"Seychelles\", \"Syrian Arab Republic\", \"Turks and Caicos Islands\", \"Chad\", \"Togo\", \"Thailand\", \"Tajikistan\", \"Turkmenistan\", \"Timor-Leste\", \"Tonga\", \"Trinidad and Tobago\", \"Tunisia\", \"Turkey\", \"Tuvalu\", \"Tanzania\", \"Uganda\", \"Ukraine\", \"Uruguay\", \"United States\", \"Uzbekistan\", \"St. Vincent and the Grenadines\", \"Venezuela (Bolivarian Republic of)\", \"Virgin Islands (British)\", \"Virgin Islands (U.S.)\", \"Vietnam\", \"Vanuatu\", \"Samoa\", \"Yemen\", \"South Africa\", \"Zambia\", \"Zimbabwe\")\n  ) %>%\n  col_is_character(\n    columns = vars(country_code_2)\n  ) %>%\n  col_vals_in_set(\n    columns = vars(country_code_2),\n    set = c(\"AD\", \"AE\", \"AF\", \"AG\", \"AI\", \"AL\", \"AM\", \"AO\", \"AQ\", \"AR\", \"AS\", \"AT\", \"AU\", \"AW\", \"AX\", \"AZ\", \"BA\", \"BB\", \"BD\", \"BE\", \"BF\", \"BG\", \"BH\", \"BI\", \"BJ\", \"BL\", \"BM\", \"BN\", \"BO\", \"BQ\", \"BR\", \"BS\", \"BT\", \"BV\", \"BW\", \"BY\", \"BZ\", \"CA\", \"CC\", \"CD\", \"CF\", \"CG\", \"CH\", \"CI\", \"CK\", \"CL\", \"CM\", \"CN\", \"CO\", \"CR\", \"CU\", \"CV\", \"CW\", \"CX\", \"CY\", \"CZ\", \"DE\", \"DJ\", \"DK\", \"DM\", \"DO\", \"DZ\", \"EC\", \"EE\", \"EG\", \"EH\", \"ER\", \"ES\", \"ET\", \"FI\", \"FJ\", \"FK\", \"FM\", \"FO\", \"FR\", \"GA\", \"GB\", \"GD\", \"GE\", \"GF\", \"GG\", \"GH\", \"GI\", \"GL\", \"GM\", \"GN\", \"GP\", \"GQ\", \"GR\", \"GS\", \"GT\", \"GU\", \"GW\", \"GY\", \"HK\", \"HM\", \"HN\", \"HR\", \"HT\", \"HU\", \"ID\", \"IE\", \"IL\", \"IM\", \"IN\", \"IO\", \"IQ\", \"IR\", \"IS\", \"IT\", \"JE\", \"JM\", \"JO\", \"JP\", \"KE\", \"KG\", \"KH\", \"KI\", \"KM\", \"KN\", \"KP\", \"KR\", \"KW\", \"KY\", \"KZ\", \"LA\", \"LB\", \"LC\", \"LI\", \"LK\", \"LR\", \"LS\", \"LT\", \"LU\", \"LV\", \"LY\", \"MA\", \"MC\", \"MD\", \"ME\", \"MF\", \"MG\", \"MH\", \"MK\", \"ML\", \"MM\", \"MN\", \"MO\", \"MP\", \"MQ\", \"MR\", \"MS\", \"MT\", \"MU\", \"MV\", \"MW\", \"MX\", \"MY\", \"MZ\", \"NA\", \"NC\", \"NE\", \"NF\", \"NG\", \"NI\", \"NL\", \"NO\", \"NP\", \"NR\", \"NU\", \"NZ\", \"OM\", \"PA\", \"PE\", \"PF\", \"PG\", \"PH\", \"PK\", \"PL\", \"PM\", \"PN\", \"PR\", \"PS\", \"PT\", \"PW\", \"PY\", \"QA\", \"RE\", \"RO\", \"RS\", \"RU\", \"RW\", \"SA\", \"SB\", \"SC\", \"SD\", \"SE\", \"SG\", \"SH\", \"SI\", \"SJ\", \"SK\", \"SL\", \"SM\", \"SN\", \"SO\", \"SR\", \"SS\", \"ST\", \"SV\", \"SX\", \"SY\", \"SZ\", \"TC\", \"TD\", \"TF\", \"TG\", \"TH\", \"TJ\", \"TK\", \"TL\", \"TM\", \"TN\", \"TO\", \"TR\", \"TT\", \"TV\", \"TW\", \"TZ\", \"UA\", \"UG\", \"UM\", \"US\", \"UY\", \"UZ\", \"VA\", \"VC\", \"VE\", \"VG\", \"VI\", \"VN\", \"VU\", \"WF\", \"WS\", \"YE\", \"YT\", \"ZA\", \"ZM\", \"ZW\")\n  ) %>%\n  col_is_character(\n    columns = vars(country_code_3)\n  ) %>%\n  col_vals_in_set(\n    columns = vars(country_code_3),\n    set = c(\"AND\", \"ARE\", \"AFG\", \"ATG\", \"AIA\", \"ALB\", \"ARM\", \"AGO\", \"ATA\", \"ARG\", \"ASM\", \"AUT\", \"AUS\", \"ABW\", \"ALA\", \"AZE\", \"BIH\", \"BRB\", \"BGD\", \"BEL\", \"BFA\", \"BGR\", \"BHR\", \"BDI\", \"BEN\", \"BLM\", \"BMU\", \"BRN\", \"BOL\", \"BES\", \"BRA\", \"BHS\", \"BTN\", \"BVT\", \"BWA\", \"BLR\", \"BLZ\", \"CAN\", \"CCK\", \"COD\", \"CAF\", \"COG\", \"CHE\", \"CIV\", \"COK\", \"CHL\", \"CMR\", \"CHN\", \"COL\", \"CRI\", \"CUB\", \"CPV\", \"CUW\", \"CXR\", \"CYP\", \"CZE\", \"DEU\", \"DJI\", \"DNK\", \"DMA\", \"DOM\", \"DZA\", \"ECU\", \"EST\", \"EGY\", \"ESH\", \"ERI\", \"ESP\", \"ETH\", \"FIN\", \"FJI\", \"FLK\", \"FSM\", \"FRO\", \"FRA\", \"GAB\", \"GBR\", \"GRD\", \"GEO\", \"GUF\", \"GGY\", \"GHA\", \"GIB\", \"GRL\", \"GMB\", \"GIN\", \"GLP\", \"GNQ\", \"GRC\", \"SGS\", \"GTM\", \"GUM\", \"GNB\", \"GUY\", \"HKG\", \"HMD\", \"HND\", \"HRV\", \"HTI\", \"HUN\", \"IDN\", \"IRL\", \"ISR\", \"IMN\", \"IND\", \"IOT\", \"IRQ\", \"IRN\", \"ISL\", \"ITA\", \"JEY\", \"JAM\", \"JOR\", \"JPN\", \"KEN\", \"KGZ\", \"KHM\", \"KIR\", \"COM\", \"KNA\", \"PRK\", \"KOR\", \"KWT\", \"CYM\", \"KAZ\", \"LAO\", \"LBN\", \"LCA\", \"LIE\", \"LKA\", \"LBR\", \"LSO\", \"LTU\", \"LUX\", \"LVA\", \"LBY\", \"MAR\", \"MCO\", \"MDA\", \"MNE\", \"MAF\", \"MDG\", \"MHL\", \"MKD\", \"MLI\", \"MMR\", \"MNG\", \"MAC\", \"MNP\", \"MTQ\", \"MRT\", \"MSR\", \"MLT\", \"MUS\", \"MDV\", \"MWI\", \"MEX\", \"MYS\", \"MOZ\", \"NAM\", \"NCL\", \"NER\", \"NFK\", \"NGA\", \"NIC\", \"NLD\", \"NOR\", \"NPL\", \"NRU\", \"NIU\", \"NZL\", \"OMN\", \"PAN\", \"PER\", \"PYF\", \"PNG\", \"PHL\", \"PAK\", \"POL\", \"SPM\", \"PCN\", \"PRI\", \"PSE\", \"PRT\", \"PLW\", \"PRY\", \"QAT\", \"REU\", \"ROU\", \"SRB\", \"RUS\", \"RWA\", \"SAU\", \"SLB\", \"SYC\", \"SDN\", \"SWE\", \"SGP\", \"SHN\", \"SVN\", \"SJM\", \"SVK\", \"SLE\", \"SMR\", \"SEN\", \"SOM\", \"SUR\", \"SSD\", \"STP\", \"SLV\", \"SXM\", \"SYR\", \"SWZ\", \"TCA\", \"TCD\", \"ATF\", \"TGO\", \"THA\", \"TJK\", \"TKL\", \"TLS\", \"TKM\", \"TUN\", \"TON\", \"TUR\", \"TTO\", \"TUV\", \"TWN\", \"TZA\", \"UKR\", \"UGA\", \"UMI\", \"USA\", \"URY\", \"UZB\", \"VAT\", \"VCT\", \"VEN\", \"VGB\", \"VIR\", \"VNM\", \"VUT\", \"WLF\", \"WSM\", \"YEM\", \"MYT\", \"ZAF\", \"ZMB\", \"ZWE\")\n  ) %>%\n  col_is_integer(\n    columns = vars(year)\n  ) %>%\n  col_vals_between(\n    columns = vars(year),\n    left = 1960,\n    right = 2017\n  ) %>%\n  col_is_integer(\n    columns = vars(population)\n  ) %>%\n  col_vals_between(\n    columns = vars(population),\n    left = 4279,\n    right = 1386395000,\n    na_pass = TRUE\n  ) %>%\n  rows_distinct() %>%\n  col_schema_match(\n    schema = col_schema(\n      country_name = \"character\",\n      country_code_2 = \"character\",\n      country_code_3 = \"character\",\n      year = \"integer\",\n      population = \"integer\"\n    )\n  ) %>%\n  interrogate()\n\nagent"

