% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_rmd.R
\name{validate_rmd}
\alias{validate_rmd}
\title{Perform \strong{pointblank} validation testing within R Markdown documents}
\usage{
validate_rmd(summary = TRUE, log_to_file = NULL)
}
\arguments{
\item{summary}{If \code{TRUE} (the default), then there will be a leading summary
of all validations in the rendered R Markdown document. With \code{FALSE}, this
element is not shown.}

\item{log_to_file}{An option to log errors to a text file. By default, no
logging is done but \code{TRUE} will write log entries to
\code{"validation_errors.log"} in the working directory. To both enable logging
and to specify a file name, include a path to a log file of the desired
name.}
}
\description{
The \code{validate_rmd()} function sets up a framework for validation testing
within specialized validation code chunks inside an R Markdown document. To
enable this functionality, \code{validate_rmd()} should be called early within an
R Markdown document code chunk (preferably in the \code{setup} chunk) to signal
that validation should occur within specific code chunks. The validation code
chunks require the \code{validate = TRUE} option to be set. Using \strong{pointblank}
validation functions on data in these marked code chunks will flag overall
failure if the stop threshold is exceeded anywhere. All errors are reported
in the validation code chunk after rendering the document to HTML, where a
centered status button either indicates success or the number of overall
failures. Clicking the button reveals the otherwise hidden validation
statements and their error messages (if any).
}
\section{Function ID}{

1-4
}

\seealso{
Other Planning and Prep: 
\code{\link{action_levels}()},
\code{\link{create_agent}()},
\code{\link{create_informant}()},
\code{\link{db_tbl}()},
\code{\link{draft_validation}()},
\code{\link{file_tbl}()},
\code{\link{scan_data}()},
\code{\link{tbl_get}()},
\code{\link{tbl_source}()},
\code{\link{tbl_store}()}
}
\concept{Planning and Prep}
