% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmd.R
\name{getchain}
\alias{getchain}
\title{Get reaction chain for specific mass to charge ratio}
\usage{
getchain(
  list,
  diff,
  mass,
  digits = 2,
  accuracy = 4,
  rtcutoff = 10,
  corcutoff = 0.6,
  ppm = 25
)
}
\arguments{
\item{list}{a list with mzrt profile}

\item{diff}{paired mass distance(s) of interests}

\item{mass}{a specific mass for known compound or a vector of masses. You could also input formula for certain compounds}

\item{digits}{mass or mass to charge ratio accuracy for pmd, default 2}

\item{accuracy}{measured mass or mass to charge ratio in digits, default 4}

\item{rtcutoff}{cutoff of the distances in retention time hierarchical clustering analysis, default 10}

\item{corcutoff}{cutoff of the correlation coefficient, default NULL}

\item{ppm}{all the peaks within this mass accuracy as seed mass or formula}
}
\value{
a list with mzrt profile and reaction chain dataframe
}
\description{
Get reaction chain for specific mass to charge ratio
}
\examples{
data(spmeinvivo)
# check metabolites of C18H39NO
pmd <- getchain(spmeinvivo,diff = c(2.02,14.02,15.99),mass = 286.3101)
}
