% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_edge_label.R
\name{adjust_edge_label}
\alias{adjust_edge_label}
\title{Adjust edge label}
\usage{
adjust_edge_label(p, label = c(
   "amount",
   "mean_duration",
   "median_duration",
   "max_duration",
   "min_duration"
 ))
}
\arguments{
\item{p}{The process map generated by \code{create_pmap()}}

\item{label}{Specify which attribute is used for the edge label.}
}
\description{
The edge label is assigned when creating the process map by \code{create_pmap()}, however, it can be changed by this function.
}
\examples{
 library(dplyr)
 p <- generate_eventlog() \%>\% create_pmap()
 p <- adjust_edge_label(p, label = "mean_duration")
}
