% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{write_pnml}
\alias{write_pnml}
\title{Write Petri net as PNML}
\usage{
write_pnml(petrinet, file, initial_marking = NULL,
  final_marking = NULL)
}
\arguments{
\item{petrinet}{A bupaR or PM4PY Petri net.}

\item{file}{File name of the PNML file}

\item{initial_marking}{A R vector with the place identifiers of the initial marking or a PM4PY marking.
By default the initial marking of the bupaR Petri net will be used if available.}

\item{final_marking}{A R vector with the place identifiers of the final marking or a PM4PY marking.}
}
\description{
Write Petri net as PNML
}
\examples{
# don't test automatically since this writes a file
\donttest{
if (pm4py_available()) {
  library(eventdataR)
  data(patients)

  # As Inductive Miner of PM4PY is not life-cycle aware, keep only `complete` events:
  patients_completes <- patients[patients$registration_type == "complete", ]

  net <- discovery_inductive(patients_completes)
  write_pnml(net$petrinet,
             "test.pnml",
             net$initial_marking,
             net$final_marking)
}
}

}
