% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plu_ralize.R
\name{plu_ralize}
\alias{plu_ralize}
\alias{ralize}
\title{Pluralize a word}
\source{
Irregular plurals list adapted from the Automatically Generated
Inflection Database (AGID).

See \link{plu-package} for more details.
}
\usage{
plu_ralize(
  x,
  irregulars = getOption("plu.irregulars", c("moderate", "conservative", "liberal",
    "none"))
)

ralize(
  x,
  irregulars = getOption("plu.irregulars", c("moderate", "conservative", "liberal",
    "none"))
)
}
\arguments{
\item{x}{A character vector of English words to be pluralized}

\item{irregulars}{What level of irregularity to use in pluralization.
\code{"moderate"} uses the most common pluralization.
\code{"conservative"} uses the most common irregular plural if one exists,
even if a regular plural is more common.
\code{"liberal"} uses a regular plural if it exists, even if an irregular
plural is more common.
\code{"none"} attempts to apply regular noun pluralization rules to all words.
Defaults to \code{"moderate"}.
The default can be changed by setting \code{options(plu.irregulars)}.
See examples.}
}
\value{
The character vector \code{x} pluralized
}
\description{
Pluralize a word
}
\examples{
plu::ralize("word")
plu::ralize(c("group", "word"))

plu::ralize(c("formula", "person", "child"), irregulars = "conservative")
plu::ralize(c("formula", "person", "child"), irregulars = "moderate")
plu::ralize(c("formula", "person", "child"), irregulars = "liberal")
plu::ralize(c("formula", "person", "child"), irregulars = "none")
}
\seealso{
\code{\link[=ral]{ral()}} to pluralize an English phrase based on a condition
}
