% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.lower.bound.R
\name{compute.lower.bound}
\alias{compute.lower.bound}
\title{Lower bound for the Degrees of Freedom}
\usage{
compute.lower.bound(X)
}
\arguments{
\item{X}{matrix of predictor observations.}
}
\value{
\item{bound}{logical. bound is \code{TRUE} if the decay of the
eigenvalues is slow enough} \item{lower.bound}{if bound is TRUE, this is the
lower bound, otherwise, it is set to -1}
}
\description{
This function computes the lower bound for the the Degrees of Freedom of PLS
with 1 component.
}
\details{
If the decay of the eigenvalues of \code{cor(X)} is not too fast, we can
lower-bound the Degrees of Freedom of PLS with 1 component. Note that we
implicitly assume that we use scaled predictor variables to compute the PLS
solution.
}
\examples{

# Boston Housing data
library(MASS)
data(Boston)
X<-Boston[,-14]
my.lower<-compute.lower.bound(X)

}
\references{
Kraemer, N., Sugiyama M. (2011). "The Degrees of Freedom of Partial Least
Squares Regression". Journal of the American Statistical Association 106
(494) \url{https://www.tandfonline.com/doi/abs/10.1198/jasa.2011.tm10107}
}
\seealso{
\code{\link{pls.model}}
}
\author{
Nicole Kraemer
}
\keyword{math}
