% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trunc.R
\name{truncation}
\alias{truncation}
\title{Trunction PLS}
\usage{
truncation(..., Y.add, weights, method = "truncation")
}
\arguments{
\item{...}{arguments passed on to \code{mvrV}).}

\item{Y.add}{optional additional response vector/matrix found in the input data.}

\item{weights}{optional object weighting vector.}

\item{method}{choice (default = \code{truncation}).}
}
\value{
Returns an object of class mvrV, simliar to to mvr object of the pls package.
}
\description{
Distribution based truncation for variable selection in subspace 
methods for multivariate regression.
}
\details{
Loading weights are truncated around their median based on confidence intervals
for modelling without replicates (Lenth et al.). The arguments passed to \code{mvrV} include
all possible arguments to \code{\link[pls]{cppls}} and the following truncation parameters 
(with defaults) trunc.pow=FALSE, truncation=NULL, trunc.width=NULL, trunc.weight=0, 
reorth=FALSE, symmetric=FALSE.

The default way of performing truncation involves the following parameter values:
truncation="Lenth", trunc.width=0.95, indicating Lenth's confidence intervals (assymmetric),
with a confidence of 95%. trunc.weight can be set to a number between 0 and 1 to give a
shrinkage instead of a hard threshold. An alternative truncation strategy can be used with:
truncation="quantile", in which a quantile line is used for detecting outliers/inliers.
}
\examples{
data(yarn, package = "pls")
tr <- truncation(density ~ NIR, ncomp=5, data=yarn, validation="CV",
 truncation="Lenth", trunc.width=0.95) # Default truncation
summary(tr)

}
\references{
K.H. Liland, M. Høy, H. Martens, S. Sæbø: Distribution based truncation for 
variable selection in subspace methods for multivariate regression, Chemometrics and
Intelligent Laboratory Systems 122 (2013) 103-111.
}
\seealso{
\code{\link{VIP}} (SR/sMC/LW/RC), \code{\link{filterPLSR}}, \code{\link{shaving}}, 
\code{\link{stpls}}, \code{\link{truncation}},
\code{\link{bve_pls}}, \code{\link{ga_pls}}, \code{\link{ipw_pls}}, \code{\link{mcuve_pls}},
\code{\link{rep_pls}}, \code{\link{spa_pls}},
\code{\link{lda_from_pls}}, \code{\link{lda_from_pls_cv}}, \code{\link{setDA}}.
}
\author{
Kristian Hovde Liland.
}
