% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kfolds2Chisqind.R
\name{kfolds2Chisqind}
\alias{kfolds2Chisqind}
\title{Computes individual Predicted Chisquare for kfold cross validated partial
least squares beta regression models.}
\usage{
kfolds2Chisqind(pls_kfolds)
}
\arguments{
\item{pls_kfolds}{a kfold cross validated partial least squares regression
glm model}
}
\value{
\item{list}{Individual PChisq vs number of components for the first
group partition} \item{list()}{\dots{}} \item{list}{Individual PChisq vs
number of components for the last group partition}
}
\description{
This function computes individual Predicted Chisquare for kfold cross
validated partial least squares beta regression models.
}
\note{
Use \code{\link{PLS_beta_kfoldcv}} to create kfold cross validated
partial least squares regression glm models.
}
\examples{

\dontrun{
data("GasolineYield",package="betareg")
yGasolineYield <- GasolineYield$yield
XGasolineYield <- GasolineYield[,2:5]
bbb <- PLS_beta_kfoldcv(yGasolineYield,XGasolineYield,nt=3,modele="pls-beta")
kfolds2Chisqind(bbb)
}

}
\references{
Frédéric Bertrand, Nicolas Meyer,
Michèle Beau-Faller, Karim El Bayed, Izzie-Jacques Namer,
Myriam Maumy-Bertrand (2013). Régression Bêta
PLS. \emph{Journal de la Société Française de Statistique},
\bold{154}(3):143-159.
\url{http://publications-sfds.math.cnrs.fr/index.php/J-SFdS/article/view/215}
}
\seealso{
\code{\link[plsRglm]{kfolds2coeff}},
\code{\link[plsRglm]{kfolds2Press}}, \code{\link[plsRglm]{kfolds2Pressind}},
\code{\link{kfolds2Chisq}}, \code{\link[plsRglm]{kfolds2Mclassedind}} and
\code{\link[plsRglm]{kfolds2Mclassed}} to extract and transforms results
from kfold cross validation.
}
\author{
Frédéric Bertrand\cr
\email{frederic.bertrand@math.unistra.fr}\cr
\url{http://www-irma.u-strasbg.fr/~fbertran/}
}
\keyword{models}
\keyword{regression}
