### mvr_wrappers.R: plsr, pls and pcr wrappers for mvr
### $Id: mvr_wrappers.R 167 2007-11-21 14:32:14Z bhm $

plsr <- function(..., method = pls.options()$plsralg)
{
    cl <- match.call()
    cl$method <- match.arg(method, c("kernelpls", "widekernelpls", "simpls",
                                     "oscorespls", "model.frame"))
    cl[[1]] <- as.name("mvr")
    res <- eval(cl, parent.frame())
    ## Fix call component
    if (cl$method != "model.frame") res$call[[1]] <- as.name("plsr")
    if (missing(method)) res$call$method <- NULL
    res
}

pcr <- function(..., method = pls.options()$pcralg)
{
    cl <- match.call()
    cl$method <- match.arg(method, c("svdpc", "model.frame"))
    cl[[1]] <- as.name("mvr")
    res <- eval(cl, parent.frame())
    ## Fix call component
    if (cl$method != "model.frame") res$call[[1]] <- as.name("pcr")
    if (missing(method)) res$call$method <- NULL
    res
}
