% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corplot.R
\name{CorPairsPlot}
\alias{CorPairsPlot}
\title{CorPairsPlot}
\usage{
CorPairsPlot(
  data,
  columns = NULL,
  group_by = NULL,
  group_by_sep = "_",
  group_name = NULL,
  split_by = NULL,
  split_by_sep = "_",
  diag_type = NULL,
  diag_args = list(),
  layout = c(".\\\\", "\\\\.", "/.", "./"),
  cor_method = c("pearson", "spearman", "kendall"),
  cor_palette = "RdBu",
  cor_palcolor = NULL,
  cor_size = 3,
  cor_format = "corr: {round(corr, 2)}",
  cor_fg = "black",
  cor_bg = "white",
  cor_bg_r = 0.1,
  theme = "theme_this",
  theme_args = list(),
  palette = ifelse(is.null(group_by), "Spectral", "Paired"),
  palcolor = NULL,
  title = NULL,
  subtitle = NULL,
  facet_by = NULL,
  legend.position = "right",
  legend.direction = "vertical",
  seed = 8525,
  combine = TRUE,
  nrow = NULL,
  ncol = NULL,
  byrow = TRUE,
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{columns}{The column names of the data to be plotted.
If NULL, all columns, except \code{group_by}, will be used.}

\item{group_by}{Columns to group the data for plotting
For those plotting functions that do not support multiple groups,
They will be concatenated into one column, using \code{group_by_sep} as the separator}

\item{group_by_sep}{The separator for multiple group_by columns. See \code{group_by}}

\item{group_name}{The name of the group in the legend.}

\item{split_by}{The column(s) to split data by and plot separately.}

\item{split_by_sep}{The separator for multiple split_by columns. See \code{split_by}}

\item{diag_type}{The type of the diagonal plots.
Available types: "density", "violin", "histogram", "box", "none".}

\item{diag_args}{A list of additional arguments to be passed to the diagonal plots.}

\item{layout}{The layout of the plots.
Available layouts: ".\\", "\\.", "/.", "./".
\itemize{
\item '\\' or '/' means the diagonal plots are on the top-left to bottom-right diagonal.
\item '.' means where the scatter plots are.
}}

\item{cor_method}{The method to calculate the correlation.
Available methods: "pearson", "spearman", "kendall".
The correlation will be shown in the other triangle of the scatter plots.}

\item{cor_palette}{The color palette for the correlation tile plots.}

\item{cor_palcolor}{Custom colors used to create a color palette for the correlation tile plots.}

\item{cor_size}{The size of the correlation text.}

\item{cor_format}{The format of the correlation text. Default is "corr: \%.2f".
It will be formatted using \code{sprintf(cor_format, corr)}.}

\item{cor_fg}{The color of the correlation text.}

\item{cor_bg}{The background color of the correlation text.}

\item{cor_bg_r}{The radius of the background of the correlation text.}

\item{theme}{A character string or a theme class (i.e. ggplot2::theme_classic) specifying the theme to use.
Default is "theme_this".}

\item{theme_args}{A list of arguments to pass to the theme function.}

\item{palette}{A character string specifying the palette to use.}

\item{palcolor}{A character string specifying the color to use in the palette.}

\item{title}{A character string specifying the title of the plot.
A function can be used to generate the title based on the default title.
This is useful when split_by is used and the title needs to be dynamic.}

\item{subtitle}{A character string specifying the subtitle of the plot.}

\item{facet_by}{A character string specifying the column name of the data frame to facet the plot.
Otherwise, the data will be split by \code{split_by} and generate multiple plots
and combine them into one using \code{patchwork::wrap_plots}}

\item{legend.position}{A character string specifying the position of the legend.
if \code{waiver()}, for single groups, the legend will be "none", otherwise "right".}

\item{legend.direction}{A character string specifying the direction of the legend.}

\item{seed}{The random seed to use. Default is 8525.}

\item{combine}{Whether to combine the plots into one when facet is FALSE. Default is TRUE.}

\item{nrow}{A numeric value specifying the number of rows in the facet.}

\item{ncol}{A numeric value specifying the number of columns in the facet.}

\item{byrow}{A logical value indicating whether to fill the plots by row.}

\item{...}{Additional arguments.}
}
\value{
A \code{patch_work::wrap_plots} object or a list of them if \code{combine} is \code{FALSE}.
}
\description{
Generate a grid of scatter correlation plots for all pairs of variables.
}
\examples{
\donttest{
set.seed(8525)
data <- data.frame(x = rnorm(100))
data$y <- rnorm(100, 10, sd = 0.5)
data$z <- -data$x + data$y + rnorm(100, 20, 1)
data$g <- sample(1:4, 100, replace = TRUE)

CorPairsPlot(data, diag_type = "histogram", diag_args = list(bins = 30, palette = "Paired"),
 layout = "/.")

CorPairsPlot(data, group_by = "g", diag_type = "none", layout = "./",
 theme_args = list(axis.title = element_textbox(
     color = "black", box.color = "grey20", size = 16, halign = 0.5, fill = "grey90",
     linetype = 1, width = grid::unit(1, "npc"), padding = ggplot2::margin(5, 5, 5, 5))))

CorPairsPlot(data, group_by = "g", diag_type = "violin", layout = "\\\\.",
  cor_format = "{x}\n{y}\ncorr: {round(corr, 2)}")

CorPairsPlot(data, split_by = "g", diag_type = "none", layout = ".\\\\",
 legend.position = "bottom", legend.direction = "horizontal", group_name = "group")
}
}
