% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rectxy.R
\name{rectxy}
\alias{rectxy}
\title{Generating Coordinates of Multiple Rectangles}
\usage{
rectxy(
  x = 0,
  y = 0,
  a = 1,
  b = 1,
  angle = 0,
  xytype = "middle",
  group = TRUE,
  todf = TRUE,
  checks = TRUE
)
}
\arguments{
\item{x}{the x coordinates of relative points. 
Its length can be larger than 1.
See \code{xytype}.}

\item{y}{the y coordinates of relative points. 
Its length can be larger than 1.
See \code{xytype}.}

\item{a}{the side that is parallel to 
x-axis before rotation. Its length can be larger than 1.}

\item{b}{the side that is parallel to 
y-axis before rotation. Its length can be larger than 1.}

\item{angle}{default is 0. The rotation angle in radian.
Note: "radian = degree * pi / 180". Its length can be 
larger than 1.
The rotation direction is anti-clockwise.}

\item{xytype}{should be one of "middle/center" (default), 
"bottomleft", "middleleft/centerleft/left". 
It indicates the type of argument 
of the middle point of an shape. If it is "middleleft", x and 
y are the middle-left coordinates before rotation. If it is 
"bottomleft", x and y are the coordinates of the 
bottom-left corner.}

\item{group}{default is TRUE. It indicates 
whether to add a 3rd column named 
"g" to label the group number of each group of points. It is useful 
when using \code{aes(...group=g)} with 'ggplot2'.}

\item{todf}{default is TRUE. It indicates whether to 
combine the output (a list) into a data frame.}

\item{checks}{default is TRUE. It indicates whether 
to check input validity. Do not turn it off unless you are sure 
that the input is OK.}
}
\value{
if \code{todf = TRUE}, the output will be a data frame
with coordinates of possibly several polygons, otherwise, 
it will be a list of data frames. Data frames have 2 columns
named "x" and "y", and if \code{group = TRUE}, a third column 
named "g" is added indicating group numbers.
}
\description{
Note: the shapes are correct  
only when \code{ggplot2::coord_fixed()} is used.
}
\examples{
library(ggplot2)
dat1=rectxy(x=4, y=3, a=2, b=1, angle=0, xytype="bottomleft", todf=TRUE) 
dat2=rectxy(x=4, y=3, a=2, b=1, angle=pi/6, xytype="bottomleft", todf=TRUE)
ggplot()+
	geom_polygon(data=dat1, aes(x=x, y=y), fill="red", alpha=0.3)+
	geom_polygon(data=dat2, aes(x=x, y=y), fill="blue", alpha=0.3)+	
	coord_fixed()
}
