% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repeat_as_list.R
\name{repeat_as_list}
\alias{repeat_as_list}
\title{Replicating Any Object to Form a List}
\usage{
repeat_as_list(x, times = 1, labels = NULL)
}
\arguments{
\item{x}{any object to be replicate. It can be 
a vector, a data frame, NA, NULL, etc.}

\item{times}{a single integer 
giving the number of times to repeat x.}

\item{labels}{the names for the elements of 
the output list. Its lengths should be equal to 
argument \code{times}. Default is NULL which 
means no name is added.}
}
\description{
This is a convenient function to replicate an 
object to form a list (and to give names to 
its elements).
}
\examples{
a=data.frame(x=1: 3, y=4: 6)
aa=repeat_as_list(a, 2, labels=c("d1", "d2"))
}
